/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private boolean changed = false;
    protected AbstractInterpreterEditor pathEditor;

    protected abstract AbstractInterpreterEditor getInterpreterEditor(Composite var1);

    protected abstract void doRestore(String var1, IProgressMonitor var2);

    protected abstract IInterpreterManager getInterpreterManager();

    public AbstractInterpreterPreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.changed = false;
    }

    protected boolean hasChanged() {
        return this.changed || this.isEditorChanged();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.changed = true;
        super.performApply();
    }

    protected void performDefaults() {
    }

    public boolean performCancel() {
        this.changed = false;
        return super.performCancel();
    }

    public boolean performOk() {
        super.performOk();
        if (this.hasChanged()) {
            this.restoreModules();
        }
        this.getInterpreterManager().saveInterpretersInfoModulesManager();
        this.changed = false;
        this.setEditorUnchanged();
        return true;
    }

    protected void doClear(List<String> allButTheseInterpreters, IProgressMonitor monitor) {
        IInterpreterManager iMan = this.getInterpreterManager();
        iMan.clearAllBut(allButTheseInterpreters);
    }

    protected boolean isEditorChanged() {
        return this.pathEditor.hasChanged();
    }

    protected void setEditorUnchanged() {
        this.pathEditor.changed = false;
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.pathEditor = this.getInterpreterEditor(p);
        this.addField(this.pathEditor);
    }

    protected void restoreModules() {
        String[] items;
        if (this.pathEditor.getExesList().getItemCount() <= 0) {
            this.doClear(new ArrayList<String>(), (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        final String item = this.pathEditor.getExesList().getItem(0);
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
        monitorDialog.setBlockOnOpen(false);
        final ArrayList<String> exesToKeep = new ArrayList<String>();
        org.eclipse.swt.widgets.List exesList = this.pathEditor.getExesList();
        String[] stringArray = items = exesList.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String exeToKeep = stringArray[n2];
            exesToKeep.add(exeToKeep);
            ++n2;
        }
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Restoring PYTHONPATH", -1);
                    AbstractInterpreterPreferencesPage.this.doClear(exesToKeep, monitor);
                    AbstractInterpreterPreferencesPage.this.doRestore(item, monitor);
                    monitor.done();
                }
            };
            monitorDialog.run(true, true, operation);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }
}

