/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.python.pydev.plugin.PydevPlugin;

public abstract class PyContainerAction {
    protected List<IContainer> selectedContainers;

    protected abstract boolean confirmRun();

    protected abstract void afterRun(int var1);

    protected abstract int doActionOnContainer(IContainer var1);

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.selectedContainers = null;
            return;
        }
        IStructuredSelection selections = (IStructuredSelection)selection;
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        Iterator it = selections.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IContainer)) continue;
            containers.add((IContainer)o);
        }
        this.selectedContainers = containers;
    }

    public void run(IAction action) {
        if (this.selectedContainers == null) {
            return;
        }
        if (!this.confirmRun()) {
            return;
        }
        int nDeleted = 0;
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        Iterator<IContainer> iter = this.selectedContainers.iterator();
        while (iter.hasNext()) {
            IContainer next = iter.next();
            try {
                next.refreshLocal(2, (IProgressMonitor)nullProgressMonitor);
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
            nDeleted += this.doActionOnContainer(next);
        }
        this.afterRun(nDeleted);
    }
}

