/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import com.rc.retroweaver.runtime.ClassLiteral;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.editors.TreeWithAddRemove;

public class PyProjectProperties
extends PropertyPage {
    private IProject project;
    private TreeWithAddRemove treeSourceFolders;
    private TreeWithAddRemove treeExternalLibs;

    protected Control createContents(Composite p) {
        this.project = (IProject)this.getElement().getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IProject"));
        Composite topComp = new Composite(p, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 1;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        topComp.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        GridData data = new GridData();
        if (this.project != null) {
            try {
                String sourcePath = PythonNature.getPythonPathNature(this.project).getProjectSourcePath();
                String externalSourcePath = PythonNature.getPythonPathNature(this.project).getProjectExternalSourcePath();
                Label l2 = new Label(topComp, 0);
                l2.setText("Project Source Folders (and zips/jars/eggs).");
                gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.grabExcessVerticalSpace = false;
                l2.setLayoutData((Object)gd);
                this.treeSourceFolders = new TreeWithAddRemove(topComp, 0, this.project, sourcePath);
                data = new GridData(1808);
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = true;
                this.treeSourceFolders.setLayoutData(data);
                l2 = new Label(topComp, 0);
                l2.setText("External Source Folders (and zips/jars/eggs).");
                gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.grabExcessVerticalSpace = false;
                l2.setLayoutData((Object)gd);
                this.treeExternalLibs = new TreeWithAddRemove(topComp, 0, this.project, externalSourcePath){

                    protected String getImageConstant() {
                        return "icons/jar_l_obj.gif";
                    }

                    protected Object getSelectionDialogAddSourceFolder() {
                        return new DirectoryDialog(this.getShell());
                    }

                    protected Object getSelectionDialogAddZip() {
                        return new FileDialog(this.getShell());
                    }
                };
                data = new GridData(1808);
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = true;
                this.treeExternalLibs.setLayoutData(data);
                Button button = new Button(topComp, 0);
                button.setText("Force restore internal info");
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        PyProjectProperties.this.doIt(true);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
        return topComp;
    }

    protected void performApply() {
        this.doIt(false);
    }

    public boolean performOk() {
        return this.doIt(false);
    }

    private boolean doIt(boolean force) {
        if (this.project != null) {
            try {
                PythonNature pythonNature;
                boolean changed = false;
                IPythonPathNature pythonPathNature = PythonNature.getPythonPathNature(this.project);
                String sourcePath = pythonPathNature.getProjectSourcePath();
                String externalSourcePath = pythonPathNature.getProjectExternalSourcePath();
                String newSourcePath = this.treeSourceFolders.getTreeItemsAsStr();
                String newExternalSourcePath = this.treeExternalLibs.getTreeItemsAsStr();
                if (sourcePath == null || !sourcePath.equals(newSourcePath)) {
                    pythonPathNature.setProjectSourcePath(newSourcePath);
                    changed = true;
                }
                if (externalSourcePath == null || !externalSourcePath.equals(newExternalSourcePath)) {
                    pythonPathNature.setProjectExternalSourcePath(newExternalSourcePath);
                    changed = true;
                }
                if ((pythonNature = PythonNature.getPythonNature(this.project)) != null && (changed || force || pythonNature.getAstManager() == null)) {
                    pythonNature.rebuildPath();
                }
            }
            catch (Exception e) {
                PydevPlugin.log(4, "Unexpected error setting project properties", e);
            }
        }
        return true;
    }
}

