/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import java.util.HashSet;
import java.util.Iterator;
import org.python.pydev.core.IToken;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.List;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalModelVisitor
extends AbstractVisitor {
    private int visitWhat;
    private SourceToken __all__;
    private Assign __all__Assign;
    private exprType[] __all__AssignTargets;
    private Assign lastAssign;
    private boolean onlyAllowTokensIn__all__;

    public GlobalModelVisitor(int visitWhat, String moduleName, boolean onlyAllowTokensIn__all__) {
        this(visitWhat, moduleName, onlyAllowTokensIn__all__, false);
    }

    public GlobalModelVisitor(int visitWhat, String moduleName, boolean onlyAllowTokensIn__all__, boolean lookingInLocalContext) {
        this.visitWhat = visitWhat;
        this.moduleName = moduleName;
        this.onlyAllowTokensIn__all__ = onlyAllowTokensIn__all__;
        if (moduleName != null && moduleName.endsWith("__init__")) {
            this.tokens.add(new SourceToken((SimpleNode)new Name("__path__", 1, false), "__path__", "", "", moduleName));
        }
        if (!lookingInLocalContext && (this.visitWhat & 1) != 0) {
            this.tokens.add(new SourceToken((SimpleNode)new Name("__file__", 1, false), "__file__", "", "", moduleName));
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        if ((this.visitWhat & 1) != 0) {
            this.addToken((SimpleNode)node);
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if ((this.visitWhat & 1) != 0) {
            this.addToken((SimpleNode)node);
        }
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.lastAssign = node;
        node.traverse((VisitorIF)this);
        return null;
    }

    public Object visitName(Name node) throws Exception {
        if ((this.visitWhat & 1) != 0) {
            if (node.ctx == 2) {
                SourceToken added = this.addToken((SimpleNode)node);
                if (added.getRepresentation().equals("__all__") && this.__all__Assign == null) {
                    this.__all__ = added;
                    this.__all__Assign = this.lastAssign;
                    this.__all__AssignTargets = this.lastAssign.targets;
                }
            } else if (node.ctx == 1 && node.id.equals("__all__")) {
                this.__all__AssignTargets = null;
            }
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        if ((this.visitWhat & 2) != 0) {
            GlobalModelVisitor.makeWildImportToken(node, this.tokens, this.moduleName);
        }
        if ((this.visitWhat & 4) != 0) {
            GlobalModelVisitor.makeImportToken(node, (java.util.List<IToken>)this.tokens, this.moduleName, true);
        }
        return null;
    }

    public Object visitImport(Import node) throws Exception {
        if ((this.visitWhat & 4) != 0) {
            GlobalModelVisitor.makeImportToken(node, (java.util.List<IToken>)this.tokens, this.moduleName, true);
        }
        return null;
    }

    public Object visitStr(Str node) throws Exception {
        if ((this.visitWhat & 8) != 0) {
            this.tokens.add(new SourceToken((SimpleNode)node, node.s, "", "", this.moduleName));
        }
        return null;
    }

    @Override
    protected void finishVisit() {
        if (this.onlyAllowTokensIn__all__) {
            this.filterAll(this.tokens);
        }
    }

    public void filterAll(java.util.List<IToken> tokens) {
        if (this.__all__ != null) {
            SimpleNode ast = this.__all__.getAst();
            if (this.__all__AssignTargets != null && this.__all__AssignTargets.length == 1 && this.__all__AssignTargets[0] == ast) {
                HashSet<String> validTokensInAll = new HashSet<String>();
                exprType value = this.__all__Assign.value;
                if (value instanceof List) {
                    List valueList = (List)value;
                    if (valueList.elts != null) {
                        exprType[] exprTypeArray = valueList.elts;
                        int n = valueList.elts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            exprType elt = exprTypeArray[n2];
                            if (elt instanceof Str) {
                                Str str = (Str)elt;
                                validTokensInAll.add(str.s);
                            }
                            ++n2;
                        }
                    }
                }
                if (validTokensInAll.size() > 0) {
                    Iterator<IToken> it = tokens.iterator();
                    while (it.hasNext()) {
                        IToken tok = it.next();
                        if (validTokensInAll.contains(tok.getRepresentation())) continue;
                        it.remove();
                    }
                }
            }
        }
    }
}

