/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.File;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;

public class CompletionRequest
implements ICompletionRequest {
    public File editorFile;
    public IPythonNature nature;
    public IDocument doc;
    public String activationToken;
    public String qualifier;
    public String fullQualifier;
    public int documentOffset;
    public int qlen;
    public IPyCodeCompletion codeCompletion;
    public boolean isInCalltip;
    public boolean alreadyHasParams;
    private PySelection ps;
    public boolean showTemplates = true;
    private String initialModule;

    public CompletionRequest(File editorFile, IPythonNature nature, IDocument doc, String activationToken, int documentOffset, int qlen, IPyCodeCompletion codeCompletion, String qualifier) {
        this.editorFile = editorFile;
        this.nature = nature;
        this.doc = doc;
        this.activationToken = activationToken;
        this.documentOffset = documentOffset;
        this.qlen = qlen;
        this.codeCompletion = codeCompletion;
        this.qualifier = qualifier;
    }

    public CompletionRequest(File editorFile, IPythonNature nature, IDocument doc, int documentOffset, IPyCodeCompletion codeCompletion) {
        this.doc = doc;
        this.documentOffset = documentOffset;
        PySelection.ActivationTokenAndQual act = this.getPySelection().getActivationTokenAndQual(false, true);
        this.activationToken = act.activationToken;
        this.qualifier = act.qualifier;
        this.isInCalltip = act.changedForCalltip;
        this.alreadyHasParams = act.alreadyHasParams;
        int qlen = this.qualifier.length();
        this.editorFile = editorFile;
        this.nature = nature;
        this.qlen = qlen;
        this.codeCompletion = codeCompletion;
        this.fullQualifier = this.getPySelection().getActivationTokenAndQual(true)[1];
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("CompletionRequest[");
        buffer.append(" editorFile:");
        buffer.appendObject((Object)this.editorFile);
        buffer.append(" activationToken:");
        buffer.append(this.activationToken);
        buffer.append(" qualifier:");
        buffer.append(this.qualifier);
        buffer.append(" isInCalltip:");
        buffer.append(this.isInCalltip);
        buffer.append(" alreadyHasParams:");
        buffer.append(this.alreadyHasParams);
        buffer.append("]");
        return buffer.toString();
    }

    public PySelection getPySelection() {
        if (this.ps == null) {
            this.ps = new PySelection(this.doc, this.documentOffset);
        }
        return this.ps;
    }

    public String resolveModule() {
        if (this.initialModule == null && this.editorFile != null) {
            this.initialModule = this.nature.resolveModule(this.editorFile);
        }
        return this.initialModule;
    }
}

