/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.autoedit;

import org.python.pydev.core.cache.PyPreferencesCache;
import org.python.pydev.editor.autoedit.AbstractIndentPrefs;
import org.python.pydev.editor.autoedit.IIndentPrefs;
import org.python.pydev.plugin.PydevPlugin;

public class DefaultIndentPrefs
extends AbstractIndentPrefs {
    private String indentString = null;
    private boolean useSpaces;
    private int tabWidth;
    private static PyPreferencesCache cache;
    private static IIndentPrefs indentPrefs;

    public static synchronized IIndentPrefs get() {
        if (indentPrefs == null) {
            indentPrefs = new DefaultIndentPrefs();
        }
        return indentPrefs;
    }

    private PyPreferencesCache getCache() {
        if (cache == null) {
            cache = new PyPreferencesCache(PydevPlugin.getDefault().getPreferenceStore());
        }
        return cache;
    }

    DefaultIndentPrefs() {
        PyPreferencesCache c = this.getCache();
        this.useSpaces = c.getBoolean("SUBSTITUTE_TABS");
        this.tabWidth = c.getInt("TAB_WIDTH", 4);
    }

    public boolean getUseSpaces() {
        PyPreferencesCache c = this.getCache();
        if (this.useSpaces != c.getBoolean("SUBSTITUTE_TABS")) {
            this.useSpaces = c.getBoolean("SUBSTITUTE_TABS");
            this.regenerateIndentString();
        }
        return this.useSpaces;
    }

    public static int getStaticTabWidth() {
        PydevPlugin default1 = PydevPlugin.getDefault();
        if (default1 == null) {
            return 4;
        }
        int w = default1.getPluginPreferences().getInt("TAB_WIDTH");
        if (w <= 0) {
            w = 4;
        }
        return w;
    }

    public int getTabWidth() {
        PyPreferencesCache c = this.getCache();
        if (this.tabWidth != c.getInt("TAB_WIDTH", 4)) {
            this.tabWidth = c.getInt("TAB_WIDTH", 4);
            this.regenerateIndentString();
        }
        return this.tabWidth;
    }

    public void regenerateIndentString() {
        PyPreferencesCache c = this.getCache();
        c.clear("TAB_WIDTH");
        c.clear("SUBSTITUTE_TABS");
        this.indentString = super.getIndentationString();
    }

    public String getIndentationString() {
        if (this.indentString == null) {
            this.regenerateIndentString();
        }
        return this.indentString;
    }

    public boolean getAutoParentesis() {
        return this.getCache().getBoolean("AUTO_PAR");
    }

    public boolean getIndentToParLevel() {
        return this.getCache().getBoolean("AUTO_INDENT_TO_PAR_LEVEL");
    }

    public boolean getAutoColon() {
        return this.getCache().getBoolean("AUTO_COLON");
    }

    public boolean getAutoBraces() {
        return this.getCache().getBoolean("AUTO_BRACES");
    }

    public boolean getAutoWriteImport() {
        return this.getCache().getBoolean("AUTO_WRITE_IMPORT_STR");
    }

    public boolean getSmartIndentPar() {
        return this.getCache().getBoolean("SMART_INDENT_PAR");
    }

    public boolean getAutoAddSelf() {
        return this.getCache().getBoolean("AUTO_ADD_SELF");
    }

    public boolean getAutoDedentElse() {
        return this.getCache().getBoolean("AUTO_DEDENT_ELSE");
    }
}

