/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PyPartitionScanner;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.editor.ActionInfo;
import org.python.pydev.editor.IPyEditListener;
import org.python.pydev.editor.IPyEditListener2;
import org.python.pydev.editor.OfflineActionsManager;
import org.python.pydev.editor.PyEditConfiguration;
import org.python.pydev.editor.PyEditNotifier;
import org.python.pydev.editor.actions.OfflineAction;
import org.python.pydev.editor.actions.OfflineActionTarget;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.PyBackspace;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.autoedit.IIndentPrefs;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.editor.codefolding.CodeFoldingSetter;
import org.python.pydev.editor.codefolding.PyEditProjection;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.model.IModelListener;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.preferences.PydevEditorPrefs;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.editor.scripting.PyEditScripting;
import org.python.pydev.editorinput.PyOpenEditor;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.ErrorDescription;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.PyParserManager;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.ColorCache;
import org.python.pydev.ui.NotConfiguredInterpreterException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyEdit
extends PyEditProjection
implements IPyEdit {
    public static final String PY_EDIT_CONTEXT = "#PyEditContext";
    public static final String EDITOR_ID = "org.python.pydev.editor.PythonEditor";
    public static final String ACTION_OPEN = "OpenEditor";
    private ColorCache colorCache;
    private Preferences.IPropertyChangeListener prefListener;
    private PyAutoIndentStrategy indentStrategy;
    private PyEditConfiguration editConfiguration;
    private volatile SimpleNode ast;
    private volatile ErrorDescription errorDescription;
    List<IModelListener> modelListeners;
    private static List<IPyEditListener> editListeners;
    private volatile List<IPyEditListener> registeredEditListeners = new ArrayList<IPyEditListener>();
    private PyEditScripting pyEditScripting;
    private Object lock = new Object();
    public Map<String, Object> cache = new HashMap<String, Object>();
    protected boolean initFinished = false;
    private PyEditNotifier notifier;
    private boolean disposed = false;
    protected OfflineActionTarget fOfflineActionTarget;
    OfflineActionsManager offlineActionsManager = new OfflineActionsManager();
    private LocalResourceManager resourceManager;

    static {
        ParseException.verboseExceptions = true;
    }

    public PyEditConfiguration getEditConfiguration() {
        return this.editConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPyeditListener(IPyEditListener listener) {
        List<IPyEditListener> list = this.registeredEditListeners;
        synchronized (list) {
            this.registeredEditListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePyeditListener(IPyEditListener listener) {
        List<IPyEditListener> list = this.registeredEditListeners;
        synchronized (list) {
            this.registeredEditListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPyEditListener> getAllListeners() {
        while (!this.initFinished) {
            Object object = this.getLock();
            synchronized (object) {
                try {
                    if (!this.initFinished) {
                        this.getLock().wait();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<IPyEditListener> listeners = new ArrayList<IPyEditListener>();
        if (editListeners != null) {
            listeners.addAll(editListeners);
        }
        List<IPyEditListener> list = this.registeredEditListeners;
        synchronized (list) {
            listeners.addAll(this.registeredEditListeners);
        }
        return listeners;
    }

    private Object getLock() {
        return this.lock;
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public PyEdit() {
        try {
            if (editListeners == null) {
                editListeners = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_pyedit_listener");
            }
            this.modelListeners = new ArrayList<IModelListener>();
            this.colorCache = new ColorCache(PydevPrefs.getChainedPrefStore());
            this.editConfiguration = new PyEditConfiguration(this.colorCache, this, PydevPrefs.getChainedPrefStore());
            this.setSourceViewerConfiguration((SourceViewerConfiguration)this.editConfiguration);
            this.indentStrategy = this.editConfiguration.getPyAutoIndentStrategy();
            this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
            CodeFoldingSetter codeFoldingSetter = new CodeFoldingSetter(this);
            this.addModelListener(codeFoldingSetter);
            this.addPropertyListener(codeFoldingSetter);
        }
        catch (Throwable e) {
            PydevPlugin.log(e);
        }
    }

    @Override
    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        PySourceViewer viewer = (PySourceViewer)super.createSourceViewer(parent, ruler, styles);
        StyledText textWidget = viewer.getTextWidget();
        PyEditCursorListener cursorListener = new PyEditCursorListener();
        textWidget.addMouseListener((MouseListener)cursorListener);
        textWidget.addKeyListener((KeyListener)cursorListener);
        VerifyKeyListener verifyKeyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.doit && event.character == '\b' && event.stateMask == 0) {
                    PyBackspace pyBackspace = new PyBackspace();
                    pyBackspace.setEditor((IEditorPart)PyEdit.this);
                    pyBackspace.perform(new PySelection((ITextEditor)PyEdit.this));
                    event.doit = false;
                }
            }
        };
        viewer.appendVerifyKeyListener(verifyKeyListener);
        return viewer;
    }

    private void resetForceTabs() {
        IEditorStatusLine statusLine;
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (doc == null) {
            return;
        }
        if (!PydevPrefs.getPreferences().getBoolean("GUESS_TAB_SUBSTITUTION")) {
            this.getIndentPrefs().setForceTabs(false);
            return;
        }
        int lines = doc.getNumberOfLines();
        boolean forceTabs = false;
        int i = 0;
        while (i < lines) {
            block8: {
                try {
                    IRegion r = doc.getLineInformation(i);
                    String text = doc.get(r.getOffset(), r.getLength());
                    if (text == null) break block8;
                    if (text.startsWith("\t")) {
                        forceTabs = true;
                        break;
                    }
                    if (text.startsWith("  ")) {
                        forceTabs = false;
                    }
                    break block8;
                }
                catch (BadLocationException e) {
                    PydevPlugin.log(4, "Unexpected error forcing tabs", e);
                }
                break;
            }
            ++i;
        }
        this.getIndentPrefs().setForceTabs(forceTabs);
        this.editConfiguration.resetIndentPrefixes();
        if (forceTabs && (statusLine = (IEditorStatusLine)this.getAdapter(ClassLiteral.getClass((String)"org/eclipse/ui/texteditor/IEditorStatusLine"))) != null) {
            statusLine.setMessage(false, "Pydev: forcing tabs", null);
        }
    }

    public IIndentPrefs getIndentPrefs() {
        return this.indentStrategy.getIndentPrefs();
    }

    protected void installTabsToSpacesConverter() {
    }

    protected void uninstallTabsToSpacesConverter() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            this.notifier = new PyEditNotifier(this);
            super.init(site, input);
            IDocument document = this.getDocument(input);
            PyPartitionScanner.checkPartitionScanner((IDocument)document);
            final IPythonNature nature = PythonNature.addNature(input);
            Thread thread2 = new Thread(){

                public void run() {
                    try {
                        try {
                            AbstractShell.getServerShell(nature, 1);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                    catch (Exception exception) {}
                }
            };
            thread2.setName("Shell starter");
            thread2.start();
            this.prefListener = new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (property.equals("TAB_WIDTH")) {
                        ISourceViewer sourceViewer = PyEdit.this.getSourceViewer();
                        if (sourceViewer == null) {
                            return;
                        }
                        PyEdit.this.getIndentPrefs().regenerateIndentString();
                        sourceViewer.getTextWidget().setTabs(DefaultIndentPrefs.getStaticTabWidth());
                    } else if (property.equals("SUBSTITUTE_TABS")) {
                        PyEdit.this.getIndentPrefs().regenerateIndentString();
                    } else if (property.equals("GUESS_TAB_SUBSTITUTION")) {
                        PyEdit.this.resetForceTabs();
                    } else if (property.equals("CODE_COLOR") || property.equals("DECORATOR_COLOR") || property.equals("NUMBER_COLOR") || property.equals("KEYWORD_COLOR") || property.equals("SELF_COLOR") || property.equals("COMMENT_COLOR") || property.equals("STRING_COLOR") || property.equals("CLASS_NAME_COLOR") || property.equals("FUNC_NAME_COLOR") || property.equals(PydevEditorPrefs.DEFAULT_BACKQUOTES_COLOR) || property.endsWith("_STYLE")) {
                        PyEdit.this.colorCache.reloadNamedColor(property);
                        PyEdit.this.editConfiguration.updateSyntaxColorAndStyle();
                        PyEdit.this.getSourceViewer().invalidateTextPresentation();
                    }
                }
            };
            this.resetForceTabs();
            PydevPrefs.getPreferences().addPropertyChangeListener(this.prefListener);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    PyEdit.this.pyEditScripting = new PyEditScripting();
                    PyEdit.this.addPyeditListener(PyEdit.this.pyEditScripting);
                    PyEdit.this.initFinished = true;
                    Object object = PyEdit.this.getLock();
                    synchronized (object) {
                        PyEdit.this.getLock().notifyAll();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            thread.setName("PyEdit initializer");
            thread.start();
        }
        catch (Throwable e) {
            PydevPlugin.log(e);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IEditorInput oldInput = this.getEditorInput();
        super.doSetInput(input);
        try {
            IDocument document = this.getDocument(input);
            this.fixEncoding(input, document);
            PyParserManager.getPyParserManager((Preferences)PydevPrefs.getPreferences()).attachParserTo((IPyEdit)this);
            if (document != null) {
                PyPartitionScanner.checkPartitionScanner((IDocument)document);
            }
            this.notifier.notifyInputChanged(oldInput, input);
            this.notifier.notifyOnSetDocument(document);
        }
        catch (Throwable e) {
            PydevPlugin.log(e);
        }
    }

    public boolean hasSameInput(IPyEdit edit) {
        IEditorInput thisInput = this.getEditorInput();
        IEditorInput otherInput = edit.getEditorInput();
        if (thisInput == null || otherInput == null) {
            return false;
        }
        if (thisInput == otherInput || thisInput.equals(otherInput)) {
            return true;
        }
        IResource r1 = (IResource)thisInput.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"));
        IResource r2 = (IResource)otherInput.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"));
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.equals((Object)r2);
    }

    private IDocument getDocument(IEditorInput input) {
        return this.getDocumentProvider().getDocument((Object)input);
    }

    public IDocument getDocument() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getDocument((Object)this.getEditorInput());
        }
        return null;
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        this.fixEncoding(this.getEditorInput(), this.getDocument());
        super.performSave(overwrite, progressMonitor);
        PyParserManager.getPyParserManager(null).notifySaved((IPyEdit)this);
        this.notifier.notifyOnSave();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    private void fixEncoding(final IEditorInput input, IDocument document) {
        block6: {
            if (input instanceof FileEditorInput) {
                final IFile file = (IFile)((FileEditorInput)input).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
                try {
                    final String encoding = REF.getPythonFileEncoding((IDocument)document, (String)file.getFullPath().toOSString());
                    if (encoding == null) break block6;
                    try {
                        if (!encoding.equals(file.getCharset())) {
                            new Job("Change encoding"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        file.setCharset(encoding, monitor);
                                        ((TextFileDocumentProvider)PyEdit.this.getDocumentProvider()).setEncoding((Object)input, encoding);
                                        file.refreshLocal(2, null);
                                    }
                                    catch (CoreException e) {
                                        PydevPlugin.log(e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        }
                    }
                    catch (CoreException e) {
                        PydevPlugin.log(e);
                    }
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
        }
    }

    public IProject getProject() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            IFile file = (IFile)((FileEditorInput)editorInput).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
            return file.getProject();
        }
        return null;
    }

    public IFile getIFile() {
        IEditorInput editorInput = this.getEditorInput();
        return (IFile)editorInput.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
    }

    public File getEditorFile() {
        File f = null;
        IEditorInput editorInput = this.getEditorInput();
        IFile file = (IFile)editorInput.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
        if (file != null) {
            IPath path = file.getLocation().makeAbsolute();
            f = path.toFile();
        } else if (editorInput instanceof PydevFileEditorInput) {
            PydevFileEditorInput pyEditorInput = (PydevFileEditorInput)editorInput;
            f = pyEditorInput.getPath().toFile();
        } else {
            try {
                IPath path = (IPath)REF.invoke((Object)editorInput, (String)"getPath", (Object[])new Object[0]);
                f = path.toFile();
            }
            catch (Exception exception) {}
        }
        return f;
    }

    public void dispose() {
        this.disposed = true;
        try {
            this.notifier.notifyOnDispose();
            PydevPrefs.getPreferences().removePropertyChangeListener(this.prefListener);
            PyParserManager.getPyParserManager(null).notifyEditorDisposed((IPyEdit)this);
            this.colorCache.dispose();
            this.pyEditScripting = null;
            this.cache.clear();
            this.cache = null;
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
        }
        catch (Throwable e) {
            PydevPlugin.log(e);
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        try {
            MyResources resources = new MyResources();
            Object action = new ContentAssistAction((ResourceBundle)resources, "ContentAssistProposal.", (ITextEditor)this);
            action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
            this.setAction("ContentAssistProposal", (IAction)action);
            this.markAsStateDependentAction("ContentAssistProposal", true);
            PyOpenAction openAction = new PyOpenAction();
            this.setAction(ACTION_OPEN, (IAction)openAction);
            action = new OfflineAction(resources, "Pyedit.ScriptEngine.", this);
            action.setActionDefinitionId("org.python.pydev.editor.actions.scriptEngine");
            action.setId("org.python.pydev.editor.actions.scriptEngine");
            this.setAction("PydevScriptEngine", (IAction)action);
            this.notifier.notifyOnCreateActions(resources);
        }
        catch (Throwable e) {
            PydevPlugin.log(e);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.python.pydev.ui.editor.scope"});
    }

    public PyParser getParser() {
        return (PyParser)PyParserManager.getPyParserManager(null).getParser((IPyEdit)this);
    }

    public IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (!(contributor instanceof EditorActionBarContributor)) {
            return null;
        }
        IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (ClassLiteral.getClass((String)"org/python/pydev/editor/actions/OfflineActionTarget").equals(adapter)) {
            IStatusLineManager manager;
            if (this.fOfflineActionTarget == null && (manager = this.getStatusLineManager()) != null) {
                this.fOfflineActionTarget = this.getSourceViewer() == null ? null : new OfflineActionTarget((ITextViewer)this.getSourceViewer(), manager, this);
            }
            return this.fOfflineActionTarget;
        }
        if (ClassLiteral.getClass((String)"org/eclipse/ui/views/contentoutline/IContentOutlinePage").equals(adapter)) {
            return new PyOutlinePage(this);
        }
        return super.getAdapter(adapter);
    }

    public void setSelection(int offset, int length) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        sourceViewer.setSelectedRange(offset, length);
        sourceViewer.revealRange(offset, length);
    }

    public void revealModelNodes(SimpleNode[] nodes) {
        if (nodes == null) {
            return;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            int startOffset = -1;
            int endOffset = -1;
            PySelection selection = new PySelection((ITextEditor)this);
            SimpleNode[] simpleNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleNode node = simpleNodeArray[n2];
                int nodeStartoffset = selection.getLineOffset(node.beginLine - 1) + node.beginColumn - 1;
                int[] colLineEnd = NodeUtils.getColLineEnd((SimpleNode)node);
                int nodeEndOffset = selection.getLineOffset(colLineEnd[0] - 1) + colLineEnd[1] - 1;
                if (startOffset == -1 || nodeStartoffset < startOffset) {
                    startOffset = nodeStartoffset;
                }
                if (endOffset == -1 || nodeEndOffset > endOffset) {
                    endOffset = nodeEndOffset;
                }
                ++n2;
            }
            this.setSelection(startOffset, endOffset - startOffset);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }

    public void revealModelNode(SimpleNode node) {
        if (node == null) {
            return;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            PySelection selection = new PySelection((ITextEditor)this);
            int offset = selection.getLineOffset(node.beginLine - 1) + node.beginColumn - 1;
            int[] colLineEnd = NodeUtils.getColLineEnd((SimpleNode)node);
            int endOffset = selection.getLineOffset(colLineEnd[0] - 1) + colLineEnd[1] - 1;
            int length = endOffset - offset;
            this.setSelection(offset, length);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }

    public void parserChanged(ISimpleNode root, IAdaptable file, IDocument doc) {
        this.errorDescription = null;
        int lastLine = doc.getNumberOfLines();
        try {
            doc.getLineInformation(lastLine - 1);
            this.ast = (SimpleNode)root;
            this.fireModelChanged(this.ast);
        }
        catch (BadLocationException e1) {
            PydevPlugin.log(2, "Unexpected error getting document length. No model!", e1);
        }
    }

    /*
     * Exception decompiling
     */
    public void parserError(Throwable error, IAdaptable original, IDocument doc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addModelListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public void removeModelListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        this.modelListeners.remove(listener);
    }

    protected void fireModelChanged(SimpleNode root) {
        for (IModelListener listener : new ArrayList<IModelListener>(this.modelListeners)) {
            listener.modelChanged(root);
        }
    }

    public SimpleNode getAST() {
        return this.ast;
    }

    public List<String[]> getInnerStructureFromLine(int line) {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        List parseToKnowGloballyAccessiblePath = FastParser.parseToKnowGloballyAccessiblePath((IDocument)this.getDocument(), (int)line);
        for (stmtType stmtType2 : parseToKnowGloballyAccessiblePath) {
            String rep = NodeUtils.getRepresentationString((SimpleNode)stmtType2);
            String image = stmtType2 instanceof ClassDef ? "icons/class_obj.gif" : (stmtType2 instanceof FunctionDef ? "icons/methpub_obj.gif" : "icons/showerr_tsk.gif");
            ret.add(new String[]{rep, image});
        }
        return ret;
    }

    public static void openWithPathAndInnerStructure(String projectName, IPath path, List<String> innerStructure) {
        IEditorPart editor;
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project != null && (file = project.getFile(path)) != null && (editor = PyOpenEditor.doOpenEditor(file)) instanceof PyEdit) {
            PyEdit pyEdit = (PyEdit)editor;
            IPythonNature nature = pyEdit.getPythonNature();
            AbstractModule mod = AbstractModule.createModuleFromDoc(nature.resolveModule((IResource)file), file.getLocation().toFile(), pyEdit.getDocument(), nature, 0);
            StringBuffer tok = new StringBuffer(80);
            for (String s : innerStructure) {
                if (tok.length() > 0) {
                    tok.append('.');
                }
                tok.append(s);
            }
            try {
                IDefinition[] definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState(tok.toString(), nature, new CompletionCache()), -1, -1, nature);
                ArrayList<ItemPointer> pointers = new ArrayList<ItemPointer>();
                PyRefactoringFindDefinition.getAsPointers(pointers, definitions);
                if (pointers.size() > 0) {
                    new PyOpenAction().run((ItemPointer)pointers.get(0));
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
    }

    public ErrorDescription getErrorDescription() {
        return this.errorDescription;
    }

    private void fireParseErrorChanged(ErrorDescription errorDesc) {
        for (IModelListener listener : new ArrayList<IModelListener>(this.modelListeners)) {
            listener.errorChanged(errorDesc);
        }
    }

    public IGrammarVersionProvider getGrammarVersionProvider() {
        IPythonNature nature = this.getPythonNature();
        if (nature != null) {
            return nature;
        }
        Tuple<SystemPythonNature, String> infoForFile = PydevPlugin.getInfoForFile(this.getEditorFile());
        return (IGrammarVersionProvider)infoForFile.o1;
    }

    public IPythonNature getPythonNature() {
        IProject project = this.getProject();
        if (project == null || !project.isOpen()) {
            return null;
        }
        PythonNature pythonNature = PythonNature.getPythonNature(project);
        if (pythonNature != null) {
            return pythonNature;
        }
        pythonNature = PythonNature.addNature(this.getEditorInput());
        if (pythonNature != null) {
            return pythonNature;
        }
        Tuple<SystemPythonNature, String> infoForFile = PydevPlugin.getInfoForFile(this.getEditorFile());
        if (infoForFile == null) {
            NotConfiguredInterpreterException e = new NotConfiguredInterpreterException();
            ErrorDialog.openError((Shell)PyAction.getShell(), (String)"Error: no interpreter configured", (String)"Interpreter not configured\n(Please, Configure it under window->preferences->PyDev)", (IStatus)PydevPlugin.makeStatus(4, e.getMessage(), e));
            throw e;
        }
        pythonNature = (IPythonNature)infoForFile.o1;
        return pythonNature;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        try {
            IPreferenceStore prefStore = PydevPrefs.getChainedPrefStore();
            this.setPreferenceStore(prefStore);
            this.setEditorContextMenuId(PY_EDIT_CONTEXT);
        }
        catch (Throwable e) {
            PydevPlugin.log(e);
        }
    }

    public Collection<ActionInfo> getOfflineActionDescriptions() {
        return this.offlineActionsManager.getOfflineActionDescriptions();
    }

    public void addOfflineActionListener(String key, IAction action) {
        this.offlineActionsManager.addOfflineActionListener(key, action);
    }

    public void addOfflineActionListener(String key, IAction action, String description, boolean needsEnter) {
        this.offlineActionsManager.addOfflineActionListener(key, action, description, needsEnter);
    }

    public boolean activatesAutomaticallyOn(String key) {
        return this.offlineActionsManager.activatesAutomaticallyOn(key);
    }

    public boolean onOfflineAction(String requestedStr, OfflineActionTarget target) {
        return this.offlineActionsManager.onOfflineAction(requestedStr, target);
    }

    public LocalResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public Font getFont(FontData descriptor) {
        Font font = this.getResourceManager().createFont(FontDescriptor.createFrom((FontData)descriptor));
        return font;
    }

    public static class MyResources
    extends ListResourceBundle {
        static final Object[][] contents = new Object[][]{{"CorrectionAssist", "CorrectionAssist"}, {"ContentAssistProposal", "ContentAssistProposal"}, {"TemplateProposals", "TemplateProposals"}};

        public Object[][] getContents() {
            return contents;
        }
    }

    private class PyEditCursorListener
    implements MouseListener,
    KeyListener {
        private int lastOffset = -1;

        private PyEditCursorListener() {
        }

        private void notifyCursorPositionChanged() {
            if (!PyEdit.this.initFinished) {
                return;
            }
            PySelection ps = new PySelection((ITextEditor)PyEdit.this);
            Iterator<IPyEditListener> iterator = PyEdit.this.getAllListeners().iterator();
            while (iterator.hasNext()) {
                IPyEditListener listener = iterator.next();
                try {
                    if (!(listener instanceof IPyEditListener2)) continue;
                    ((IPyEditListener2)((Object)listener)).handleCursorPositionChanged(PyEdit.this, ps);
                }
                catch (Throwable e) {
                    PydevPlugin.log(e);
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            this.lastOffset = this.getOffset();
            this.notifyCursorPositionChanged();
        }

        public void keyPressed(KeyEvent e) {
        }

        private int getOffset() {
            return ((ITextSelection)PyEdit.this.getSelectionProvider().getSelection()).getOffset();
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\u0000') {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        int offset = this.getOffset();
                        if (offset == this.lastOffset) break;
                        this.notifyCursorPositionChanged();
                        this.lastOffset = offset;
                    }
                }
                return;
            }
        }
    }
}

