/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pycremover;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

public class PycRemoverBuilderVisitor
extends PyDevBuilderVisitor {
    PySourceLocatorBase locator;

    public void visitingWillStart(IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
        this.locator = new PySourceLocatorBase();
        super.visitingWillStart(monitor, isFullBuild, nature);
    }

    public void visitingEnded(IProgressMonitor monitor) {
        super.visitingEnded(monitor);
        this.locator = null;
    }

    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        String loc = resource.getLocation().toOSString();
        if (loc != null && loc.length() > 3) {
            String dotPy = loc.substring(0, loc.length() - 1);
            File file = new File(dotPy);
            if (file.exists()) {
                return;
            }
            file = new File(String.valueOf(dotPy) + "w");
            if (file.exists()) {
                return;
            }
            PythonNature nature = PythonNature.getPythonNature(resource);
            if (nature == null) {
                return;
            }
            if (!nature.isResourceInPythonpath(dotPy)) {
                return;
            }
            this.treatPycFile(loc);
        }
    }

    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        String loc = String.valueOf(resource.getLocation().toOSString()) + "c";
        this.treatPycFile(loc);
    }

    private void treatPycFile(String loc) {
        if (loc.endsWith(".pyc")) {
            try {
                File file = new File(loc);
                IFile[] files = this.locator.getWorkspaceFiles(file);
                if (files == null) {
                    return;
                }
                IFile[] iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    final IFile workspaceFile = iFileArray[n2];
                    if (workspaceFile != null && workspaceFile.exists()) {
                        new Job("Deleting File"){

                            protected IStatus run(IProgressMonitor monitor) {
                                monitor.beginTask("Delete .pyc file: " + workspaceFile.getName(), 1);
                                try {
                                    workspaceFile.delete(true, monitor);
                                }
                                catch (CoreException e) {
                                    PydevPlugin.log(e);
                                }
                                monitor.done();
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
    }
}

