/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Break;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Continue;
import org.python.pydev.parser.jython.ast.Delete;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.DictComp;
import org.python.pydev.parser.jython.ast.Exec;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.IfExp;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Set;
import org.python.pydev.parser.jython.ast.SetComp;
import org.python.pydev.parser.jython.ast.Slice;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.StrJoin;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.prettyprinter.AuxSpecials;
import org.python.pydev.parser.prettyprinter.IWriterEraser;
import org.python.pydev.parser.prettyprinter.PrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinter.PrettyPrinterUtils;
import org.python.pydev.parser.prettyprinter.WriteState;
import org.python.pydev.parser.visitors.NodeUtils;

public class PrettyPrinter
extends PrettyPrinterUtils {
    private boolean isSingleStmt;
    private int addingToArgsAsSpecialsAfter;

    protected boolean fixNewStatementCondition() throws IOException {
        boolean ret = false;
        if (!this.isSingleStmt) {
            ret = super.fixNewStatementCondition();
        }
        return ret;
    }

    public PrettyPrinter(PrettyPrinterPrefs prefs, IWriterEraser writer) {
        this(prefs, writer, false);
    }

    public PrettyPrinter(PrettyPrinterPrefs prefs, IWriterEraser writer, boolean isSingleStmt) {
        this.prefs = prefs;
        this.isSingleStmt = isSingleStmt;
        this.state = new WriteState(writer, prefs);
        this.auxComment = new AuxSpecials(this.state, prefs);
    }

    public Object visitModule(Module node) throws Exception {
        super.visitModule(node);
        if (node.specialsAfter != null) {
            Iterator iterator = node.specialsAfter.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                commentType t = (commentType)o;
                String c = t.id.trim();
                this.state.write(c);
            }
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        this.auxComment.writeSpecialsBefore(node.module, new String[0], new String[0], true);
        this.auxComment.writeSpecialsBefore(node.module, null, null, false);
        this.state.write(((NameTok)node.module).id);
        this.auxComment.writeSpecialsAfter(node.module);
        aliasType[] aliasTypeArray = node.names;
        int n = node.names.length;
        int n2 = 0;
        while (n2 < n) {
            aliasType name = aliasTypeArray[n2];
            this.auxComment.writeSpecialsBefore(name);
            name.accept(this);
            this.auxComment.writeSpecialsAfter(name);
            ++n2;
        }
        this.afterNode(node);
        this.fixNewStatementCondition();
        return null;
    }

    public Object visitImport(Import node) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        aliasType[] aliasTypeArray = node.names;
        int n = node.names.length;
        int n2 = 0;
        while (n2 < n) {
            aliasType name = aliasTypeArray[n2];
            this.auxComment.writeSpecialsBefore(name);
            name.accept(this);
            this.auxComment.writeSpecialsAfter(name);
            ++n2;
        }
        this.afterNode(node);
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.state.pushInStmt(node);
        this.auxComment.writeSpecialsBefore(node);
        int i = 0;
        while (i < node.targets.length) {
            exprType target = node.targets[i];
            if (i == node.targets.length - 1) {
                this.auxComment.moveComments(target, node.value, false, true);
            }
            if (i >= 1) {
                this.state.write(" = ");
            }
            target.accept(this);
            ++i;
        }
        this.state.write(" = ");
        node.value.accept(this);
        this.checkEndRecord();
        if (this.auxComment.hasCommentsAfter(node)) {
            this.auxComment.writeSpecialsAfter(node, false);
            this.checkEndRecord();
        }
        this.state.popInStmt();
        this.fixNewStatementCondition();
        return null;
    }

    public void visitBeforeLeft(SimpleNode node) throws IOException {
        this.auxComment.writeSpecialsBefore(node);
        this.state.pushInStmt(node);
    }

    public void visitAfterRight(SimpleNode node) throws IOException {
        this.state.popInStmt();
        this.auxComment.writeSpecialsAfter(node, false);
        if (!this.state.inStmt()) {
            this.checkEndRecord();
        }
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        this.visitBeforeLeft(node);
        node.target.accept(this);
        this.state.write(augOperatorMapping[node.op]);
        node.value.accept(this);
        this.visitAfterRight(node);
        return null;
    }

    public Object visitBinOp(BinOp node) throws Exception {
        this.visitBeforeLeft(node);
        node.left.accept(this);
        this.state.write(operatorMapping[node.op]);
        node.right.accept(this);
        this.visitAfterRight(node);
        return null;
    }

    public Object visitUnaryOp(UnaryOp node) throws Exception {
        this.visitBeforeLeft(node);
        if (this.addingToArgsAsSpecialsAfter == 1 && node.operand.getSpecialsBefore().size() > 0 && node.operand.getSpecialsBefore().get(0).toString().equals("=")) {
            node.operand.getSpecialsBefore().add(unaryopOperatorMapping[node.op]);
        } else {
            this.state.write(unaryopOperatorMapping[node.op]);
        }
        node.operand.accept(this);
        this.visitAfterRight(node);
        return null;
    }

    public Object visitBoolOp(BoolOp node) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        this.state.pushInStmt(node);
        int i = 0;
        while (i < node.values.length - 1) {
            node.values[i].accept(this);
            this.state.write(boolOperatorMapping[node.op]);
            ++i;
        }
        node.values[node.values.length - 1].accept(this);
        this.visitAfterRight(node);
        return null;
    }

    public Object visitSubscript(Subscript node) throws Exception {
        node.value.accept(this);
        this.visitBeforeLeft(node);
        node.slice.accept(this);
        this.visitAfterRight(node);
        return null;
    }

    public Object visitCompare(Compare node) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        node.left.accept(this);
        int i = 0;
        while (i < node.comparators.length) {
            this.state.write(cmpop[node.ops[i]]);
            node.comparators[i].accept(this);
            ++i;
        }
        this.auxComment.writeSpecialsAfter(node);
        return null;
    }

    public Object visitSet(Set node) throws Exception {
        this.state.indent();
        this.auxComment.writeSpecialsBefore(node);
        int i = 0;
        while (i < node.elts.length) {
            this.prefs.enableSpacesAfterColon();
            node.elts[i].accept(this);
            this.prefs.disableSpacesAfterColon();
            ++i;
        }
        this.auxComment.writeSpecialsAfter(node);
        this.dedent();
        return null;
    }

    public Object visitDict(Dict node) throws Exception {
        this.state.indent();
        this.auxComment.writeSpecialsBefore(node);
        exprType[] keys = node.keys;
        exprType[] values = node.values;
        int i = 0;
        while (i < values.length) {
            this.prefs.enableSpacesAfterColon();
            keys[i].accept(this);
            values[i].accept(this);
            this.prefs.disableSpacesAfterColon();
            ++i;
        }
        this.auxComment.writeSpecialsAfter(node);
        this.dedent();
        return null;
    }

    public Object visitLambda(Lambda node) throws Exception {
        this.genericBefore(node, false);
        this.state.pushInStmt(node);
        this.prefs.enableSpacesAfterColon();
        this.printArgs(node.args);
        this.prefs.disableSpacesAfterColon();
        node.body.accept(this);
        this.state.popInStmt();
        this.genericAfter(node, false, false);
        return null;
    }

    public Object visitList(org.python.pydev.parser.jython.ast.List node) throws Exception {
        return this.visitGeneric(node, "visitList", false, null, true);
    }

    public Object visitDelete(Delete node) throws Exception {
        return this.visitGeneric(node, "visitDelete", false);
    }

    public Object visitListComp(ListComp node) throws Exception {
        this.beforeNode(node);
        node.elt.accept(this);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.afterNode(node);
        return null;
    }

    public Object visitSetComp(SetComp node) throws Exception {
        this.beforeNode(node);
        node.elt.accept(this);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.afterNode(node);
        return null;
    }

    public Object visitDictComp(DictComp node) throws Exception {
        this.beforeNode(node);
        node.key.accept(this);
        node.value.accept(this);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.afterNode(node);
        return null;
    }

    private SimpleNode[] reverseNodeArray(SimpleNode[] expressions) {
        List<SimpleNode> ifs = Arrays.asList(expressions);
        Collections.reverse(ifs);
        SimpleNode[] ifsInOrder = ifs.toArray(new SimpleNode[0]);
        return ifsInOrder;
    }

    public Object visitComprehension(Comprehension node) throws Exception {
        this.beforeNode(node);
        node.target.accept(this);
        node.iter.accept(this);
        SimpleNode[] simpleNodeArray = this.reverseNodeArray(node.ifs);
        int n = simpleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode s = simpleNodeArray[n2];
            s.accept(this);
            ++n2;
        }
        this.afterNode(node);
        return null;
    }

    public Object visitExpr(Expr node) throws Exception {
        return this.visitGeneric(node, "visitExpr", false, null, false, false);
    }

    public Object visitWhile(While node) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        this.state.indent();
        this.state.pushInStmt(node.test);
        node.test.accept(this);
        this.state.popInStmt();
        this.afterNode(node);
        this.fixNewStatementCondition();
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        this.dedent();
        if (node.orelse != null) {
            this.state.indent();
            this.auxComment.writeSpecialsBefore(node.orelse);
            this.afterNode(node.orelse);
            node.orelse.accept(this);
            this.dedent();
        }
        return null;
    }

    public Object visitFor(For node) throws Exception {
        this.state.pushInStmt(node);
        this.auxComment.writeSpecialsBefore(node);
        this.state.indent();
        node.target.accept(this);
        this.state.pushInStmt(node.iter);
        node.iter.accept(this);
        this.state.popInStmt();
        this.afterNode(node);
        this.state.popInStmt();
        this.fixNewStatementCondition();
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        this.dedent();
        if (node.orelse != null) {
            this.state.indent();
            this.auxComment.writeSpecialsBefore(node.orelse);
            this.auxComment.writeSpecialsAfter(node.orelse);
            this.afterNode(node.orelse);
            node.orelse.accept(this);
            this.dedent();
        }
        return null;
    }

    public Object visitTuple(Tuple node) throws Exception {
        this.visitGeneric(node, "visitTuple", false, null, true);
        return null;
    }

    public Object visitRaise(Raise node) throws Exception {
        this.visitGeneric(node, "visitRaise", true);
        return null;
    }

    public void visitTryPart(SimpleNode node, stmtType[] body) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        boolean indent = false;
        if (node.specialsBefore != null && node.specialsBefore.size() > 0) {
            Iterator<Object> iterator = node.specialsBefore.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!o.toString().equals("try")) continue;
                indent = true;
                break;
            }
        }
        if (indent) {
            this.state.indent();
            this.fixNewStatementCondition();
        }
        stmtType[] stmtTypeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType st = stmtTypeArray[n2];
            st.accept(this);
            ++n2;
        }
        this.fixNewStatementCondition();
        if (indent) {
            this.dedent();
        }
        this.auxComment.writeSpecialsAfter(node);
    }

    public void visitOrElsePart(suiteType orelse) throws Exception {
        if (orelse != null) {
            this.auxComment.writeSpecialsBefore(orelse);
            this.state.indent();
            this.afterNode(orelse);
            stmtType[] stmtTypeArray = orelse.body;
            int n = orelse.body.length;
            int n2 = 0;
            while (n2 < n) {
                stmtType st = stmtTypeArray[n2];
                st.accept(this);
                ++n2;
            }
            this.auxComment.writeSpecialsAfter(orelse);
            this.dedent();
        }
    }

    public Object visitExec(Exec node) throws Exception {
        return this.visitGeneric(node, "visitExec");
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        this.visitTryPart(node, node.body);
        this.visitOrElsePart(node.finalbody);
        return null;
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        this.visitTryPart(node, node.body);
        excepthandlerType[] excepthandlerTypeArray = node.handlers;
        int n = node.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            excepthandlerType h = excepthandlerTypeArray[n2];
            this.state.pushInStmt(h);
            this.state.indent();
            this.auxComment.writeSpecialsBefore(h);
            if (h.type != null || h.name != null) {
                this.state.write(" ");
            }
            if (h.type != null) {
                h.type.accept(this);
            }
            if (h.name != null) {
                h.name.accept(this);
            }
            this.state.popInStmt();
            this.auxComment.writeSpecialsAfter(h);
            this.fixNewStatementCondition();
            stmtType[] stmtTypeArray = h.body;
            int n3 = h.body.length;
            int n4 = 0;
            while (n4 < n3) {
                stmtType st = stmtTypeArray[n4];
                st.accept(this);
                ++n4;
            }
            this.dedent();
            ++n2;
        }
        this.visitOrElsePart(node.orelse);
        return null;
    }

    public Object visitSlice(Slice node) throws Exception {
        return this.visitGeneric(node, "visitSlice", false);
    }

    public Object visitIndex(Index node) throws Exception {
        return this.visitGeneric(node, "visitIndex", false);
    }

    public Object visitReturn(Return node) throws Exception {
        return this.visitGeneric(node, "visitReturn", true);
    }

    public Object visitPrint(Print node) throws Exception {
        return this.visitGeneric(node, "visitPrint", true, null, false, false);
    }

    public Object visitAttribute(Attribute node) throws Exception {
        this.state.pushInStmt(node);
        this.auxComment.writeSpecialsBefore(node);
        node.value.accept(this);
        this.state.write(".");
        node.attr.accept(this);
        this.auxComment.writeSpecialsAfter(node);
        this.state.popInStmt();
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        this.auxComment.writeSpecialsBefore(node, new String[]{"("}, null, false);
        this.state.pushInStmt(node);
        node.func.accept(this);
        this.state.popInStmt();
        this.auxComment.writeSpecialsBefore(node, null, new String[]{"("}, true);
        this.printCallArguments(node, node.args, node.keywords, node.starargs, node.kwargs);
        this.auxComment.writeSpecialsAfter(node);
        if (!this.state.inStmt()) {
            this.fixNewStatementCondition();
        }
        return null;
    }

    public Object visitIf(If node) throws Exception {
        this.fixNewStatementCondition();
        this.auxComment.moveComments(node.test, node, true, false, false);
        this.auxComment.writeSpecialsBefore(node);
        this.auxComment.moveComments(node.test, node.body[0], false, true, true);
        this.state.pushInStmt(node.test);
        node.test.accept(this);
        this.state.popInStmt();
        this.state.indent();
        if (!this.fixNewStatementCondition()) {
            this.state.writeIndentString();
        }
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        this.dedent();
        if (node.orelse != null && node.orelse.length > 0) {
            boolean inElse = false;
            this.auxComment.writeSpecialsAfter(node);
            if (node.specialsAfter != null && node.specialsAfter.contains(new SpecialStr("else:", 0, 0))) {
                inElse = true;
                this.state.indent();
                if (!this.fixNewStatementCondition()) {
                    this.state.writeIndentString();
                }
            }
            stmtType[] stmtTypeArray2 = node.orelse;
            int n4 = node.orelse.length;
            n = 0;
            while (n < n4) {
                stmtType n5 = stmtTypeArray2[n];
                n5.accept(this);
                ++n;
            }
            if (inElse) {
                this.dedent();
            }
        }
        return null;
    }

    public Object visitStrJoin(StrJoin node) throws Exception {
        return super.visitGeneric(node, "visitStrJoin", false);
    }

    public Object visitAssert(Assert node) throws Exception {
        this.auxComment.moveComments(node.test, node, true, false);
        return super.visitGeneric(node, "visitAssert", true, null, false, false);
    }

    public Object visitStr(Str node) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        this.state.write(NodeUtils.getStringToPrint(node));
        if (!this.state.inStmt()) {
            this.fixNewStatementCondition();
        }
        this.auxComment.writeSpecialsAfter(node);
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        int n;
        int n2;
        SimpleNode[] simpleNodeArray;
        this.printDecorators(node.decs);
        this.fixNewStatementCondition();
        this.auxComment.writeSpecialsBefore(node.name);
        this.auxComment.writeSpecialsBefore(node);
        this.state.write("class ");
        NameTok name = (NameTok)node.name;
        this.state.write(name.id);
        this.state.indent();
        this.auxComment.writeSpecialsAfter(name);
        if (node.bases.length > 0) {
            simpleNodeArray = node.bases;
            n2 = node.bases.length;
            n = 0;
            while (n < n2) {
                exprType expr = simpleNodeArray[n];
                this.state.pushInStmt(expr);
                expr.accept(this);
                this.state.popInStmt();
                ++n;
            }
        }
        this.printArguments(node, node.keywords, node.starargs, node.kwargs);
        this.checkEndRecord();
        simpleNodeArray = node.body;
        n2 = node.body.length;
        n = 0;
        while (n < n2) {
            SimpleNode n3 = simpleNodeArray[n];
            n3.accept(this);
            ++n;
        }
        this.dedent();
        this.auxComment.writeSpecialsAfter(node, false);
        this.fixNewStatementCondition();
        this.state.writeLinesAfterClass();
        return null;
    }

    public void visitNode(SimpleNode node) throws Exception {
        if (node != null) {
            this.beforeNode(node);
            node.accept(this);
            this.afterNode(node);
        }
    }

    public Object visitDecoratorsType(decoratorsType node) throws Exception {
        int i;
        this.beforeNode(node);
        this.visitNode(node.func);
        if (node.args != null) {
            i = node.args.length - 1;
            while (i >= 0) {
                if (node.args[i] != null) {
                    node.args[i].accept(this);
                }
                --i;
            }
        }
        if (node.keywords != null) {
            i = node.keywords.length - 1;
            while (i >= 0) {
                if (node.keywords[i] != null) {
                    this.visitNode(node.keywords[i]);
                }
                --i;
            }
        }
        if (node.starargs != null) {
            node.starargs.accept(this);
        }
        if (node.kwargs != null) {
            node.kwargs.accept(this);
        }
        this.afterNode(node);
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.printDecorators(node.decs);
        this.fixNewStatementCondition();
        this.auxComment.writeSpecialsBefore(node);
        this.state.write("def ");
        this.state.indent();
        int lastWrite = this.state.getLastWrite();
        node.name.accept(this);
        this.auxComment.writeStringsAfter(node);
        this.printArgs(node.args);
        this.state.pushInStmt(node.returns);
        if (node.returns != null) {
            node.returns.accept(this);
        }
        this.state.popInStmt();
        if (!this.fixNewStatementCondition() && lastWrite == this.state.getLastWrite()) {
            this.state.writeIndentString();
        }
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            if (n3 != null) {
                n3.accept(this);
            }
            ++n2;
        }
        this.dedent();
        this.auxComment.writeCommentsAfter(node);
        this.state.writeLinesAfterMethod();
        return null;
    }

    private void printDecorators(decoratorsType[] decs) throws IOException, Exception {
        if (decs != null) {
            decoratorsType[] decoratorsTypeArray = decs;
            int n = decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType dec = decoratorsTypeArray[n2];
                this.auxComment.writeSpecialsBefore(dec);
                this.fixNewStatementCondition();
                this.state.write("@");
                this.state.pushInStmt(dec);
                this.visitDecoratorsType(dec);
                this.state.popInStmt();
                this.auxComment.writeSpecialsAfter(dec);
                ++n2;
            }
        }
    }

    protected void printArgs(argumentsType completeArgs) throws Exception {
        exprType[] args = completeArgs.args;
        exprType[] d = completeArgs.defaults;
        exprType[] anns = completeArgs.annotation;
        int argsLen = args.length;
        int defaultsLen = d.length;
        int diff = argsLen - defaultsLen;
        int i = 0;
        while (i < args.length) {
            exprType ann;
            exprType defaulArgValue;
            exprType argName = args[i];
            this.state.pushInStmt(argName);
            if (i >= diff && (defaulArgValue = d[i - diff]) != null) {
                this.addToArgAsSpecialsAfter(argName, defaulArgValue);
            }
            if (anns != null && (ann = anns[i]) != null) {
                this.addToArgAsSpecialsAfter(argName, ann);
            }
            argName.accept(this);
            this.state.popInStmt();
            ++i;
        }
        if (completeArgs.vararg != null) {
            this.state.pushInStmt(completeArgs.vararg);
            this.addToArgAsSpecialsAfter(completeArgs.vararg, completeArgs.varargannotation);
            completeArgs.vararg.accept(this);
            this.state.popInStmt();
        } else if (completeArgs.kwonlyargs != null && completeArgs.kwonlyargs.length > 0 && completeArgs.kwonlyargs[0] != null) {
            ArrayList<String> specialsBefore = completeArgs.kwonlyargs[0].specialsBefore;
            if (specialsBefore == null) {
                completeArgs.kwonlyargs[0].specialsBefore = specialsBefore = new ArrayList<String>();
            }
            specialsBefore.add("*");
            specialsBefore.add(",");
        }
        if (completeArgs.kwonlyargs != null) {
            i = 0;
            while (i < completeArgs.kwonlyargs.length) {
                exprType kwonlyarg = completeArgs.kwonlyargs[i];
                if (kwonlyarg != null) {
                    this.state.pushInStmt(kwonlyarg);
                    if (completeArgs.kw_defaults != null && completeArgs.kw_defaults[i] != null) {
                        this.addToArgAsSpecialsAfter(kwonlyarg, completeArgs.kw_defaults[i]);
                    }
                    if (completeArgs.kwonlyargannotation != null && completeArgs.kwonlyargannotation[i] != null) {
                        this.addToArgAsSpecialsAfter(kwonlyarg, completeArgs.kwonlyargannotation[i]);
                    }
                    kwonlyarg.accept(this);
                    this.state.popInStmt();
                }
                ++i;
            }
        }
        if (completeArgs.kwarg != null) {
            this.state.pushInStmt(completeArgs.kwarg);
            this.addToArgAsSpecialsAfter(completeArgs.kwarg, completeArgs.kwargannotation);
            completeArgs.kwarg.accept(this);
            this.state.popInStmt();
        }
    }

    private void addToArgAsSpecialsAfter(SimpleNode nodeToAdd, SimpleNode valToPrint) throws Exception {
        if (valToPrint == null) {
            return;
        }
        ++this.addingToArgsAsSpecialsAfter;
        this.state.pushTempBuffer();
        valToPrint.accept(this);
        List<Object> specialsAfter = nodeToAdd.getSpecialsAfter();
        int position = specialsAfter.size() > 0 && specialsAfter.get(0).toString().equals("=") ? 1 : 0;
        --this.addingToArgsAsSpecialsAfter;
        nodeToAdd.getSpecialsAfter().add(position, this.state.popTempBuffer());
    }

    public Object visitWith(With node) throws Exception {
        this.state.pushInStmt(node);
        this.auxComment.writeSpecialsBefore(node);
        this.state.indent();
        node.context_expr.accept(this);
        if (node.optional_vars != null) {
            node.optional_vars.accept(this);
        }
        this.state.popInStmt();
        this.afterNode(node);
        this.fixNewStatementCondition();
        stmtType[] stmtTypeArray = node.body.body;
        int n = node.body.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        this.dedent();
        return null;
    }

    public Object visitYield(Yield node) throws Exception {
        return this.visitGeneric(node, "visitYield");
    }

    public Object visitGlobal(Global node) throws Exception {
        return this.visitGeneric(node, "visitGlobal");
    }

    public Object visitPass(Pass node) throws Exception {
        return this.visitGeneric(node, "visitPass");
    }

    public Object visitNum(Num node) throws Exception {
        return this.visitGeneric(node, "visitNum", false, node.num.toString());
    }

    public Object visitName(Name node) throws Exception {
        return this.visitGeneric(node, "visitName", false, node.id, false, false);
    }

    public Object visitBreak(Break node) throws Exception {
        return this.visitGeneric(node, "visitBreak");
    }

    public Object visitContinue(Continue node) throws Exception {
        return this.visitGeneric(node, "visitContinue");
    }

    public Object visitIfExp(IfExp node) throws Exception {
        this.beforeNode(node);
        node.body.accept(this);
        node.test.accept(this);
        if (node.orelse != null) {
            node.orelse.accept(this);
        }
        this.afterNode(node);
        return null;
    }

    public Object visitNameTok(NameTok node) throws Exception {
        this.auxComment.writeSpecialsBefore(node);
        this.state.write(node.id);
        this.auxComment.writeSpecialsAfter(node, false);
        return null;
    }

    public String toString() {
        return this.state.toString();
    }
}

