/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinter;

import java.io.IOException;
import java.util.Iterator;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.prettyprinter.PrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinter.WriteState;

public class AuxSpecials {
    private WriteState state;
    private PrettyPrinterPrefs prefs;

    public AuxSpecials(WriteState state, PrettyPrinterPrefs prefs) {
        this.state = state;
        this.prefs = prefs;
    }

    public void writeSpecialsBefore(SimpleNode node) throws IOException {
        this.writeSpecialsBefore(node, null, null, true);
    }

    public void writeSpecialsBefore(SimpleNode node, String[] ignore, String[] write, boolean writeComments) throws IOException {
        if (node.specialsBefore == null) {
            return;
        }
        Iterator<Object> iterator = node.specialsBefore.iterator();
        while (iterator.hasNext()) {
            Object c = iterator.next();
            if (c instanceof commentType) {
                if (!writeComments) continue;
                this.state.write(((commentType)c).id);
                this.state.writeNewLine();
                this.state.writeIndent();
                continue;
            }
            if (c instanceof String) {
                String str = (String)c;
                if (!this.canWrite(str, ignore, write)) continue;
                this.state.write(this.prefs.getReplacement(str));
                continue;
            }
            if (c instanceof SpecialStr) {
                SpecialStr s = (SpecialStr)c;
                String str = s.str;
                if (!this.canWrite(str, ignore, write)) continue;
                this.state.write(this.prefs.getReplacement(str));
                continue;
            }
            throw new RuntimeException("Unexpected special: " + node);
        }
    }

    private boolean canWrite(String str, String[] ignore, String[] write) {
        String s;
        int n;
        int n2;
        String[] stringArray;
        if (ignore == null && write == null) {
            return true;
        }
        if (ignore != null) {
            stringArray = ignore;
            n2 = ignore.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                if (s.equals(str)) {
                    return false;
                }
                ++n;
            }
        }
        if (write != null) {
            stringArray = write;
            n2 = write.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                if (s.equals(str)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    public void writeSpecialsAfter(SimpleNode node) throws IOException {
        this.writeSpecialsAfter(node, true);
    }

    public void writeSpecialsAfter(SimpleNode node, boolean isNewScope) throws IOException {
        int line = node.beginLine;
        if (node.specialsAfter == null) {
            return;
        }
        Iterator<Object> iterator = node.specialsAfter.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof commentType) {
                commentType c = (commentType)o;
                if (c.beginLine > line) {
                    if (this.state.writeNewLine(false)) {
                        if (isNewScope) {
                            this.state.writeIndent(1);
                        } else {
                            this.state.writeIndent();
                        }
                    }
                } else {
                    this.state.writeSpacesBeforeComment();
                }
                this.state.write(c.id);
                this.state.writeNewLine();
                line = c.beginLine + 1;
                this.state.writeIndent();
                continue;
            }
            if (o instanceof SpecialStr) {
                SpecialStr s = (SpecialStr)o;
                this.state.write(this.prefs.getReplacement(s.str));
                line = s.beginLine;
                continue;
            }
            if (o instanceof String) {
                this.state.write(this.prefs.getReplacement((String)o));
                continue;
            }
            throw new RuntimeException("Unexpected special: " + node);
        }
    }

    public void writeStringsAfter(SimpleNode node) throws IOException {
        if (node.specialsAfter == null) {
            return;
        }
        Iterator<Object> iterator = node.specialsAfter.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof String) {
                this.state.write(this.prefs.getReplacement((String)o));
                continue;
            }
            if (!(o instanceof SpecialStr)) continue;
            this.state.write(this.prefs.getReplacement(o.toString()));
        }
    }

    public void writeCommentsAfter(SimpleNode node) throws IOException {
        if (node.specialsAfter == null) {
            return;
        }
        Iterator<Object> iterator = node.specialsAfter.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof commentType)) continue;
            commentType type = (commentType)o;
            if (type.beginColumn == 1 && this.state.lastIsIndent()) {
                this.state.eraseIndent();
            }
            this.state.write(type.id);
            this.state.writeNewLine();
            this.state.writeIndent();
        }
    }

    public boolean hasCommentsAfter(SimpleNode node) {
        if (node.specialsAfter != null) {
            Iterator<Object> iterator = node.specialsAfter.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof commentType)) continue;
                return true;
            }
        }
        return false;
    }

    public void moveComments(SimpleNode from, SimpleNode to, boolean moveBefore, boolean moveAfter) {
        this.moveComments(from, to, moveBefore, moveAfter, false);
    }

    public void moveComments(SimpleNode from, SimpleNode to, boolean moveBefore, boolean moveAfter, boolean onlyInDifferentLine) {
        Object o;
        Iterator<Object> iter;
        if (moveBefore && from.specialsBefore != null) {
            iter = from.specialsBefore.iterator();
            while (iter.hasNext()) {
                o = iter.next();
                if (!(o instanceof commentType)) continue;
                to.addSpecial(o, false);
                iter.remove();
            }
        }
        if (moveAfter && from.specialsAfter != null) {
            iter = from.specialsAfter.iterator();
            while (iter.hasNext()) {
                o = iter.next();
                if (!(o instanceof commentType)) continue;
                commentType c = (commentType)o;
                if (onlyInDifferentLine) {
                    if (from.beginLine == c.beginLine) continue;
                    to.addSpecial(o, false);
                    iter.remove();
                    continue;
                }
                to.addSpecial(o, false);
                iter.remove();
            }
        }
    }
}

