/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;

public class While
extends stmtType {
    public exprType test;
    public stmtType[] body;
    public suiteType orelse;

    public While(exprType test, stmtType[] body, suiteType orelse) {
        this.test = test;
        this.body = body;
        this.orelse = orelse;
    }

    public While(exprType test, stmtType[] body, suiteType orelse, SimpleNode parent) {
        this(test, body, orelse);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("While[");
        sb.append("test=");
        sb.append(this.dumpThis(this.test));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("orelse=");
        sb.append(this.dumpThis(this.orelse));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitWhile(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.test != null) {
            this.test.accept(visitor);
        }
        if (this.body != null) {
            int i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.orelse != null) {
            this.orelse.accept(visitor);
        }
    }
}

