/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;

public class FunctionDef
extends stmtType {
    public NameTokType name;
    public argumentsType args;
    public stmtType[] body;
    public decoratorsType[] decs;
    public exprType returns;

    public FunctionDef(NameTokType name, argumentsType args, stmtType[] body, decoratorsType[] decs, exprType returns) {
        this.name = name;
        this.args = args;
        this.body = body;
        this.decs = decs;
        this.returns = returns;
    }

    public FunctionDef(NameTokType name, argumentsType args, stmtType[] body, decoratorsType[] decs, exprType returns, SimpleNode parent) {
        this(name, args, body, decs, returns);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FunctionDef[");
        sb.append("name=");
        sb.append(this.dumpThis(this.name));
        sb.append(", ");
        sb.append("args=");
        sb.append(this.dumpThis(this.args));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("decs=");
        sb.append(this.dumpThis(this.decs));
        sb.append(", ");
        sb.append("returns=");
        sb.append(this.dumpThis(this.returns));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitFunctionDef(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.args != null) {
            this.args.accept(visitor);
        }
        if (this.body != null) {
            i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.decs != null) {
            i = 0;
            while (i < this.decs.length) {
                if (this.decs[i] != null) {
                    this.decs[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.returns != null) {
            this.returns.accept(visitor);
        }
    }
}

