/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.exprType;

public class Comprehension
extends comprehensionType {
    public exprType target;
    public exprType iter;
    public exprType[] ifs;

    public Comprehension(exprType target, exprType iter, exprType[] ifs) {
        this.target = target;
        this.iter = iter;
        this.ifs = ifs;
    }

    public Comprehension(exprType target, exprType iter, exprType[] ifs, SimpleNode parent) {
        this(target, iter, ifs);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Comprehension[");
        sb.append("target=");
        sb.append(this.dumpThis(this.target));
        sb.append(", ");
        sb.append("iter=");
        sb.append(this.dumpThis(this.iter));
        sb.append(", ");
        sb.append("ifs=");
        sb.append(this.dumpThis(this.ifs));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitComprehension(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.target != null) {
            this.target.accept(visitor);
        }
        if (this.iter != null) {
            this.iter.accept(visitor);
        }
        if (this.ifs != null) {
            int i = 0;
            while (i < this.ifs.length) {
                if (this.ifs[i] != null) {
                    this.ifs[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

