/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.grammarcommon.IJJTPythonGrammarState;
import org.python.pydev.parser.grammarcommon.ITreeBuilder;
import org.python.pydev.parser.grammarcommon.IntStack;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;

public abstract class AbstractJJTPythonGrammarState
implements IJJTPythonGrammarState {
    protected FastStack<SimpleNode> nodes = new FastStack();
    protected IntStack marks = new IntStack();
    protected IntStack lines = new IntStack();
    protected IntStack columns = new IntStack();
    protected int sp = 0;
    protected int mk = 0;
    protected boolean node_created;
    public ITreeBuilder builder = this.createBuilder();

    protected abstract ITreeBuilder createBuilder();

    protected AbstractJJTPythonGrammarState() {
    }

    public final SimpleNode getLastOpened() {
        return this.builder.getLastOpened();
    }

    public boolean nodeCreated() {
        return this.node_created;
    }

    public void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    public Node rootNode() {
        return (Node)this.nodes.getFirst();
    }

    public void pushNode(SimpleNode n) {
        this.nodes.push((Object)n);
        ++this.sp;
    }

    public SimpleNode popNode() {
        if (--this.sp < this.mk) {
            this.mk = this.marks.pop();
        }
        return (SimpleNode)this.nodes.pop();
    }

    public SimpleNode peekNode() {
        return (SimpleNode)this.nodes.peek();
    }

    public SimpleNode peekNode(int i) {
        return (SimpleNode)this.nodes.peek(i);
    }

    public int nodeArity() {
        return this.sp - this.mk;
    }

    public void pushNodePos(int line, int col) {
        this.lines.push(line);
        this.columns.push(col);
    }

    public SimpleNode setNodePos() {
        SimpleNode n = this.peekNode();
        int popLine = this.lines.pop();
        if (n.beginLine == 0) {
            n.beginLine = popLine;
        }
        int popCol = this.columns.pop();
        if (n.beginColumn == 0) {
            n.beginColumn = popCol;
        }
        return n;
    }

    public void clearNodeScope(Node n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    public void openNodeScope(Node n) {
        this.marks.push(this.mk);
        this.mk = this.sp;
    }

    public void closeNodeScope(Node n, int num) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        this.mk = this.marks.pop();
        SimpleNode newNode = null;
        try {
            newNode = this.builder.closeNode(sn, num);
        }
        catch (ParseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new ParseException("Internal error:" + exc);
        }
        if (newNode == null) {
            throw new ParseException("Internal AST builder error");
        }
        this.pushNode(newNode);
        this.node_created = true;
    }

    public void closeNodeScope(Node n, boolean condition) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        if (condition) {
            SimpleNode newNode = null;
            try {
                newNode = this.builder.closeNode(sn, this.nodeArity());
            }
            catch (ParseException exc) {
                throw exc;
            }
            catch (ClassCastException exc) {
                exc.printStackTrace();
                throw new ParseException("Internal error:" + exc);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new ParseException("Internal error:" + exc);
            }
            if (newNode == null) {
                throw new ParseException("Internal AST builder error when closing node:" + sn);
            }
            this.mk = this.marks.size() > 0 ? this.marks.pop() : 0;
            this.pushNode(newNode);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }
}

