/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.remote.RemoteDebugger;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleRunner;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonRunner {
    private static void checkProcess(Process p, IProcess process) throws CoreException {
        if (process == null) {
            p.destroy();
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Could not register with debug plugin?", null));
        }
    }

    private static void checkProcess(Process p) throws CoreException {
        if (p == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Could not execute python process. Was it cancelled?", null));
        }
    }

    public static void run(final PythonRunnerConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException, IOException {
        final IInterpreterManager interpreterManager = config.getRelatedInterpreterManager();
        if (!interpreterManager.hasInfoOnInterpreter(config.interpreterLocation)) {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    String msg = "The interpreter '%s' is not correctly configured as a '%s' interpreter.\n\nReasons: If it is an old interpreter, you can open the run dialog (Menu: run > run) and choose a new interpreter in the arguments tab.\n\nAnother reason could be that you're running some file from a jython project with a python interpreter (or vice-versa), so, you have to change the project type in the project properties.";
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)"Invalid Interpreter", (String)StringUtils.format((String)msg, (Object[])new Object[]{config.interpreterLocation, interpreterManager.getManagerRelatedName()}));
                }
            });
            return;
        }
        try {
            if (config.isDebug) {
                PythonRunner.runDebug(config, launch, monitor);
            } else if (config.isUnittest()) {
                PythonRunner.doIt(config, monitor, config.envp, config.getCommandLine(true), config.workingDirectory, launch);
            } else {
                PythonRunner.doIt(config, monitor, config.envp, config.getCommandLine(true), config.workingDirectory, launch);
            }
        }
        catch (JDTNotAvailableException e) {
            PydevPlugin.log((Throwable)e);
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)"Unable to run the selected configuration.", (String)e.getMessage());
                }
            });
        }
    }

    private static void runDebug(PythonRunnerConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException, IOException, JDTNotAvailableException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
        subMonitor.beginTask("Launching python", 1);
        RemoteDebugger debugger = new RemoteDebugger(config);
        debugger.startConnect((IProgressMonitor)subMonitor);
        subMonitor.subTask("Constructing command_line...");
        String[] cmdLine = config.getCommandLine(true);
        Process p = PythonRunner.createProcess(launch, config.envp, cmdLine, config.workingDirectory);
        PythonRunner.checkProcess(p);
        IProcess process = PythonRunner.registerWithDebugPlugin(config, launch, p);
        PythonRunner.checkProcess(p, process);
        subMonitor.subTask("Waiting for connection...");
        Socket socket = null;
        try {
            socket = debugger.waitForConnect((IProgressMonitor)subMonitor, p, process);
            if (socket == null) {
                debugger.dispose();
                return;
            }
        }
        catch (Exception ex) {
            process.terminate();
            p.destroy();
            String message = "Unexpected error setting up the debugger";
            if (ex instanceof SocketTimeoutException) {
                message = new StringBuffer("Timed out after ").append(Float.toString(config.acceptTimeout / 1000)).append(" seconds while waiting for python script to connect.").toString();
            }
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, message, ex));
        }
        subMonitor.subTask("Done");
        PyDebugTarget t = new PyDebugTarget(launch, process, config.resource, debugger);
        launch.setSourceLocator((ISourceLocator)new PySourceLocator());
        t.startTransmission(socket);
        t.initialize();
        t.addConsoleInputListener();
    }

    private static IProcess doIt(PythonRunnerConfig config, IProgressMonitor monitor, String[] envp, String[] cmdLine, File workingDirectory, ILaunch launch) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
        subMonitor.beginTask("Launching python", 1);
        subMonitor.subTask("Constructing command_line...");
        String commandLineAsString = SimpleRunner.getArgumentsAsStr((String[])cmdLine, (String[])new String[0]);
        HashMap<Object, Object> processAttributes = new HashMap<Object, Object>();
        processAttributes.put(IProcess.ATTR_CMDLINE, commandLineAsString);
        subMonitor.subTask("Exec...");
        Process p = PythonRunner.createProcess(launch, envp, cmdLine, workingDirectory);
        PythonRunner.checkProcess(p);
        String label = cmdLine[cmdLine.length - 1];
        if (config.isInteractive) {
            throw new RuntimeException("Interactive not supported here!");
        }
        IProcess process = PythonRunner.registerWithDebugPluginForProcessType(label, launch, p, processAttributes, config.getProcessType());
        PythonRunner.checkProcess(p, process);
        subMonitor.subTask("Done");
        return process;
    }

    private static Process createProcess(ILaunch launch, String[] envp, String[] cmdLine, File workingDirectory) throws CoreException {
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding != null && encoding.trim().length() > 0) {
            String[] s = new String[envp.length + 2];
            System.arraycopy(envp, 0, s, 0, envp.length);
            s[s.length - 2] = new StringBuffer("PYDEV_CONSOLE_ENCODING=").append(encoding).toString();
            s[s.length - 1] = new StringBuffer("PYTHONIOENCODING=").append(encoding).toString();
            envp = s;
        }
        Process p = DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envp);
        return p;
    }

    private static IProcess registerWithDebugPlugin(PythonRunnerConfig config, ILaunch launch, Process p) throws JDTNotAvailableException {
        HashMap<Object, Object> processAttributes = new HashMap<Object, Object>();
        processAttributes.put(IProcess.ATTR_CMDLINE, config.getCommandLineAsString());
        return PythonRunner.registerWithDebugPluginForProcessType(config.getRunningName(), launch, p, processAttributes, config.getProcessType());
    }

    private static IProcess registerWithDebugPluginForProcessType(String label, ILaunch launch, Process p, Map<Object, Object> processAttributes, String processType) {
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, processType);
        processAttributes.put(IProcess.ATTR_PROCESS_LABEL, label);
        processAttributes.put("org.eclipse.debug.core.capture_output", "true");
        return DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, processAttributes);
    }
}

