/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.ui.wizards.files.AbstractPythonWizard;
import org.python.pydev.ui.wizards.files.PythonAbstractPathPage;

public class PythonModuleWizard
extends AbstractPythonWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.files.PythonModuleWizard";

    public PythonModuleWizard() {
        super("Create a new Python module");
    }

    protected PythonAbstractPathPage createPathPage() {
        return new PythonAbstractPathPage(this.description, this.selection){

            protected boolean shouldCreatePackageSelect() {
                return true;
            }
        };
    }

    protected IFile doCreateNew(IProgressMonitor monitor) throws CoreException {
        IContainer validatedSourceFolder = this.filePage.getValidatedSourceFolder();
        if (validatedSourceFolder == null) {
            return null;
        }
        IContainer validatedPackage = this.filePage.getValidatedPackage();
        if (validatedPackage == null) {
            return null;
        }
        String validatedName = String.valueOf(this.filePage.getValidatedName()) + FileTypesPreferencesPage.getDefaultDottedPythonExtension();
        IFile file = validatedPackage.getFile((IPath)new Path(validatedName));
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
        }
        return file;
    }
}

