/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.IPythonPathContributor;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonPathNature
implements IPythonPathNature {
    private IProject project;
    private PythonNature nature;
    private static QualifiedName projectSourcePathQualifiedName = null;
    private static QualifiedName projectExternalSourcePathQualifiedName = null;
    private Set<String> projectSourcePathSet;

    static QualifiedName getProjectSourcePathQualifiedName() {
        if (projectSourcePathQualifiedName == null) {
            projectSourcePathQualifiedName = new QualifiedName(PydevPlugin.getPluginID(), "PROJECT_SOURCE_PATH");
        }
        return projectSourcePathQualifiedName;
    }

    static QualifiedName getProjectExternalSourcePathQualifiedName() {
        if (projectExternalSourcePathQualifiedName == null) {
            projectExternalSourcePathQualifiedName = new QualifiedName(PydevPlugin.getPluginID(), "PROJECT_EXTERNAL_SOURCE_PATH");
        }
        return projectExternalSourcePathQualifiedName;
    }

    public void setProject(IProject project, IPythonNature nature) {
        this.project = project;
        this.nature = (PythonNature)nature;
        if (project == null) {
            this.projectSourcePathSet = null;
        }
    }

    public List<String> getCompleteProjectPythonPath(String interpreter) {
        IModulesManager projectModulesManager = this.getProjectModulesManager();
        if (projectModulesManager == null) {
            return null;
        }
        return projectModulesManager.getCompletePythonPath(interpreter);
    }

    private IModulesManager getProjectModulesManager() {
        if (this.project == null) {
            return null;
        }
        if (this.nature == null) {
            return null;
        }
        if (this.nature.getAstManager() == null) {
            return null;
        }
        return this.nature.getAstManager().getModulesManager();
    }

    public String getOnlyProjectPythonPathStr() throws CoreException {
        if (this.project == null) {
            return "";
        }
        String source = this.getProjectSourcePath();
        String external = this.getProjectExternalSourcePath();
        String contributed = this.getContributedSourcePath();
        if (source == null) {
            source = "";
        }
        String[] strings = source.split("\\|");
        FastStringBuffer buf = new FastStringBuffer();
        int i = 0;
        while (i < strings.length) {
            if (strings[i].trim().length() > 0) {
                Path p = new Path(strings[i]);
                if (ResourcesPlugin.getPlugin() == null) {
                    buf.append(strings[i]);
                    buf.append("|");
                } else {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IContainer container = null;
                    IResource r = null;
                    try {
                        r = root.findMember((IPath)p);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                    if (r instanceof IContainer) {
                        container = (IContainer)r;
                        buf.append(REF.getFileAbsolutePath((File)container.getLocation().toFile()));
                        buf.append("|");
                    } else if (r instanceof IFile) {
                        String extension = r.getFileExtension();
                        if (extension == null || !FileTypesPreferencesPage.isValidZipFile(new StringBuffer(".").append(extension).toString())) {
                            PydevPlugin.log(new StringBuffer("Error: the path ").append(strings[i]).append(" is a file but is not a recognized zip file.").toString());
                        } else {
                            buf.append(REF.getFileAbsolutePath((File)r.getLocation().toFile()));
                            buf.append("|");
                        }
                    } else {
                        if (root.isSynchronized(2)) {
                            Log.log((int)2, (String)new StringBuffer("Unable to find the path ").append(strings[i]).append(" in the project were it's \n").append("added as a source folder for pydev (project: ").append(this.project.getName()).append(") member:").append(r).toString(), null);
                        }
                        IPath rootLocation = root.getRawLocation();
                        buf.append(REF.getFileAbsolutePath((File)rootLocation.append(strings[i].trim()).toFile()));
                        buf.append("|");
                    }
                }
            }
            ++i;
        }
        if (external == null) {
            external = "";
        }
        return buf.append("|").append(external).append("|").append(contributed).toString();
    }

    private String getContributedSourcePath() throws CoreException {
        FastStringBuffer buff = new FastStringBuffer();
        List contributors = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_pythonpath_contrib");
        for (IPythonPathContributor contributor : contributors) {
            String additionalPythonPath = contributor.getAdditionalPythonPath(this.project);
            if (additionalPythonPath == null || additionalPythonPath.trim().length() <= 0) continue;
            if (buff.length() > 0) {
                buff.append("|");
            }
            buff.append(additionalPythonPath.trim());
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectSourcePath(String newSourcePath) throws CoreException {
        IProject iProject = this.project;
        synchronized (iProject) {
            this.projectSourcePathSet = null;
            this.nature.getStore().setPathProperty(PythonPathNature.getProjectSourcePathQualifiedName(), newSourcePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectExternalSourcePath(String newExternalSourcePath) throws CoreException {
        IProject iProject = this.project;
        synchronized (iProject) {
            this.nature.getStore().setPathProperty(PythonPathNature.getProjectExternalSourcePathQualifiedName(), newExternalSourcePath);
        }
    }

    public Set<String> getProjectSourcePathSet() throws CoreException {
        if (this.project == null) {
            return new HashSet<String>();
        }
        if (this.projectSourcePathSet == null) {
            String projectSourcePath = this.getProjectSourcePath();
            String[] paths = projectSourcePath.split("\\|");
            this.projectSourcePathSet = new HashSet<String>((Collection)Arrays.asList(paths));
        }
        return this.projectSourcePathSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectSourcePath() throws CoreException {
        if (this.project == null) {
            return "";
        }
        IProject iProject = this.project;
        synchronized (iProject) {
            String[] paths;
            String projectSourcePath;
            boolean restore;
            block10: {
                restore = false;
                projectSourcePath = this.nature.getStore().getPathProperty(PythonPathNature.getProjectSourcePathQualifiedName());
                if (projectSourcePath != null) break block10;
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            String[] stringArray = paths = projectSourcePath.split("\\|");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                Path p;
                String path = stringArray[n2];
                if (path.trim().length() > 0 && !(p = new Path(path)).isEmpty()) {
                    IPath projectPath = this.project.getFullPath();
                    if (projectPath != null && !projectPath.isPrefixOf((IPath)p)) {
                        p = p.removeFirstSegments(1);
                        p = projectPath.append((IPath)p);
                        restore = true;
                    }
                    buffer.append(p.toString());
                    buffer.append("|");
                }
                ++n2;
            }
            if (restore) {
                this.projectSourcePathSet = null;
                projectSourcePath = buffer.toString();
                this.setProjectSourcePath(projectSourcePath);
                if (this.nature != null) {
                    this.nature.rebuildPath();
                }
            }
            return projectSourcePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectExternalSourcePath() throws CoreException {
        if (this.project == null) {
            return "";
        }
        IProject iProject = this.project;
        synchronized (iProject) {
            String extPath = this.nature.getStore().getPathProperty(PythonPathNature.getProjectExternalSourcePathQualifiedName());
            if (extPath == null) {
                extPath = "";
            }
            return extPath;
        }
    }
}

