/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.modules;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.TupleN;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModuleForZip;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModule
implements IModule {
    private static final IToken[] EMPTY_TOKEN_ARRAY = new IToken[0];
    public static String MODULE_NAME_WHEN_FILE_IS_UNDEFINED = "";
    protected String name;

    public abstract IToken[] getWildImportedModules();

    public abstract File getFile();

    public abstract IToken[] getTokenImportedModules();

    public abstract IToken[] getGlobalTokens();

    public abstract boolean isInDirectGlobalTokens(String var1, ICompletionCache var2);

    public abstract Definition[] findDefinition(ICompletionState var1, int var2, int var3, IPythonNature var4) throws Exception;

    public abstract IToken[] getGlobalTokens(ICompletionState var1, ICodeCompletionASTManager var2);

    public abstract String getDocString();

    public String getZipFilePath() {
        return null;
    }

    public IToken[] getLocalTokens(int line, int col, ILocalScope scope) {
        return EMPTY_TOKEN_ARRAY;
    }

    public boolean isInGlobalTokens(String tok, IPythonNature nature, ICompletionCache completionCache) throws CompletionRecursionException {
        return this.isInGlobalTokens(tok, nature, true, completionCache);
    }

    public boolean isInGlobalTokens(String tok, IPythonNature nature, boolean searchSameLevelMods, ICompletionCache completionCache) throws CompletionRecursionException {
        return this.isInGlobalTokens(tok, nature, searchSameLevelMods, false, completionCache) != 0;
    }

    public int isInGlobalTokens(String tok, IPythonNature nature, boolean searchSameLevelMods, boolean ifHasGetAttributeConsiderInTokens, ICompletionCache completionCache) throws CompletionRecursionException {
        if (tok.indexOf(".") == -1 && this.isInDirectGlobalTokens(tok, completionCache)) {
            return 1;
        }
        String[] headAndTail = FullRepIterable.headAndTail((String)tok);
        String head = headAndTail[1];
        String name = this.getName();
        TupleN key = new TupleN(new Object[]{"isInGlobalTokens", name != null ? name : "", tok, Autobox.valueOf((boolean)searchSameLevelMods)});
        Map<String, IToken> cachedTokens = (Map<String, IToken>)completionCache.getObj((Object)key);
        if (cachedTokens == null) {
            cachedTokens = this.internalGenerateCachedTokens(nature, completionCache, headAndTail[0], searchSameLevelMods);
            completionCache.add((Object)key, cachedTokens);
        }
        if (cachedTokens.containsKey(head)) {
            return 1;
        }
        if (ifHasGetAttributeConsiderInTokens) {
            IToken token = cachedTokens.get("__getattribute__");
            if (token == null || this.isTokenFromBuiltins(token)) {
                token = cachedTokens.get("__getattr__");
            }
            if (token != null && !this.isTokenFromBuiltins(token)) {
                return 2;
            }
        }
        return 0;
    }

    private boolean isTokenFromBuiltins(IToken token) {
        String parentPackage = token.getParentPackage();
        return parentPackage.equals("__builtin__") || parentPackage.startsWith("__builtin__.") || parentPackage.equals("builtins") || parentPackage.startsWith("builtins.");
    }

    private Map<String, IToken> internalGenerateCachedTokens(IPythonNature nature, ICompletionCache completionCache, String activationToken, boolean searchSameLevelMods) throws CompletionRecursionException {
        IToken[] globalTokens;
        HashMap<String, IToken> cachedTokens = new HashMap<String, IToken>();
        ICompletionState state = CompletionStateFactory.getEmptyCompletionState(nature, completionCache);
        ICodeCompletionASTManager astManager = nature.getAstManager();
        state.setActivationToken(activationToken);
        state.setBuiltinsGotten(true);
        IToken[] iTokenArray = globalTokens = astManager.getCompletionsForModule((IModule)this, state, searchSameLevelMods);
        int n = globalTokens.length;
        int n2 = 0;
        while (n2 < n) {
            IToken token = iTokenArray[n2];
            String rep = token.getRepresentation();
            IToken t = (IToken)cachedTokens.get(rep);
            if (t != null) {
                if ((rep.equals("__getattribute__") || rep.equals("__getattr__")) && !this.isTokenFromBuiltins(token)) {
                    cachedTokens.put(rep, token);
                }
            } else {
                cachedTokens.put(rep, token);
            }
            ++n2;
        }
        return cachedTokens;
    }

    public String getName() {
        return this.name;
    }

    protected AbstractModule(String name) {
        this.name = name;
    }

    public static AbstractModule createModule(String name, File f, IPythonNature nature, int currLine) throws IOException {
        String path = REF.getFileAbsolutePath((File)f);
        if (PythonPathHelper.isValidFileMod(path)) {
            if (PythonPathHelper.isValidSourceFile(path)) {
                return AbstractModule.createModuleFromDoc(name, f, REF.getDocFromFile((File)f), nature, currLine);
            }
            return new CompiledModule(name, nature.getAstManager());
        }
        return null;
    }

    public static AbstractModule createModuleFromDoc(String name, File f, IDocument doc, IPythonNature nature, int currLine) {
        return AbstractModule.createModuleFromDoc(name, f, doc, nature, currLine, true);
    }

    public static AbstractModule createModuleFromDoc(String name, File f, IDocument doc, IPythonNature nature, int currLine, boolean checkForPath) {
        if (f != null) {
            if (!checkForPath || PythonPathHelper.isValidSourceFile(REF.getFileAbsolutePath((File)f))) {
                Tuple obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, true, nature, currLine, name, f));
                return new SourceModule(name, f, (SimpleNode)obj.o1, (Throwable)obj.o2);
            }
        } else {
            Tuple obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, true, nature, currLine, name, f));
            return new SourceModule(name, f, (SimpleNode)obj.o1, (Throwable)obj.o2);
        }
        return null;
    }

    public static IModule createModuleFromDoc(File file, IDocument doc, IPythonNature pythonNature, int line, IModulesManager projModulesManager) {
        String moduleName = null;
        if (file != null) {
            moduleName = projModulesManager.resolveModule(REF.getFileAbsolutePath((File)file));
        }
        if (moduleName == null) {
            moduleName = MODULE_NAME_WHEN_FILE_IS_UNDEFINED;
        }
        AbstractModule module = AbstractModule.createModuleFromDoc(moduleName, file, doc, pythonNature, line, false);
        return module;
    }

    public static IModule createModule(SimpleNode n) {
        return new SourceModule(null, null, n, null);
    }

    public static IModule createModule(SimpleNode n, File file, String moduleName) {
        return new SourceModule(moduleName, file, n, null);
    }

    public static AbstractModule createEmptyModule(ModulesKey key) {
        if (key instanceof ModulesKeyForZip) {
            ModulesKeyForZip e = (ModulesKeyForZip)key;
            return new EmptyModuleForZip(key.name, key.file, e.zipModulePath, e.isFile);
        }
        return new EmptyModule(key.name, key.file);
    }

    public ILocalScope getLocalScope(int line, int col) {
        return null;
    }

    public String toString() {
        String n2 = this.getClass().getName();
        String n = n2.substring(n2.lastIndexOf(46) + 1);
        return new StringBuffer(String.valueOf(this.getName())).append(" (").append(n).append(")").toString();
    }

    public boolean isPackage() {
        return this.name != null && this.name.endsWith(".__init__");
    }

    public String getPackageFolderName() {
        return FullRepIterable.getParentModule((String)this.name);
    }

    public /* synthetic */ IDefinition[] findDefinition(ICompletionState iCompletionState, int n, int n2, IPythonNature iPythonNature) throws Exception {
        return this.findDefinition(iCompletionState, n, n2, iPythonNature);
    }
}

