/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManagerBuild;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaProjectModulesManagerCreator;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.ModulesKeyForJava;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.NotConfiguredInterpreterException;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectModulesManager
extends ProjectModulesManagerBuild
implements IDeltaProcessor<ModulesKey> {
    private static final long serialVersionUID = 1L;
    public static boolean IN_TESTS = false;
    private static final boolean DEBUG_MODULES = false;
    private transient IProject project;
    private transient IPythonNature nature;
    private transient DeltaSaver<ModulesKey> deltaSaver;

    public void setProject(IProject project, IPythonNature nature, boolean restoreDeltas) {
        this.project = project;
        this.nature = nature;
        this.deltaSaver = new DeltaSaver(this.nature.getCompletionsCacheDir(), "astdelta", (ICallback)new ICallback<Object, ObjectInputStream>(){

            public ModulesKey call(ObjectInputStream arg) {
                try {
                    return (ModulesKey)arg.readObject();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((ObjectInputStream)object);
            }
        });
        if (!restoreDeltas) {
            this.deltaSaver.clearAll();
        } else {
            this.deltaSaver.processDeltas((IDeltaProcessor)this);
        }
    }

    public void processUpdate(ModulesKey data) {
        throw new RuntimeException("Not impl");
    }

    public void processDelete(ModulesKey key) {
        super.doRemoveSingleModule(key);
    }

    public void processInsert(ModulesKey key) {
        super.addModule(key);
    }

    public void endProcessing() {
        this.nature.saveAstManager();
    }

    @Override
    public void doRemoveSingleModule(ModulesKey key) {
        super.doRemoveSingleModule(key);
        if (this.deltaSaver != null && !IN_TESTS) {
            this.deltaSaver.addDeleteCommand((Object)key);
            this.checkDeltaSize();
        }
    }

    @Override
    public void doAddSingleModule(ModulesKey key, AbstractModule n) {
        super.doAddSingleModule(key, n);
        if (!(this.deltaSaver == null || IN_TESTS || key instanceof ModulesKeyForZip || key instanceof ModulesKeyForJava)) {
            this.deltaSaver.addInsertCommand((Object)key);
            this.checkDeltaSize();
        }
    }

    private void checkDeltaSize() {
        if (this.deltaSaver.availableDeltas() > 100) {
            this.nature.saveAstManager();
            this.deltaSaver.clearAll();
        }
    }

    public void setPythonNature(IPythonNature nature) {
        this.nature = nature;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public ISystemModulesManager getSystemModulesManager() {
        return this.getSystemModulesManager(null);
    }

    public ISystemModulesManager getSystemModulesManager(String defaultSelectedInterpreter) {
        InterpreterInfo info;
        if (this.nature == null) {
            PydevPlugin.log("Nature still not set");
            return null;
        }
        IInterpreterManager iMan = PydevPlugin.getInterpreterManager(this.nature);
        if (defaultSelectedInterpreter == null) {
            try {
                defaultSelectedInterpreter = iMan.getDefaultInterpreter();
            }
            catch (NotConfiguredInterpreterException notConfiguredInterpreterException) {
                return null;
            }
        }
        if ((info = (InterpreterInfo)iMan.getInterpreterInfo(defaultSelectedInterpreter, (IProgressMonitor)new NullProgressMonitor())) == null) {
            PydevPlugin.log("Info still not set");
            return null;
        }
        return info.getModulesManager();
    }

    @Override
    public Set<String> getAllModuleNames(boolean addDependencies, String partStartingWithLowerCase) {
        if (addDependencies) {
            HashSet<String> s = new HashSet<String>();
            IModulesManager[] managersInvolved = this.getManagersInvolved(true);
            int i = 0;
            while (i < managersInvolved.length) {
                s.addAll(managersInvolved[i].getAllModuleNames(false, partStartingWithLowerCase));
                ++i;
            }
            return s;
        }
        return super.getAllModuleNames(addDependencies, partStartingWithLowerCase);
    }

    @Override
    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String strStartingWith) {
        TreeMap<ModulesKey, ModulesKey> ret = new TreeMap<ModulesKey, ModulesKey>();
        IModulesManager[] managersInvolved = this.getManagersInvolved(true);
        int i = 0;
        while (i < managersInvolved.length) {
            ret.putAll(managersInvolved[i].getAllDirectModulesStartingWith(strStartingWith));
            ++i;
        }
        return ret;
    }

    @Override
    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        return this.getModule(name, nature, true, dontSearchInit);
    }

    public IModule getRelativeModule(String name, IPythonNature nature) {
        return super.getModule(false, name, nature, true);
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        Tuple<IModule, IModulesManager> ret = this.getModuleAndRelatedModulesManager(name, nature, checkSystemManager, dontSearchInit);
        if (ret != null) {
            return (IModule)ret.o1;
        }
        return null;
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        IModulesManager m;
        IModulesManager[] managersInvolved;
        IModule module = null;
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(true);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            m = iModulesManagerArray[n2];
            if (m instanceof ISystemModulesManager && (module = ((ISystemModulesManager)m).getBuiltinModule(name, nature, dontSearchInit)) != null) {
                return new Tuple((Object)module, (Object)m);
            }
            ++n2;
        }
        iModulesManagerArray = managersInvolved;
        n = managersInvolved.length;
        n2 = 0;
        while (n2 < n) {
            m = iModulesManagerArray[n2];
            if (m instanceof IProjectModulesManager) {
                IProjectModulesManager pM = (IProjectModulesManager)m;
                module = pM.getModuleInDirectManager(name, nature, dontSearchInit);
            } else if (m instanceof ISystemModulesManager) {
                ISystemModulesManager systemModulesManager = (ISystemModulesManager)m;
                module = systemModulesManager.getModuleWithoutBuiltins(name, nature, dontSearchInit);
            } else {
                throw new RuntimeException(new StringBuffer("Unexpected: ").append(m).toString());
            }
            if (module != null) {
                return new Tuple((Object)module, (Object)m);
            }
            ++n2;
        }
        return null;
    }

    public IModule getModuleInDirectManager(String name, IPythonNature nature, boolean dontSearchInit) {
        return super.getModule(name, nature, dontSearchInit);
    }

    @Override
    protected String getResolveModuleErr(IResource member) {
        return new StringBuffer("Unable to find the path ").append(member).append(" in the project were it\n").append("is added as a source folder for pydev (project: ").append(this.project.getName()).append(")").toString();
    }

    @Override
    public String resolveModule(String full) {
        return this.resolveModule(full, true);
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        IModulesManager[] managersInvolved;
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(checkSystemManager);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            String mod;
            IModulesManager m = iModulesManagerArray[n2];
            if (m instanceof IProjectModulesManager) {
                IProjectModulesManager pM = (IProjectModulesManager)m;
                mod = pM.resolveModuleInDirectManager(full);
            } else {
                mod = m.resolveModule(full);
            }
            if (mod != null) {
                return mod;
            }
            ++n2;
        }
        return null;
    }

    public String resolveModuleInDirectManager(String full) {
        return super.resolveModule(full);
    }

    public String resolveModuleInDirectManager(IFile member) {
        File inOs = member.getRawLocation().toFile();
        return this.resolveModuleInDirectManager(REF.getFileAbsolutePath((File)inOs));
    }

    @Override
    public int getSize(boolean addDependenciesSize) {
        if (addDependenciesSize) {
            int size = 0;
            IModulesManager[] managersInvolved = this.getManagersInvolved(true);
            int i = 0;
            while (i < managersInvolved.length) {
                size += managersInvolved[i].getSize(false);
                ++i;
            }
            return size;
        }
        return super.getSize(addDependenciesSize);
    }

    public String[] getBuiltins() {
        return this.getBuiltins(null);
    }

    @Override
    public String[] getBuiltins(String defaultSelectedInterpreter) {
        String[] builtins = null;
        ISystemModulesManager systemModulesManager = this.getSystemModulesManager(defaultSelectedInterpreter);
        if (systemModulesManager != null) {
            builtins = systemModulesManager.getBuiltins();
        }
        return builtins;
    }

    private synchronized IModulesManager[] getManagers(boolean checkSystemManager, boolean referenced) {
        IModulesManager[] ret;
        if (this.completionCache != null && (ret = this.completionCache.getManagers(referenced)) != null) {
            return ret;
        }
        ArrayList<IModulesManager> list = new ArrayList<IModulesManager>();
        ISystemModulesManager systemModulesManager = this.getSystemModulesManager(null);
        if (systemModulesManager == null) {
            return new IModulesManager[0];
        }
        list.add(this);
        if (this.project != null) {
            HashSet<IProject> projs = new HashSet<IProject>();
            ProjectModulesManager.getProjectsRecursively(this.project, referenced, projs);
            this.addModuleManagers(list, projs);
        }
        if (checkSystemManager && systemModulesManager != null) {
            list.add((IModulesManager)systemModulesManager);
        }
        IModulesManager[] ret2 = list.toArray(new IModulesManager[list.size()]);
        if (this.completionCache != null) {
            this.completionCache.setManagers(ret2, referenced);
        }
        return ret2;
    }

    public static void getProjectsRecursively(IProject project, boolean referenced, HashSet<IProject> memo) {
        IProject[] projects = null;
        try {
            projects = referenced ? project.getReferencedProjects() : project.getReferencingProjects();
        }
        catch (CoreException coreException) {}
        HashSet<IProject> newFound = new HashSet<IProject>();
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (!memo.contains(p)) {
                    memo.add(p);
                    newFound.add(p);
                }
                ++n2;
            }
        }
        for (IProject p : newFound) {
            ProjectModulesManager.getProjectsRecursively(p, referenced, memo);
        }
    }

    private void addModuleManagers(ArrayList<IModulesManager> list, Collection<IProject> projects) {
        for (IProject project : projects) {
            IModulesManager javaModulesManagerForProject;
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                ICodeCompletionASTManager otherProjectAstManager = nature.getAstManager();
                if (otherProjectAstManager != null) {
                    IModulesManager projectModulesManager = otherProjectAstManager.getModulesManager();
                    if (projectModulesManager != null) {
                        list.add(projectModulesManager);
                    }
                } else {
                    Log.log((int)2, (String)new StringBuffer("No ast manager configured for :").append(project.getName()).toString(), null);
                }
            }
            if ((javaModulesManagerForProject = JavaProjectModulesManagerCreator.createJavaProjectModulesManagerIfPossible(project)) == null) continue;
            list.add(javaModulesManagerForProject);
        }
    }

    public IModulesManager[] getManagersInvolved(boolean checkSystemManager) {
        return this.getManagers(checkSystemManager, true);
    }

    public IModulesManager[] getRefencingManagersInvolved(boolean checkSystemManager) {
        return this.getManagers(checkSystemManager, false);
    }

    public List<String> getCompletePythonPath(String interpreter) {
        IModulesManager[] managersInvolved;
        ArrayList<String> l = new ArrayList<String>();
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(true);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            IModulesManager m = iModulesManagerArray[n2];
            if (m instanceof ISystemModulesManager) {
                ISystemModulesManager systemModulesManager = (ISystemModulesManager)m;
                l.addAll(systemModulesManager.getCompletePythonPath(interpreter, this.nature));
            } else {
                PythonPathHelper h = (PythonPathHelper)m.getPythonPathHelper();
                if (h != null) {
                    l.addAll(h.getPythonpath());
                }
            }
            ++n2;
        }
        return l;
    }

    public /* synthetic */ void processUpdate(Object object) {
        this.processUpdate((ModulesKey)object);
    }

    public /* synthetic */ void processInsert(Object object) {
        this.processInsert((ModulesKey)object);
    }

    public /* synthetic */ void processDelete(Object object) {
        this.processDelete((ModulesKey)object);
    }
}

