/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ReturnVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignAnalysis {
    public static final Map<String, Integer> CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS = new HashMap<String, Integer>();

    static {
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("adapt".toLowerCase(), Autobox.valueOf((int)2));
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetSingleton".toLowerCase(), Autobox.valueOf((int)1));
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetImplementation".toLowerCase(), Autobox.valueOf((int)1));
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetAdapter".toLowerCase(), Autobox.valueOf((int)1));
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("get_adapter".toLowerCase(), Autobox.valueOf((int)1));
    }

    public List<IToken> getAssignCompletions(ICodeCompletionASTManager manager, IModule module, ICompletionState state) {
        ArrayList<IToken> ret = new ArrayList<IToken>();
        if (module instanceof SourceModule) {
            SourceModule s = (SourceModule)module;
            try {
                Definition[] defs = s.findDefinition(state, state.getLine() + 1, state.getCol() + 1, state.getNature());
                int i = 0;
                while (i < defs.length) {
                    Definition definition = defs[i];
                    AssignDefinition assignDefinition = null;
                    if (definition instanceof AssignDefinition) {
                        assignDefinition = (AssignDefinition)definition;
                    }
                    if (!(definition.ast instanceof FunctionDef)) {
                        this.addNonFunctionDefCompletionsFromAssign(manager, state, ret, s, definition, assignDefinition);
                    } else {
                        this.addFunctionDefCompletionsFromAssign(manager, state, ret, s, definition, assignDefinition);
                    }
                    ++i;
                }
            }
            catch (CompletionRecursionException completionRecursionException) {
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuffer("Error when getting assign completions for:").append(module.getName()).toString(), e);
            }
            catch (Throwable t) {
                throw new RuntimeException(new StringBuffer("A throwable exception has been detected ").append(t.getClass()).toString());
            }
        }
        return ret;
    }

    private void addFunctionDefCompletionsFromAssign(ICodeCompletionASTManager manager, ICompletionState state, ArrayList<IToken> ret, SourceModule s, Definition definition, AssignDefinition assignDefinition) throws CompletionRecursionException {
        FunctionDef functionDef = (FunctionDef)definition.ast;
        for (Return return1 : ReturnVisitor.findReturns((FunctionDef)functionDef)) {
            ICompletionState copy = state.getCopy();
            String act = NodeUtils.getFullRepresentationString((SimpleNode)return1.value);
            if (act == null) {
                return;
            }
            copy.setActivationToken(act);
            copy.setLine(return1.value.beginLine - 1);
            copy.setCol(return1.value.beginColumn - 1);
            IModule module = definition.module;
            state.checkDefinitionMemory(module, (IDefinition)definition);
            IToken[] tks = manager.getCompletionsForModule(module, copy);
            if (tks.length <= 0) continue;
            ret.addAll((Collection<IToken>)Arrays.asList(tks));
        }
    }

    private void addNonFunctionDefCompletionsFromAssign(ICodeCompletionASTManager manager, ICompletionState state, ArrayList<IToken> ret, SourceModule sourceModule, Definition definition, AssignDefinition assignDefinition) throws CompletionRecursionException {
        if (definition.ast instanceof ClassDef) {
            state.setLookingFor(2);
            ret.addAll(((SourceModule)definition.module).getClassToks(state, manager, definition.ast));
        } else {
            boolean lookForAssign = true;
            if (assignDefinition != null) {
                Assign assign = (Assign)assignDefinition.ast;
                if (assign.value instanceof Call) {
                    Call call = (Call)assign.value;
                    String lastPart = FullRepIterable.getLastPart((String)assignDefinition.value);
                    Integer parameterIndex = CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.get(lastPart.toLowerCase());
                    if (parameterIndex != null && call.args.length >= parameterIndex) {
                        String rep = NodeUtils.getFullRepresentationString((SimpleNode)call.args[parameterIndex - 1]);
                        HashSet hashSet = new HashSet();
                        ArrayList<String> lookForClass = new ArrayList<String>();
                        lookForClass.add(rep);
                        manager.getCompletionsForClassInLocalScope((IModule)sourceModule, state, true, false, lookForClass, hashSet);
                        if (hashSet.size() > 0) {
                            lookForAssign = false;
                            ret.addAll(hashSet);
                        }
                    }
                }
                if (lookForAssign && assignDefinition.foundAsGlobal) {
                    IToken[] allLocalTokens;
                    IToken[] iTokenArray = allLocalTokens = assignDefinition.scope.getAllLocalTokens();
                    int n = allLocalTokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        List<IToken> classToks;
                        SourceToken srcToken;
                        IToken token = iTokenArray[n2];
                        if (token.getRepresentation().equals(assignDefinition.value) && token instanceof SourceToken && (srcToken = (SourceToken)token).getAst() instanceof ClassDef && (classToks = ((SourceModule)assignDefinition.module).getClassToks(state, manager, srcToken.getAst())).size() > 0) {
                            lookForAssign = false;
                            ret.addAll(classToks);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (lookForAssign) {
                state.setLookingFor(4);
                ICompletionState copy = state.getCopy();
                if (definition.ast instanceof Attribute) {
                    copy.setActivationToken(NodeUtils.getFullRepresentationString((SimpleNode)definition.ast));
                } else {
                    copy.setActivationToken(definition.value);
                }
                copy.setLine(definition.line);
                copy.setCol(definition.col);
                IModule module = definition.module;
                state.checkDefinitionMemory(module, (IDefinition)definition);
                if (assignDefinition != null) {
                    Collection interfaceForLocal = assignDefinition.scope.getInterfaceForLocal(assignDefinition.target);
                    ret.addAll(interfaceForLocal);
                }
                IToken[] tks = manager.getCompletionsForModule(module, copy);
                ret.addAll((Collection<IToken>)Arrays.asList(tks));
            }
        }
    }
}

