/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinter;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.python.pydev.core.REF;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Break;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Continue;
import org.python.pydev.parser.jython.ast.Delete;
import org.python.pydev.parser.jython.ast.Exec;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.List;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Slice;
import org.python.pydev.parser.jython.ast.StrJoin;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.prettyprinter.AuxSpecials;
import org.python.pydev.parser.prettyprinter.PrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinter.WriteState;

public class PrettyPrinterUtils
extends VisitorBase {
    protected PrettyPrinterPrefs prefs;
    protected WriteState state;
    protected AuxSpecials auxComment;
    public static final String[] boolOperatorMapping = new String[]{"<undef>", " and ", " or "};
    public static final String[] unaryopOperatorMapping = new String[]{"<undef>", "Invert", "not ", "UAdd", "-"};
    public static final String[] operatorMapping = new String[]{"<undef>", " + ", " - ", " * ", " / ", " % ", " ** ", " << ", " >> ", " | ", " ^ ", " & ", " // "};
    public static final String[] augOperatorMapping = new String[]{"<undef>", " += ", " -= ", " *= ", " /= ", " %= ", " **= ", " <<= ", " >>= ", " |= ", " ^= ", " &= ", " //= "};
    public static final String[] cmpop = new String[]{"<undef>", " == ", " != ", " < ", " <= ", " > ", " >= ", " is ", " is not ", " in ", " not in "};
    public static final Map<String, Method> superMethods = new HashMap<String, Method>();

    static {
        PrettyPrinterUtils.addMethod("visitYield", "superYield");
        PrettyPrinterUtils.addMethod("visitPass", "superPass");
        PrettyPrinterUtils.addMethod("visitImport", "superImport");
        PrettyPrinterUtils.addMethod("visitPrint", "superPrint");
        PrettyPrinterUtils.addMethod("visitSubscript", "superSubscript");
        PrettyPrinterUtils.addMethod("visitList", "superList");
        PrettyPrinterUtils.addMethod("visitBreak", "superBreak");
        PrettyPrinterUtils.addMethod("visitContinue", "superContinue");
        PrettyPrinterUtils.addMethod("visitReturn", "superReturn");
        PrettyPrinterUtils.addMethod("visitSlice", "superSlice");
        PrettyPrinterUtils.addMethod("visitIndex", "superIndex");
        PrettyPrinterUtils.addMethod("visitDelete", "superDelete");
        PrettyPrinterUtils.addMethod("visitListComp", "superListComp");
        PrettyPrinterUtils.addMethod("visitExec", "superExec");
        PrettyPrinterUtils.addMethod("visitTuple", "superTuple");
        PrettyPrinterUtils.addMethod("visitLambda", "superLambda");
        PrettyPrinterUtils.addMethod("visitComprehension", "superComprehension");
        PrettyPrinterUtils.addMethod("visitRaise", "superRaise");
        PrettyPrinterUtils.addMethod("visitStrJoin", "superStrJoin");
        PrettyPrinterUtils.addMethod("visitAssert", "superAssert");
        PrettyPrinterUtils.addMethod("visitGlobal", "superGlobal");
        PrettyPrinterUtils.addMethod("visitWith", "superWith");
        PrettyPrinterUtils.addMethod("visitExpr", "superExpr");
    }

    protected void checkEndRecord() throws IOException {
        this.afterNode(null, false);
    }

    protected void afterNode(SimpleNode node) throws IOException {
        this.afterNode(node, true);
    }

    protected void afterNode(SimpleNode node, boolean isNewScope) throws IOException {
        if (node != null) {
            this.auxComment.writeSpecialsAfter(node, isNewScope);
        }
        if (!this.state.inStmt()) {
            this.fixNewStatementCondition();
        }
    }

    protected void dedent() {
        if (this.state.lastIsIndent()) {
            this.state.eraseIndent();
        }
        this.state.dedent();
    }

    protected void beforeNode(SimpleNode node) throws IOException {
        this.auxComment.writeSpecialsBefore(node);
    }

    protected boolean fixNewStatementCondition() throws IOException {
        if (this.state.lastIsWrite()) {
            this.state.writeNewLine();
            this.state.writeIndent();
            return true;
        }
        if (this.state.lastIsNewLine()) {
            this.state.writeIndent();
            return true;
        }
        return false;
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse(this);
    }

    public static void addMethod(String methodRep, String parentRep) {
        superMethods.put(methodRep, REF.findMethod((Class)ClassLiteral.getClass((String)"org/python/pydev/parser/prettyprinter/PrettyPrinterUtils"), (String)parentRep, (Object[])new Object[]{ClassLiteral.getClass((String)"org/python/pydev/parser/jython/SimpleNode")}));
    }

    protected void printCallArguments(Call node, exprType[] args, keywordType[] keywords, exprType starargs, exprType kwargs) throws Exception, IOException {
        this.state.indent();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    this.state.pushInStmt(args[i]);
                    args[i].accept(this);
                    this.state.popInStmt();
                }
                ++i;
            }
        }
        this.printArguments(node, keywords, starargs, kwargs);
        this.dedent();
    }

    protected void printArguments(SimpleNode node, keywordType[] keywords, exprType starargs, exprType kwargs) throws IOException, Exception {
        this.state.pushInStmt(node);
        ArrayList<SimpleNode> lst = new ArrayList<SimpleNode>();
        if (keywords != null) {
            int i = 0;
            while (i < keywords.length) {
                keywordType keyword = keywords[i];
                lst.add(keyword);
                ++i;
            }
        }
        if (starargs != null) {
            lst.add(starargs);
        }
        if (kwargs != null) {
            lst.add(kwargs);
        }
        Collections.sort(lst, new Comparator<SimpleNode>(){

            @Override
            public int compare(SimpleNode o1, SimpleNode o2) {
                if (o1.beginLine < o2.beginLine) {
                    return -1;
                }
                if (o1.beginLine > o2.beginLine) {
                    return 1;
                }
                if (o1.beginColumn < o2.beginColumn) {
                    return -1;
                }
                if (o1.beginColumn > o2.beginColumn) {
                    return 1;
                }
                return 0;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((SimpleNode)object, (SimpleNode)object2);
            }
        });
        Iterator iterator = lst.iterator();
        while (iterator.hasNext()) {
            SimpleNode n = (SimpleNode)iterator.next();
            if (n instanceof keywordType) {
                this.printKeyword((keywordType)n);
                continue;
            }
            n.accept(this);
        }
        this.state.popInStmt();
    }

    private void printKeyword(keywordType keyword) throws IOException, Exception {
        if (keyword != null) {
            this.auxComment.writeSpecialsBefore(keyword);
            this.state.indent();
            keyword.accept(this);
            this.auxComment.writeSpecialsAfter(keyword);
            this.dedent();
        }
    }

    public Object visitGeneric(SimpleNode node, String superMethod) throws IOException {
        return this.visitGeneric(node, superMethod, true);
    }

    public Object visitGeneric(SimpleNode node, String superMethod, boolean requiresNewLine) throws IOException {
        return this.visitGeneric(node, superMethod, requiresNewLine, null);
    }

    public Object visitGeneric(SimpleNode node, String superMethod, boolean requiresNewLine, String strToWrite) throws IOException {
        return this.visitGeneric(node, superMethod, requiresNewLine, strToWrite, false);
    }

    public Object visitGeneric(SimpleNode node, String superMethod, boolean requiresNewLine, String strToWrite, boolean needIndent) throws IOException {
        return this.visitGeneric(node, superMethod, requiresNewLine, strToWrite, needIndent, true);
    }

    public Object visitGeneric(SimpleNode node, String superMethod, boolean requiresNewLine, String strToWrite, boolean needIndent, boolean isNewScope) throws IOException {
        if (needIndent) {
            this.state.indent();
        }
        this.genericBefore(node, requiresNewLine);
        if (strToWrite != null) {
            this.state.write(strToWrite);
        } else {
            REF.invoke((Object)this, (Method)superMethods.get(superMethod), (Object[])new Object[]{node});
        }
        this.genericAfter(node, needIndent, isNewScope);
        if (needIndent) {
            this.dedent();
        }
        return null;
    }

    protected void genericAfter(SimpleNode node, boolean needIndent, boolean isNewScope) throws IOException {
        this.state.popInStmt();
        this.afterNode(node, isNewScope);
    }

    protected void genericBefore(SimpleNode node, boolean requiresNewLine) throws IOException {
        if (requiresNewLine) {
            this.fixNewStatementCondition();
        }
        this.beforeNode(node);
        this.state.pushInStmt(node);
    }

    public Object superGlobal(Global node) throws Exception {
        return super.visitGlobal(node);
    }

    public Object superYield(Yield node) throws Exception {
        return super.visitYield(node);
    }

    public Object superPass(Pass node) throws Exception {
        return super.visitPass(node);
    }

    public Object superImport(Import node) throws Exception {
        return super.visitImport(node);
    }

    public Object superPrint(Print node) throws Exception {
        return super.visitPrint(node);
    }

    public Object superSubscript(Subscript node) throws Exception {
        return super.visitSubscript(node);
    }

    public Object superList(List node) throws Exception {
        return super.visitList(node);
    }

    public Object superBreak(Break node) throws Exception {
        return super.visitBreak(node);
    }

    public Object superContinue(Continue node) throws Exception {
        return super.visitContinue(node);
    }

    public Object superBoolOp(BoolOp node) throws Exception {
        return super.visitBoolOp(node);
    }

    public Object superReturn(Return node) throws Exception {
        return super.visitReturn(node);
    }

    public Object superSlice(Slice node) throws Exception {
        return super.visitSlice(node);
    }

    public Object superIndex(Index node) throws Exception {
        return super.visitIndex(node);
    }

    public Object superDelete(Delete node) throws Exception {
        return super.visitDelete(node);
    }

    public Object superListComp(ListComp node) throws Exception {
        return super.visitListComp(node);
    }

    public Object superExec(Exec node) throws Exception {
        return super.visitExec(node);
    }

    public Object superTuple(Tuple node) throws Exception {
        return super.visitTuple(node);
    }

    public Object superLambda(Lambda node) throws Exception {
        return super.visitLambda(node);
    }

    public Object superComprehension(Comprehension node) throws Exception {
        return super.visitComprehension(node);
    }

    public Object superRaise(Raise node) throws Exception {
        return super.visitRaise(node);
    }

    public Object superStrJoin(StrJoin node) throws Exception {
        return super.visitStrJoin(node);
    }

    public Object superAssert(Assert node) throws Exception {
        return super.visitAssert(node);
    }

    public Object superWith(With node) throws Exception {
        return super.visitWith(node);
    }

    public Object superExpr(Expr node) throws Exception {
        return super.visitExpr(node);
    }
}

