/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.parser.grammarcommon.AbstractJJTPythonGrammarState;
import org.python.pydev.parser.grammarcommon.ComprehensionCollection;
import org.python.pydev.parser.grammarcommon.CtxVisitor;
import org.python.pydev.parser.grammarcommon.DefaultArg;
import org.python.pydev.parser.grammarcommon.ExtraArg;
import org.python.pydev.parser.grammarcommon.ExtraArgValue;
import org.python.pydev.parser.grammarcommon.ITreeBuilder;
import org.python.pydev.parser.grammarcommon.ITreeConstants;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Suite;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeBuilderHelpers
implements ITreeBuilder,
ITreeConstants {
    protected final AbstractJJTPythonGrammarState stack;
    protected final CtxVisitor ctx;
    protected SimpleNode lastPop;

    public AbstractTreeBuilderHelpers(AbstractJJTPythonGrammarState stack) {
        this.stack = stack;
        this.ctx = new CtxVisitor();
    }

    protected final stmtType[] makeStmts(int l) {
        stmtType[] stmts = new stmtType[l];
        int i = l - 1;
        while (i >= 0) {
            stmts[i] = (stmtType)this.stack.popNode();
            --i;
        }
        return stmts;
    }

    protected final stmtType[] popSuite() {
        return this.getBodyAndSpecials();
    }

    protected final exprType[] makeExprs() {
        if (this.stack.nodeArity() > 0 && this.stack.peekNode().getId() == 533) {
            this.stack.popNode();
        }
        return this.makeExprs(this.stack.nodeArity());
    }

    protected final exprType[] makeExprs(int l) {
        exprType[] exprs = new exprType[l];
        int i = l - 1;
        while (i >= 0) {
            this.lastPop = this.stack.popNode();
            exprs[i] = (exprType)this.lastPop;
            --i;
        }
        return exprs;
    }

    protected final NameTok makeName(int ctx) {
        Name name = (Name)this.stack.popNode();
        return this.makeName(ctx, name);
    }

    protected final NameTok makeName(int ctx, Name name) {
        NameTok n = new NameTok(name.id, ctx);
        n.beginColumn = name.beginColumn;
        n.beginLine = name.beginLine;
        this.addSpecials(name, n);
        name.specialsBefore = n.getSpecialsBefore();
        name.specialsAfter = n.getSpecialsAfter();
        return n;
    }

    protected final NameTok[] makeIdentifiers(int ctx) {
        int l = this.stack.nodeArity();
        return this.makeIdentifiers(ctx, l);
    }

    protected final NameTok[] makeIdentifiers(int ctx, int arity) {
        NameTok[] ids = new NameTok[arity];
        int i = arity - 1;
        while (i >= 0) {
            ids[i] = this.makeName(ctx);
            --i;
        }
        return ids;
    }

    protected final suiteType popSuiteAndSuiteType() {
        Suite s = (Suite)this.stack.popNode();
        suiteType orelseSuite = (suiteType)this.stack.popNode();
        orelseSuite.body = s.body;
        this.addSpecialsAndClearOriginal(s, orelseSuite);
        return orelseSuite;
    }

    protected final void addSpecialsAndClearOriginal(SimpleNode from, SimpleNode to) {
        this.addSpecials(from, to);
        if (from.specialsBefore != null) {
            from.specialsBefore.clear();
        }
        if (from.specialsAfter != null) {
            from.specialsAfter.clear();
        }
    }

    protected final void addSpecials(SimpleNode from, SimpleNode to) {
        if (from.specialsBefore != null && from.specialsBefore.size() > 0) {
            to.getSpecialsBefore().addAll(from.specialsBefore);
        }
        if (from.specialsAfter != null && from.specialsAfter.size() > 0) {
            to.getSpecialsAfter().addAll(from.specialsAfter);
        }
    }

    protected final void addSpecialsBefore(SimpleNode from, SimpleNode to) {
        if (from.specialsBefore != null && from.specialsBefore.size() > 0) {
            to.getSpecialsBefore().addAll(from.specialsBefore);
        }
        if (from.specialsAfter != null && from.specialsAfter.size() > 0) {
            to.getSpecialsBefore().addAll(from.specialsAfter);
        }
    }

    protected final void setParentForFuncOrClass(stmtType[] body, SimpleNode classDef) {
        stmtType[] stmtTypeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType b = stmtTypeArray[n2];
            if (b instanceof ClassDef || b instanceof FunctionDef) {
                b.parent = classDef;
            }
            ++n2;
        }
    }

    protected final stmtType[] getBodyAndSpecials() {
        Suite suite = (Suite)this.stack.popNode();
        stmtType[] body = suite.body;
        if (suite.specialsBefore != null && suite.specialsBefore.size() > 0) {
            body[0].getSpecialsBefore().addAll(suite.specialsBefore);
        }
        if (suite.specialsAfter != null && suite.specialsAfter.size() > 0) {
            body[body.length - 1].getSpecialsAfter().addAll(suite.specialsAfter);
        }
        return body;
    }

    protected final SimpleNode makeDecorator(List<SimpleNode> nodes) {
        exprType starargs = null;
        exprType kwargs = null;
        exprType func = null;
        ArrayList<SimpleNode> keywordsl = new ArrayList<SimpleNode>();
        ArrayList<SimpleNode> argsl = new ArrayList<SimpleNode>();
        Iterator<SimpleNode> iter = nodes.iterator();
        while (iter.hasNext()) {
            ExtraArgValue extraArg;
            SimpleNode node = iter.next();
            if (node.getId() == 553) {
                extraArg = (ExtraArgValue)node;
                kwargs = extraArg.value;
                this.addSpecialsAndClearOriginal(extraArg, kwargs);
                extraArg.specialsBefore = kwargs.getSpecialsBefore();
                extraArg.specialsAfter = kwargs.getSpecialsAfter();
                continue;
            }
            if (node.getId() == 551) {
                extraArg = (ExtraArgValue)node;
                starargs = extraArg.value;
                this.addSpecialsAndClearOriginal(extraArg, starargs);
                extraArg.specialsBefore = starargs.getSpecialsBefore();
                extraArg.specialsAfter = starargs.getSpecialsAfter();
                continue;
            }
            if (node instanceof keywordType) {
                keywordsl.add(node);
                continue;
            }
            if (this.isArg(node)) {
                argsl.add(node);
                continue;
            }
            if (node instanceof Comprehension) {
                argsl.add(new ListComp((exprType)iter.next(), new comprehensionType[]{(comprehensionType)node}));
                continue;
            }
            if (node instanceof ComprehensionCollection) {
                argsl.add(new ListComp((exprType)iter.next(), ((ComprehensionCollection)node).getGenerators()));
                continue;
            }
            if (node instanceof decoratorsType) {
                func = (exprType)this.stack.popNode();
                decoratorsType d = (decoratorsType)node;
                d.func = func;
                d.args = argsl.toArray(new exprType[0]);
                d.keywords = keywordsl.toArray(new keywordType[0]);
                d.starargs = starargs;
                d.kwargs = kwargs;
                return d;
            }
            argsl.add(node);
        }
        throw new RuntimeException("Something wrong happened while making the decorators...");
    }

    protected final aliasType[] makeAliases(int l) {
        aliasType[] aliases = new aliasType[l];
        int i = l - 1;
        while (i >= 0) {
            aliases[i] = (aliasType)this.stack.popNode();
            --i;
        }
        return aliases;
    }

    protected final boolean isArg(SimpleNode n) {
        return n instanceof ExtraArg || n instanceof DefaultArg || n instanceof keywordType;
    }
}

