/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.NotConfiguredInterpreterException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLaunchShortcut
implements ILaunchShortcut {
    boolean fShowDialog = false;

    protected abstract String getLaunchConfigurationType();

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                Object object = structuredSelection.getFirstElement();
                if (object instanceof IAdaptable) {
                    IFile resource = (IFile)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
                    if (resource != null) {
                        this.launch((IResource)resource, mode, null);
                        return;
                    }
                    IFolder folder = (IFolder)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFolder"));
                    if (folder != null) {
                        this.launch((IResource)folder, mode, null);
                        return;
                    }
                }
            } else if (structuredSelection.size() > 1) {
                ArrayList<Object> sel = new ArrayList<Object>();
                for (Object object : structuredSelection) {
                    if (!(object instanceof IAdaptable)) continue;
                    IFolder folder = (IFolder)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFolder"));
                    if (folder != null) {
                        sel.add(folder);
                        continue;
                    }
                    IFile file = (IFile)((IAdaptable)object).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
                    if (file == null) continue;
                    sel.add(file);
                }
                if (sel.size() > 0) {
                    this.launch(sel.toArray(new IResource[sel.size()]), mode, null);
                }
                return;
            }
            StringBuffer buf = new StringBuffer();
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
            }
            AbstractLaunchShortcut.reportError(new StringBuffer("Unable to discover launch config for: ").append((Object)buf).toString(), null);
            return;
        }
        PydevPlugin.log((String)new StringBuffer("Expecting instance of IStructuredSelection. Received: ").append(selection.getClass().getName()).toString());
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
        if (file != null) {
            this.launch((IResource)file, mode, null);
            return;
        }
        this.fileNotFound();
    }

    protected void fileNotFound() {
        String msg = "Unable to launch the file. Possible reasons may include:\n    - the file (editor) being launched is not under a project in the workspace;\n    - the file was deleted.";
        AbstractLaunchShortcut.reportError(msg, null);
    }

    protected boolean verifyMode(String mode) {
        boolean ok;
        boolean bl = ok = mode.equals("run") || mode.equals("debug");
        if (!ok) {
            AbstractLaunchShortcut.reportError(new StringBuffer("Unknown launch mode: ").append(mode).toString(), null);
        }
        return ok;
    }

    protected static void reportError(String message, Throwable throwable) {
        if (message == null) {
            message = "Unexpected error";
        }
        Object status = null;
        status = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.python.pydev.debug", 0, message, throwable);
        ErrorDialog.openError((Shell)PydevDebugPlugin.getActiveWorkbenchWindow().getShell(), (String)"Python pydev.debug error", (String)"Python launch failed", (IStatus)status);
    }

    protected List<ILaunchConfiguration> findExistingLaunchConfigurations(IResource[] file) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationType());
        ArrayList<ILaunchConfiguration> validConfigs = new ArrayList<ILaunchConfiguration>();
        if (type == null) {
            return validConfigs;
        }
        try {
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            String defaultLocation = AbstractLaunchShortcut.getDefaultLocation(file, true);
            String defaultLocation2 = AbstractLaunchShortcut.getDefaultLocation(file, false);
            int i = 0;
            while (i < configs.length) {
                String configPath = configs[i].getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
                if (defaultLocation.equals(configPath) || defaultLocation2.equals(configPath)) {
                    validConfigs.add(configs[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AbstractLaunchShortcut.reportError("Unexpected error", e);
        }
        return validConfigs;
    }

    public static String getDefaultLocation(IResource[] file, boolean makeRelative) {
        StringBuffer buffer = new StringBuffer();
        IResource[] iResourceArray = file;
        int n = file.length;
        int n2 = 0;
        while (n2 < n) {
            String loc;
            IResource r = iResourceArray[n2];
            if (buffer.length() > 0) {
                buffer.append("|");
            }
            if (makeRelative) {
                IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
                loc = AbstractLaunchShortcut.makeFileRelativeToWorkspace(file, varManager);
            } else {
                loc = r.getRawLocation().toString();
            }
            buffer.append(loc);
            ++n2;
        }
        return buffer.toString();
    }

    protected ILaunchConfiguration createDefaultLaunchConfiguration(IResource[] resource) {
        IInterpreterManager pythonInterpreterManager = this.getInterpreterManager();
        String projName = resource[0].getProject().getName();
        return AbstractLaunchShortcut.createDefaultLaunchConfiguration(resource, this.getLaunchConfigurationType(), AbstractLaunchShortcut.getDefaultLocation(resource, false), pythonInterpreterManager, projName);
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IResource[] resource, String launchConfigurationType, String location, IInterpreterManager pythonInterpreterManager, String projName) {
        return AbstractLaunchShortcut.createDefaultLaunchConfiguration(resource, launchConfigurationType, location, pythonInterpreterManager, projName, null);
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IResource[] resource, String launchConfigurationType, String location, IInterpreterManager pythonInterpreterManager, String projName, String vmargs) {
        return AbstractLaunchShortcut.createDefaultLaunchConfiguration(resource, launchConfigurationType, location, pythonInterpreterManager, projName, vmargs, "", true);
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IResource[] resource, String launchConfigurationType, String location, IInterpreterManager pythonInterpreterManager, String projName, String vmargs, String programArguments, boolean captureOutput) {
        int resourceType;
        String moduleFile;
        String baseDirectory;
        String name;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(launchConfigurationType);
        if (type == null) {
            AbstractLaunchShortcut.reportError("Python launch configuration not found", null);
            return null;
        }
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        if (captureOutput) {
            StringBuffer buffer = new StringBuffer(projName);
            buffer.append(" ");
            StringBuffer resourceNames = new StringBuffer();
            IResource[] iResourceArray = resource;
            int n = resource.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (resourceNames.length() > 0) {
                    resourceNames.append(" - ");
                }
                resourceNames.append(r.getName());
                ++n2;
            }
            buffer.append(resourceNames);
            name = buffer.toString().trim();
            baseDirectory = resource[0].getFullPath().removeLastSegments(1).makeRelative().toString();
            baseDirectory = varManager.generateVariableExpression("workspace_loc", baseDirectory);
            moduleFile = AbstractLaunchShortcut.makeFileRelativeToWorkspace(resource, varManager);
            resourceType = resource[0].getType();
        } else {
            captureOutput = true;
            name = location;
            baseDirectory = new File(location).getParent();
            moduleFile = location;
            resourceType = 1;
        }
        name = manager.generateUniqueLaunchConfigurationNameFrom(name);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_PROJECT", projName);
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_RESOURCE_TYPE", resourceType);
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_INTERPRETER", "__default");
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", moduleFile);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", baseDirectory);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", programArguments);
            workingCopy.setAttribute("org.python.pydev.debug.vm.arguments", vmargs);
            workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", captureOutput);
            workingCopy.setAttribute("org.eclipse.debug.core.capture_output", captureOutput);
            workingCopy.setMappedResources(resource);
            CommonTab tab = new CommonTab();
            tab.setDefaults(workingCopy);
            tab.dispose();
            return workingCopy.doSave();
        }
        catch (NotConfiguredInterpreterException e) {
            AbstractLaunchShortcut.reportError(e.getMessage(), e);
            throw e;
        }
        catch (CoreException e) {
            AbstractLaunchShortcut.reportError(null, e);
            return null;
        }
    }

    private static String makeFileRelativeToWorkspace(IResource[] resource, IStringVariableManager varManager) {
        FastStringBuffer moduleFile = new FastStringBuffer(80 * resource.length);
        IResource[] iResourceArray = resource;
        int n = resource.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            String m = r.getFullPath().makeRelative().toString();
            m = varManager.generateVariableExpression("workspace_loc", m);
            if (moduleFile.length() > 0) {
                moduleFile.append("|");
            }
            moduleFile.append(m);
            ++n2;
        }
        return moduleFile.toString();
    }

    protected IInterpreterManager getInterpreterManager() {
        return PydevPlugin.getPythonInterpreterManager();
    }

    protected ILaunchConfiguration chooseConfig(List<ILaunchConfiguration> configs) {
        if (configs.isEmpty()) {
            return null;
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs.toArray(new ILaunchConfiguration[configs.size()]));
        dialog.setTitle("Pick a Python configuration");
        dialog.setMessage("Choose a python configuration to run");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IResource file, String mode, String targetAttribute) {
        this.launch(new IResource[]{file}, mode, targetAttribute);
    }

    protected void launch(IResource[] file, String mode, String targetAttribute) {
        if (!this.verifyMode(mode)) {
            AbstractLaunchShortcut.reportError(new StringBuffer("Invalid mode ").append(mode).toString(), null);
            return;
        }
        ILaunchConfiguration conf = null;
        List<ILaunchConfiguration> configurations = this.findExistingLaunchConfigurations(file);
        if (configurations.isEmpty()) {
            conf = this.createDefaultLaunchConfiguration(file);
        } else if (configurations.size() == 1) {
            conf = configurations.get(0);
        } else {
            conf = this.chooseConfig(configurations);
            if (conf == null) {
                return;
            }
        }
        if (conf != null) {
            if (this.fShowDialog) {
                String groupID = "";
                if (mode.equals("run")) {
                    groupID = "org.python.pydev.debug.run";
                } else if (mode.equals("debug")) {
                    groupID = "org.python.pydev.debug.debug";
                }
                DebugUITools.openLaunchConfigurationDialog((Shell)PydevDebugPlugin.getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)conf, (String)groupID, null);
            } else {
                DebugUITools.launch((ILaunchConfiguration)conf, (String)mode);
            }
            return;
        }
        this.fileNotFound();
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }
}

