/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.stmtType;

public class ImportFrom
extends stmtType {
    public NameTokType module;
    public aliasType[] names;
    public int level;

    public ImportFrom(NameTokType module, aliasType[] names, int level) {
        this.module = module;
        this.names = names;
        this.level = level;
    }

    public ImportFrom(NameTokType module, aliasType[] names, int level, SimpleNode parent) {
        this(module, names, level);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ImportFrom[");
        sb.append("module=");
        sb.append(this.dumpThis(this.module));
        sb.append(", ");
        sb.append("names=");
        sb.append(this.dumpThis(this.names));
        sb.append(", ");
        sb.append("level=");
        sb.append(this.dumpThis(this.level));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(23, ostream);
        this.pickleThis(this.module, ostream);
        this.pickleThis(this.names, ostream);
        this.pickleThis(this.level, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitImportFrom(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.module != null) {
            this.module.accept(visitor);
        }
        if (this.names != null) {
            int i = 0;
            while (i < this.names.length) {
                if (this.names[i] != null) {
                    this.names[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

