/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractmethod.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.renamer.LocalVarRenameVisitor;
import org.python.pydev.refactoring.coderefactoring.extractmethod.request.ExtractMethodRequest;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractMethodEdit
extends AbstractInsertEdit {
    private String methodName;
    private ModuleAdapter parsedSelection;
    private int offsetStrategy;
    private AbstractScopeNode<?> scopeAdapter;
    private List<String> parameters;
    private List<String> returnVariables;
    private Map<String, String> renamedVariables;

    public ExtractMethodEdit(ExtractMethodRequest req) {
        super(req);
        this.methodName = req.getMethodName();
        this.scopeAdapter = req.getScopeAdapter();
        this.parsedSelection = req.getParsedSelection();
        this.offsetStrategy = req.getOffsetStrategy();
        this.parameters = req.getParameters();
        this.returnVariables = req.getReturnVariables();
        this.renamedVariables = req.getRenamedVariables();
    }

    @Override
    protected SimpleNode getEditNode() {
        List<stmtType> body = this.initExtractedBody();
        List<exprType> argsList = this.initExtractedMethodArguments();
        this.addReturnValue(body);
        FunctionDef extractedMethod = this.initExtractedMethod(body, argsList);
        this.applyRenamedVariables(extractedMethod);
        return extractedMethod;
    }

    private FunctionDef initExtractedMethod(List<stmtType> body, List<exprType> argsList) {
        argumentsType args = new argumentsType(argsList.toArray(new exprType[0]), null, null, null);
        FunctionDef extractedMethod = new FunctionDef((NameTokType)new NameTok(this.methodName, 2), args, body.toArray(new stmtType[0]), null);
        return extractedMethod;
    }

    private List<exprType> initExtractedMethodArguments() {
        ArrayList<exprType> argsList = new ArrayList<exprType>();
        if (this.scopeAdapter instanceof FunctionDefAdapter) {
            AbstractNodeAdapter parentScopeAdapter = this.scopeAdapter.getParent();
            while (parentScopeAdapter instanceof FunctionDef) {
                parentScopeAdapter = this.scopeAdapter.getParent();
            }
            if (parentScopeAdapter instanceof IClassDefAdapter) {
                argsList.add((exprType)new Name("self", 1));
            }
        }
        for (String variable : this.parameters) {
            argsList.add((exprType)new Name(variable, 6));
        }
        return argsList;
    }

    private List<stmtType> initExtractedBody() {
        stmtType[] extractBody = ((Module)this.parsedSelection.getASTNode()).body;
        ArrayList<stmtType> body = new ArrayList<stmtType>();
        stmtType[] stmtTypeArray = extractBody;
        int n = extractBody.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType stmt = stmtTypeArray[n2];
            body.add(stmt);
            ++n2;
        }
        return body;
    }

    private void applyRenamedVariables(FunctionDef extractedMethod) {
        if (this.renamedVariables.size() > 0) {
            LocalVarRenameVisitor renameVisitor = new LocalVarRenameVisitor(this.newLineDelim);
            renameVisitor.setRenameMap(this.renamedVariables);
            try {
                extractedMethod.accept((VisitorIF)renameVisitor);
            }
            catch (Exception exception) {}
        }
    }

    private void addReturnValue(List<stmtType> body) {
        ArrayList<Name> returnList = new ArrayList<Name>();
        for (String variable : this.returnVariables) {
            returnList.add(new Name(variable, 1));
        }
        exprType returnValue = null;
        if (returnList.size() == 1) {
            returnValue = (exprType)returnList.get(0);
        } else if (returnList.size() > 1) {
            returnValue = new Tuple(returnList.toArray(new exprType[0]), 1);
        } else if (body.size() == 1 && body.get(0) instanceof Expr) {
            Expr expression = (Expr)body.get(0);
            returnValue = expression.value;
            body.clear();
        }
        if (returnValue != null) {
            body.add((stmtType)new Return(returnValue));
        }
    }

    @Override
    public int getOffsetStrategy() {
        return this.offsetStrategy;
    }
}

