/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.REF;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private static final Object lock = new Object();
    private static final StringBuffer logIndent = new StringBuffer();

    public static void log(int errorLevel, String message, Throwable e) {
        System.err.println(message);
        if (e != null) {
            e.printStackTrace();
        }
        try {
            Status s = new Status(errorLevel, CorePlugin.getPluginID(), errorLevel, message, e);
            CorePlugin.getDefault().getLog().log((IStatus)s);
        }
        catch (Exception exception) {}
    }

    public static void log(Throwable e) {
        Log.log(4, e.getMessage() != null ? e.getMessage() : "No message gotten.", e);
    }

    public static void log(String msg) {
        Log.log(4, msg, new RuntimeException(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void toLogFile(Object obj, String string) {
        Object object = lock;
        synchronized (object) {
            Class<?> class1 = obj.getClass();
            Log.toLogFile(string, class1);
        }
    }

    public static void toLogFile(String string, Class<? extends Object> class1) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(logIndent);
        buffer.append(FullRepIterable.getLastPart(class1.getName()));
        buffer.append(": ");
        buffer.append(string);
        Log.toLogFile(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void toLogFile(String buffer) {
        Object object = lock;
        synchronized (object) {
            try {
                CorePlugin default1 = CorePlugin.getDefault();
                if (default1 == null) {
                    System.out.println(buffer);
                    return;
                }
                IPath stateLocation = default1.getStateLocation().append("PydevLog.log");
                String file = stateLocation.toOSString();
                REF.appendStrToFile(new StringBuffer(String.valueOf(buffer)).append("\r\n").toString(), file);
            }
            catch (Throwable e) {
                Log.log(e);
            }
        }
    }

    public static void toLogFile(Exception e) {
        String msg = Log.getExceptionStr(e);
        Log.toLogFile(msg);
    }

    public static String getExceptionStr(Exception e) {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        PrintStream prnt = new PrintStream(str);
        e.printStackTrace(prnt);
        prnt.flush();
        String msg = new String(str.toByteArray());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addLogLevel() {
        Object object = lock;
        synchronized (object) {
            logIndent.append("    ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void remLogLevel() {
        Object object = lock;
        synchronized (object) {
            if (logIndent.length() > 3) {
                logIndent.delete(0, 4);
            }
        }
    }
}

