/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.docutils.DocUtils;
import org.python.pydev.core.docutils.PyDocIterator;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.WordUtils;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsingUtils
implements IPythonPartitions {
    public static int eatToColon(char[] cs, FastStringBuffer buf, int i) {
        while (i < cs.length && cs[i] != ':') {
            buf.append(cs[i]);
            ++i;
        }
        if (i < cs.length) {
            buf.append(cs[i]);
        }
        return i;
    }

    public static int eatComments(Object cs, FastStringBuffer buf, int i) {
        while (i < ParsingUtils.len(cs) && ParsingUtils.charAt(cs, i) != '\n' && ParsingUtils.charAt(cs, i) != '\r') {
            if (buf != null) {
                buf.append(ParsingUtils.charAt(cs, i));
            }
            ++i;
        }
        if (i < ParsingUtils.len(cs) && buf != null) {
            buf.append(ParsingUtils.charAt(cs, i));
        }
        return i;
    }

    public static int eatComments(char[] cs, int i) {
        while (i < cs.length && cs[i] != '\n' && cs[i] != '\r') {
            ++i;
        }
        return i;
    }

    public static int eatToken(char[] cs, FastStringBuffer buf, int i) {
        while (i < cs.length && !Character.isWhitespace(cs[i])) {
            buf.append(cs[i]);
            ++i;
        }
        if (i < cs.length) {
            buf.append(cs[i]);
        }
        return i;
    }

    public static int eatLiterals(Object cs, FastStringBuffer buf, int i) {
        char curr = ParsingUtils.charAt(cs, i);
        if (curr != '\"' && curr != '\'') {
            throw new RuntimeException("Wrong location to eat literals. Expecting ' or \" ");
        }
        int j = ParsingUtils.getLiteralEnd(cs, i, curr);
        if (buf != null) {
            int k = i;
            while (k < ParsingUtils.len(cs) && k <= j) {
                buf.append(ParsingUtils.charAt(cs, k));
                ++k;
            }
        }
        return j;
    }

    public static int getLiteralEnd(Object cs, int i, char curr) {
        boolean multi = ParsingUtils.isMultiLiteral(cs, i, curr);
        int j = multi ? ParsingUtils.findNextMulti(cs, i + 3, curr) : ParsingUtils.findNextSingle(cs, i + 1, curr);
        return j;
    }

    public static int eatPar(Object cs, int i, FastStringBuffer buf) {
        return ParsingUtils.eatPar(cs, i, buf, '(');
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static int eatPar(Object cs, int i, FastStringBuffer buf, char par) {
        char c;
        char c2 = ' ';
        char closingPar = DocUtils.getPeer(par);
        int j = i + 1;
        if (true) {
            return j;
        }
        do {
            ++j;
            if (c2 == '\'' || c2 == '\"') {
                j = ParsingUtils.eatLiterals(cs, null, j - 1) + 1;
            } else if (c2 == '#') {
                j = ParsingUtils.eatComments(cs, null, j - 1) + 1;
            } else if (c2 == par) {
                j = ParsingUtils.eatPar(cs, j - 1, null, par) + 1;
            } else if (buf != null) {
                buf.append(c2);
            }
            if (j >= ParsingUtils.len(cs)) return j;
            c = ParsingUtils.charAt(cs, j);
            c2 = c;
        } while (c != closingPar);
        return j;
    }

    public static int findNextSingle(Object cs, int i, char curr) {
        boolean ignoreNext = false;
        while (i < ParsingUtils.len(cs)) {
            char c = ParsingUtils.charAt(cs, i);
            if (!ignoreNext && c == curr) break;
            if (!ignoreNext) {
                if (c == '\\') {
                    ignoreNext = true;
                }
            } else {
                ignoreNext = false;
            }
            ++i;
        }
        return i;
    }

    public static int findNextMulti(Object cs, int i, char curr) {
        while (i + 2 < ParsingUtils.len(cs)) {
            char c = ParsingUtils.charAt(cs, i);
            if (c == curr && ParsingUtils.charAt(cs, i + 1) == curr && ParsingUtils.charAt(cs, i + 2) == curr) break;
            ++i;
            if (c != '\\') continue;
            ++i;
        }
        if (ParsingUtils.len(cs) < i + 2) {
            return ParsingUtils.len(cs);
        }
        return i + 2;
    }

    public static char charAt(Object o, int i) {
        if (o instanceof char[]) {
            return ((char[])o)[i];
        }
        if (o instanceof FastStringBuffer) {
            return ((FastStringBuffer)o).charAt(i);
        }
        if (o instanceof StringBuffer) {
            return ((StringBuffer)o).charAt(i);
        }
        if (o instanceof String) {
            return ((String)o).charAt(i);
        }
        if (o instanceof IDocument) {
            try {
                return ((IDocument)o).getChar(i);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(new StringBuffer("unable to get char at of ").append(o.getClass()).toString());
    }

    public static int len(Object o) {
        if (o instanceof char[]) {
            return ((char[])o).length;
        }
        if (o instanceof FastStringBuffer) {
            return ((FastStringBuffer)o).length();
        }
        if (o instanceof StringBuffer) {
            return ((StringBuffer)o).length();
        }
        if (o instanceof String) {
            return ((String)o).length();
        }
        if (o instanceof IDocument) {
            return ((IDocument)o).getLength();
        }
        throw new RuntimeException(new StringBuffer("unable to get len of ").append(o.getClass()).toString());
    }

    public static boolean isMultiLiteral(Object cs, int i, char curr) {
        if (ParsingUtils.len(cs) <= i + 2) {
            return false;
        }
        return ParsingUtils.charAt(cs, i + 1) == curr && ParsingUtils.charAt(cs, i + 2) == curr;
    }

    public static int eatWhitespaces(char[] cs, int i) {
        while (i < cs.length && Character.isWhitespace(cs[i])) {
            ++i;
        }
        return i;
    }

    public static int eatWhitespaces(FastStringBuffer buf, int i) {
        while (i < buf.length() && Character.isWhitespace(buf.charAt(i))) {
            ++i;
        }
        return i;
    }

    public static void removeCommentsWhitespacesAndLiterals(FastStringBuffer buf) {
        ParsingUtils.removeCommentsWhitespacesAndLiterals(buf, true);
    }

    public static void removeCommentsWhitespacesAndLiterals(FastStringBuffer buf, boolean whitespacesToo) {
        int i = 0;
        while (i < buf.length()) {
            int j;
            char ch = buf.charAt(i);
            if (ch == '#') {
                j = i;
                while (j < buf.length() && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(j);
                    ++j;
                }
                buf.delete(i, j);
            }
            if (ch == '\'' || ch == '\"') {
                j = ParsingUtils.getLiteralEnd(buf, i, ch);
                if (whitespacesToo) {
                    buf.delete(i, j + 1);
                } else {
                    int k = 0;
                    while (i + k < j + 1) {
                        buf.replace(i + k, i + k + 1, " ");
                        ++k;
                    }
                }
            }
            ++i;
        }
        if (whitespacesToo) {
            int length = buf.length();
            int i2 = length - 1;
            while (i2 >= 0) {
                char ch = buf.charAt(i2);
                if (Character.isWhitespace(ch)) {
                    buf.deleteCharAt(i2);
                }
                --i2;
            }
        }
    }

    public static void removeLiterals(FastStringBuffer buf) {
        int i = 0;
        while (i < buf.length()) {
            char ch = buf.charAt(i);
            if (ch == '#') {
                while (i < buf.length() && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(i);
                    ++i;
                }
            }
            if (ch == '\'' || ch == '\"') {
                int j = ParsingUtils.getLiteralEnd(buf, i, ch);
                int k = 0;
                while (i + k < j + 1) {
                    buf.replace(i + k, i + k + 1, " ");
                    ++k;
                }
            }
            ++i;
        }
    }

    public static Iterator<String> getNoLiteralsOrCommentsIterator(IDocument doc) {
        return new PyDocIterator(doc);
    }

    public static void removeCommentsAndWhitespaces(FastStringBuffer buf) {
        int i = 0;
        while (i < buf.length()) {
            char ch = buf.charAt(i);
            if (ch == '#') {
                int j = i;
                while (j < buf.length() - 1 && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(++j);
                }
                buf.delete(i, j);
            }
            ++i;
        }
        int length = buf.length();
        int i2 = length - 1;
        while (i2 >= 0) {
            char ch = buf.charAt(i2);
            if (Character.isWhitespace(ch)) {
                buf.deleteCharAt(i2);
            }
            --i2;
        }
    }

    public static void removeToClosingPar(FastStringBuffer buf) {
        int length = buf.length();
        int i = length - 1;
        while (i >= 0) {
            char ch = buf.charAt(i);
            if (ch == ')') {
                buf.deleteCharAt(i);
                return;
            }
            buf.deleteCharAt(i);
            --i;
        }
    }

    public static String getContentType(String initial, int currPos) {
        FastStringBuffer buf = new FastStringBuffer(initial, 0);
        String curr = "__dftl_partition_content_type";
        int i = 0;
        while (i < buf.length() && i < currPos) {
            char ch = buf.charAt(i);
            curr = "__dftl_partition_content_type";
            if (ch == '#') {
                curr = "__python_comment";
                int j = i;
                while (j < buf.length() - 1 && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(++j);
                }
                i = j;
            }
            if (i >= currPos) {
                return curr;
            }
            if (ch == '\'' || ch == '\"') {
                curr = "__python_singleline_string1";
                if (ch == '\"') {
                    curr = "__python_singleline_string2";
                }
                i = ParsingUtils.getLiteralEnd(buf, i, ch);
            }
            ++i;
        }
        return curr;
    }

    public static String getContentType(IDocument document, int i) {
        IDocumentExtension3 docExtension = (IDocumentExtension3)document;
        IDocumentPartitionerExtension2 partitioner = (IDocumentPartitionerExtension2)docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
        if (partitioner != null) {
            return partitioner.getContentType(i, true);
        }
        return ParsingUtils.getContentType(document.get(), i);
    }

    public static String makePythonParseable(String code, String delimiter) {
        return ParsingUtils.makePythonParseable(code, delimiter, new FastStringBuffer());
    }

    public static String makePythonParseable(String code, String delimiter, FastStringBuffer lastLine) {
        FastStringBuffer buffer = new FastStringBuffer();
        FastStringBuffer currLine = new FastStringBuffer();
        boolean foundNewLine = false;
        boolean lastWasNewLine = false;
        if (lastLine.length() > 0) {
            lastWasNewLine = true;
        }
        int i = 0;
        while (i < code.length()) {
            boolean foundNewLineAtChar = false;
            char c = code.charAt(i);
            if (c == '\r') {
                if (i + 1 < code.length() && code.charAt(i + 1) == '\n') {
                    ++i;
                }
                foundNewLineAtChar = true;
            } else if (c == '\n') {
                foundNewLineAtChar = true;
            }
            if (!foundNewLineAtChar) {
                if (lastWasNewLine && !Character.isWhitespace(c) && lastLine.length() > 0 && Character.isWhitespace(lastLine.charAt(0))) {
                    buffer.append(delimiter);
                }
                currLine.append(c);
                lastWasNewLine = false;
            } else {
                lastWasNewLine = true;
            }
            if (foundNewLineAtChar || i == code.length() - 1) {
                if (!PySelection.containsOnlyWhitespaces(currLine.toString())) {
                    buffer.append(currLine);
                    lastLine = currLine;
                    currLine = new FastStringBuffer();
                    buffer.append(delimiter);
                    foundNewLine = true;
                } else {
                    currLine = new FastStringBuffer();
                }
            }
            ++i;
        }
        if (!foundNewLine) {
            buffer.append(delimiter);
        } else {
            if (!WordUtils.endsWith(buffer, '\r') && !WordUtils.endsWith(buffer, '\n')) {
                buffer.append(delimiter);
            }
            if (lastLine.length() > 0 && Character.isWhitespace(lastLine.charAt(0)) && (code.indexOf(13) != -1 || code.indexOf(10) != -1)) {
                buffer.append(delimiter);
            }
        }
        return buffer.toString();
    }

    public static String getLastLine(String code) {
        int i = code.lastIndexOf(13);
        int j = code.lastIndexOf(10);
        if (i == -1 && j == -1) {
            return code;
        }
        char toSplit = '\n';
        if (i > j) {
            toSplit = '\r';
        }
        String[] strings = StringUtils.split(code, toSplit);
        return strings[strings.length - 1];
    }

    public static String removeComments(String line) {
        int i = line.indexOf(35);
        if (i != -1) {
            return line.substring(0, i);
        }
        return line;
    }
}

