/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.util.Iterator;
import org.python.pydev.core.docutils.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullRepIterable
implements Iterable<String> {
    private String fullRep;
    private boolean reverse;
    public static final int HEAD = 1;
    public static final int TAIL = 0;

    public FullRepIterable(String fullRep) {
        this(fullRep, false);
    }

    public FullRepIterable(String fullRep, boolean reverse) {
        this.fullRep = fullRep;
        this.reverse = reverse;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this.reverse) {
            return new FullRepIterator(this.fullRep);
        }
        return new ReverseFullRepIterator(this.fullRep);
    }

    public static String[] headAndTail(String fullRep) {
        return FullRepIterable.headAndTail(fullRep, true);
    }

    public static String[] headAndTail(String fullRep, boolean emptyTailIfNoDot) {
        int i = fullRep.lastIndexOf(46);
        if (i != -1) {
            return new String[]{fullRep.substring(0, i), fullRep.substring(i + 1)};
        }
        if (emptyTailIfNoDot) {
            return new String[]{"", fullRep};
        }
        return new String[]{fullRep, ""};
    }

    public static String getParentModule(String currentModuleName) {
        return FullRepIterable.headAndTail(currentModuleName, true)[0];
    }

    public static String getLastPart(String tokToCheck) {
        int i = tokToCheck.lastIndexOf(46);
        if (i == -1) {
            return tokToCheck;
        }
        return tokToCheck.substring(i + 1);
    }

    public static String getFirstPart(String tokToCheck) {
        int i = tokToCheck.indexOf(46);
        if (i == -1) {
            return tokToCheck;
        }
        return tokToCheck.substring(0, i);
    }

    public static String getFirstPart(String tokToCheck, char[] toks) {
        String ret = tokToCheck;
        char[] cArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String s;
            char c = cArray[n2];
            int i = tokToCheck.indexOf(c);
            if (i != -1 && (s = tokToCheck.substring(0, i)).length() < ret.length()) {
                ret = s;
            }
            ++n2;
        }
        return ret;
    }

    public static String getWithoutLastPart(String currentModuleName) {
        int i = currentModuleName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return currentModuleName.substring(0, i);
    }

    public static String joinParts(String[] actToks, int parts) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < parts) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append(actToks[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String joinFirstParts(String[] actToks) {
        return FullRepIterable.joinParts(actToks, actToks.length - 1);
    }

    public static boolean containsPart(String foundRep, String nameToFind) {
        String[] strings;
        String[] stringArray = strings = StringUtils.dotSplit(foundRep);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.equals(nameToFind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FullRepIterator
    implements Iterator<String> {
        private int i = -1;
        private boolean lastStep;
        private String fullRep;

        public FullRepIterator(String fullRep) {
            this.fullRep = fullRep;
            this.lastStep = false;
        }

        @Override
        public boolean hasNext() {
            boolean ret = !this.lastStep || this.fullRep.indexOf(46, this.i) != -1;
            return ret;
        }

        @Override
        public String next() {
            int j = this.fullRep.indexOf(46, this.i);
            if (j == -1) {
                this.lastStep = true;
                return this.fullRep;
            }
            this.i = j + 1;
            return this.fullRep.substring(0, j);
        }

        @Override
        public void remove() {
            throw new RuntimeException("not supported");
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseFullRepIterator
    implements Iterator<String> {
        private String fullRep;

        public ReverseFullRepIterator(String fullRep) {
            this.fullRep = fullRep;
        }

        @Override
        public boolean hasNext() {
            return this.fullRep.length() > 0;
        }

        @Override
        public String next() {
            if (this.fullRep.length() == 0) {
                throw new RuntimeException("no more items");
            }
            String ret = this.fullRep;
            int l = this.fullRep.lastIndexOf(46);
            this.fullRep = l == -1 ? "" : this.fullRep.substring(0, l);
            return ret;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not supported");
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }
}

