/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.JavaVmLocationFinder;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.debug.codecoverage.PyCoverage;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.InvalidRunException;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.PydevPrefs;
import org.python.pydev.plugin.SocketUtil;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonRunnerConfig {
    public static final String RUN_COVERAGE = "python code coverage run";
    public static final String RUN_REGULAR = "python regular run";
    public static final String RUN_UNITTEST = "pyton unittest run";
    public static final String RUN_JYTHON_UNITTEST = "jython unittest run";
    public static final String RUN_JYTHON = "jython regular run";
    public IProject project;
    public IPath resource;
    public IPath interpreter;
    public String interpreterLocation;
    private String arguments;
    public File workingDirectory;
    public String pythonpathUsed;
    public boolean isDebug;
    public boolean isInteractive;
    private int debugPort = 0;
    public int acceptTimeout = 5000;
    public String[] envp = null;
    private String run;
    private ILaunchConfiguration configuration;

    public boolean isCoverage() {
        return this.run.equals(RUN_COVERAGE);
    }

    public boolean isUnittest() {
        return this.run.equals(RUN_UNITTEST) || this.run.equals(RUN_JYTHON_UNITTEST);
    }

    public boolean isJython() {
        return this.run.equals(RUN_JYTHON) || this.run.equals(RUN_JYTHON_UNITTEST);
    }

    public boolean isFile() throws CoreException {
        int resourceType = this.configuration.getAttribute("org.python.pydev.debug.ATTR_RESOURCE_TYPE", -1);
        return resourceType == 1;
    }

    public static IPath getLocation(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        if (location == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get location for run", null));
        }
        String expandedLocation = PythonRunnerConfig.getStringVariableManager().performStringSubstitution(location);
        if (expandedLocation == null || expandedLocation.length() == 0) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get expanded location for run", null));
        }
        return new Path(expandedLocation);
    }

    public static String getArguments(ILaunchConfiguration configuration, boolean makeArgumentsVariableSubstitution) throws CoreException {
        String arguments = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "");
        if (makeArgumentsVariableSubstitution) {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        }
        return arguments;
    }

    public static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        String[] res = DebugPlugin.parseArguments((String)arguments);
        return res;
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String expandedLocation;
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = PythonRunnerConfig.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return new Path(expandedLocation);
            }
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, new StringBuffer("Unable to get working location for the run \n(the location: '").append(expandedLocation).append("' is not a valid directory).").toString(), null));
        }
        return null;
    }

    public static String getInterpreterLocation(ILaunchConfiguration conf, IPythonNature nature) throws InvalidRunException, CoreException {
        IInterpreterManager interpreterManager = PydevPlugin.getInterpreterManager((IPythonNature)nature);
        String location = conf.getAttribute("org.python.pydev.debug.ATTR_INTERPRETER", "__default");
        if (location != null && location.equals("__default")) {
            location = interpreterManager.getDefaultInterpreter();
        } else if (!interpreterManager.hasInfoOnInterpreter(location)) {
            File file = new File(location);
            if (!file.exists()) {
                throw new InvalidRunException(new StringBuffer("Error. The interprer: ").append(location).append(" does not exist").toString());
            }
            throw new InvalidRunException(new StringBuffer("Error. The interprer: ").append(location).append(" is not configured in the pydev preferences as a valid '").append(nature.getVersion()).append("' interpreter.").toString());
        }
        return location;
    }

    public static IPath getInterpreter(ILaunchConfiguration configuration, IPythonNature nature) throws CoreException, InvalidRunException {
        String location = PythonRunnerConfig.getInterpreterLocation(configuration, nature);
        if (location == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get python interpreter for run", null));
        }
        String expandedLocation = PythonRunnerConfig.getStringVariableManager().performStringSubstitution(location);
        if (expandedLocation == null || expandedLocation.length() == 0) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get expanded interpreter for run", null));
        }
        return new Path(expandedLocation);
    }

    public static IProject getProjectFromConfiguration(ILaunchConfiguration conf) throws CoreException {
        String projName = conf.getAttribute("org.python.pydev.debug.ATTR_PROJECT", "");
        if (projName == null || projName.length() == 0) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unable to get project for the run", null));
        }
        IWorkspace w = ResourcesPlugin.getWorkspace();
        IProject p = w.getRoot().getProject(projName);
        if (p == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, new StringBuffer("Could not get project: ").append(projName).toString(), null));
        }
        return p;
    }

    public static String getPythonpathFromConfiguration(ILaunchConfiguration conf) throws CoreException, InvalidRunException {
        IProject p = PythonRunnerConfig.getProjectFromConfiguration(conf);
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)p);
        if (pythonNature == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, new StringBuffer("Project should have a python nature: ").append(p.getName()).toString(), null));
        }
        String l = PythonRunnerConfig.getInterpreterLocation(conf, (IPythonNature)pythonNature);
        return SimpleRunner.makePythonPathEnvString((IPythonNature)pythonNature, (String)l);
    }

    public PythonRunnerConfig(ILaunchConfiguration conf, String mode, String run) throws CoreException, InvalidRunException {
        this(conf, mode, run, true);
    }

    public PythonRunnerConfig(ILaunchConfiguration conf, String mode, String run, boolean makeArgumentsVariableSubstitution) throws CoreException, InvalidRunException {
        this.project = PythonRunnerConfig.getProjectFromConfiguration(conf);
        if (this.project == null) {
            CoreException e = PydevPlugin.log((String)new StringBuffer("Could not get project for resource: ").append(this.resource).toString());
            throw e;
        }
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)this.project);
        if (pythonNature == null) {
            CoreException e = PydevPlugin.log((String)new StringBuffer("No python nature for project: ").append(this.project.getName()).toString());
            throw e;
        }
        if (pythonNature.isJython()) {
            if (!run.equals(RUN_JYTHON) && !run.equals(RUN_JYTHON_UNITTEST)) {
                throw new InvalidRunException(StringUtils.format((String)"Cannot make a '%s' for the project '%s' because the project is configured as %s\n\nTo fix this, configure '%s' as python or run it as jython", (Object[])new Object[]{run, this.project.getName(), pythonNature.getVersion(), this.project.getName()}));
            }
        } else if (pythonNature.isPython() && !run.equals(RUN_REGULAR) && !run.equals(RUN_COVERAGE) && !run.equals(RUN_UNITTEST)) {
            throw new InvalidRunException(StringUtils.format((String)"Cannot make a '%s' for the project '%s' because the project is configured as %s\n\nTo fix this, configure '%s' as jython or run it as python", (Object[])new Object[]{run, this.project.getName(), pythonNature.getVersion(), this.project.getName()}));
        }
        this.configuration = conf;
        this.run = run;
        this.isDebug = mode.equals("debug");
        this.isInteractive = mode.equals("interactive");
        this.resource = PythonRunnerConfig.getLocation(conf);
        this.arguments = PythonRunnerConfig.getArguments(conf, makeArgumentsVariableSubstitution);
        IPath workingPath = PythonRunnerConfig.getWorkingDirectory(conf);
        this.workingDirectory = workingPath == null ? null : workingPath.toFile();
        this.acceptTimeout = PydevPrefs.getPreferences().getInt("CONNECT_TIMEOUT");
        this.interpreterLocation = PythonRunnerConfig.getInterpreterLocation(conf, (IPythonNature)pythonNature);
        this.interpreter = PythonRunnerConfig.getInterpreter(conf, (IPythonNature)pythonNature);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.envp = launchManager.getEnvironment(conf);
        if (this.envp == null) {
            this.envp = new SimplePythonRunner().getEnvironment((IPythonNature)pythonNature, this.interpreterLocation);
            this.pythonpathUsed = SimpleRunner.makePythonPathEnvString((IPythonNature)pythonNature, (String)this.interpreterLocation);
        } else {
            boolean win32 = Platform.getOS().equals("win32");
            Map envMap = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            if (!this.specifiedPythonpath(envMap)) {
                String pythonpath;
                this.pythonpathUsed = pythonpath = SimpleRunner.makePythonPathEnvString((IPythonNature)pythonNature, (String)this.interpreterLocation);
                int i = 0;
                while (i < this.envp.length) {
                    if (win32) {
                        if (this.envp[i].toUpperCase().startsWith("PYTHONPATH")) {
                            this.envp[i] = new StringBuffer("PYTHONPATH=").append(pythonpath).toString();
                            return;
                        }
                    } else if (this.envp[i].startsWith("PYTHONPATH")) {
                        this.envp[i] = new StringBuffer("PYTHONPATH=").append(pythonpath).toString();
                        return;
                    }
                    ++i;
                }
                String[] s = new String[this.envp.length + 1];
                System.arraycopy(this.envp, 0, s, 0, this.envp.length);
                s[s.length - 1] = new StringBuffer("PYTHONPATH=").append(pythonpath).toString();
                this.envp = s;
            }
        }
    }

    private boolean specifiedPythonpath(Map<String, String> envMap) {
        if (envMap == null) {
            return false;
        }
        boolean win32 = Platform.getOS().equals("win32");
        for (String s : envMap.keySet()) {
            if (!(win32 ? s.toUpperCase().equals("PYTHONPATH") : s.equals("PYTHONPATH"))) continue;
            return true;
        }
        return false;
    }

    public int getDebugPort() throws CoreException {
        if (this.debugPort == 0) {
            this.debugPort = SocketUtil.findUnusedLocalPort();
            if (this.debugPort == -1) {
                throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Could not find a free socket for debugger", null));
            }
        }
        return this.debugPort;
    }

    public String getRunningName() {
        return this.resource.lastSegment();
    }

    public void verify() throws CoreException {
        if (this.resource == null || this.interpreter == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Invalid PythonRunnerConfig", null));
        }
        if (this.isDebug && (this.acceptTimeout < 0 || this.debugPort < 0)) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Invalid PythonRunnerConfig", null));
        }
    }

    public static String getCoverageScript() throws CoreException {
        return REF.getFileAbsolutePath((File)PydevDebugPlugin.getScriptWithinPySrc("coverage.py"));
    }

    public static String getUnitTestScript() throws CoreException {
        return REF.getFileAbsolutePath((File)PydevDebugPlugin.getScriptWithinPySrc("SocketTestRunner.py"));
    }

    public static String getDebugScript() throws CoreException {
        return REF.getFileAbsolutePath((File)PydevDebugPlugin.getScriptWithinPySrc("pydevd.py"));
    }

    private String getRunFilesScript() throws CoreException {
        return REF.getFileAbsolutePath((File)PydevDebugPlugin.getScriptWithinPySrc("runfiles.py"));
    }

    public String[] getCommandLine(boolean makeVariableSubstitution) throws CoreException, JDTNotAvailableException {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        if (this.isJython()) {
            String javaLoc = JavaVmLocationFinder.findDefaultJavaExecutable().getAbsolutePath();
            if (!InterpreterInfo.isJythonExecutable((String)this.interpreter.toOSString())) {
                throw new RuntimeException(new StringBuffer("The jython jar must be specified as the interpreter to run. Found: ").append(this.interpreter).toString());
            }
            cmdArgs.add(javaLoc);
            cmdArgs.add("-classpath");
            String cpath = new StringBuffer().append(this.interpreter).append(SimpleRunner.getPythonPathSeparator()).append(this.pythonpathUsed).toString();
            cmdArgs.add(cpath);
            cmdArgs.add(new StringBuffer("-Dpython.path=").append(this.pythonpathUsed).toString());
            this.addVmArgs(cmdArgs);
            if (this.isDebug) {
                cmdArgs.add("-Dpython.security.respectJavaAccessibility=false");
                cmdArgs.add("org.python.util.jython");
                cmdArgs.add(PythonRunnerConfig.getDebugScript());
                cmdArgs.add("--vm_type");
                cmdArgs.add("jython");
                cmdArgs.add("--client");
                cmdArgs.add("localhost");
                cmdArgs.add("--port");
                cmdArgs.add(Integer.toString(this.debugPort));
                cmdArgs.add("--file");
            } else {
                cmdArgs.add("org.python.util.jython");
            }
            if (this.isUnittest()) {
                cmdArgs.add(this.getRunFilesScript());
                cmdArgs.add("--verbosity");
                cmdArgs.add(PydevPrefs.getPreferences().getString("PYUNIT_VERBOSITY"));
                String filter = PydevPrefs.getPreferences().getString("PYUNIT_TEST_FILTER");
                if (filter.length() > 0) {
                    cmdArgs.add("--filter");
                    cmdArgs.add(filter);
                }
            }
        } else {
            cmdArgs.add(this.interpreter.toOSString());
            cmdArgs.add("-u");
            this.addVmArgs(cmdArgs);
            if (this.isDebug) {
                cmdArgs.add(PythonRunnerConfig.getDebugScript());
                cmdArgs.add("--vm_type");
                cmdArgs.add("python");
                cmdArgs.add("--client");
                cmdArgs.add("localhost");
                cmdArgs.add("--port");
                cmdArgs.add(Integer.toString(this.debugPort));
                cmdArgs.add("--file");
            }
            if (this.isCoverage()) {
                cmdArgs.add(PythonRunnerConfig.getCoverageScript());
                String coverageFileLocation = PyCoverage.getCoverageFileLocation();
                cmdArgs.add(coverageFileLocation);
                cmdArgs.add("-x");
                if (!this.isFile()) {
                    cmdArgs.add(this.getRunFilesScript());
                }
            }
            if (this.isUnittest()) {
                cmdArgs.add(this.getRunFilesScript());
                cmdArgs.add("--verbosity");
                cmdArgs.add(PydevPrefs.getPreferences().getString("PYUNIT_VERBOSITY"));
                String filter = PydevPrefs.getPreferences().getString("PYUNIT_TEST_FILTER");
                if (filter.length() > 0) {
                    cmdArgs.add("--filter");
                    cmdArgs.add(filter);
                }
            }
        }
        cmdArgs.add(this.resource.toOSString());
        String[] runArguments = null;
        if (makeVariableSubstitution && this.arguments != null) {
            String expanded = PythonRunnerConfig.getStringVariableManager().performStringSubstitution(this.arguments);
            runArguments = PythonRunnerConfig.parseStringIntoList(expanded);
        }
        int i = 0;
        while (runArguments != null && i < runArguments.length) {
            cmdArgs.add(runArguments[i]);
            ++i;
        }
        String[] retVal = new String[cmdArgs.size()];
        cmdArgs.toArray(retVal);
        return retVal;
    }

    private void addVmArgs(List<String> cmdArgs) throws CoreException {
        String[] vmArguments = this.getVMArguments(this.configuration);
        if (vmArguments != null) {
            int i = 0;
            while (i < vmArguments.length) {
                cmdArgs.add(vmArguments[i]);
                ++i;
            }
        }
    }

    private String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.python.pydev.debug.vm.arguments", null);
        if (args != null && args.trim().length() > 0) {
            String expanded = PythonRunnerConfig.getStringVariableManager().performStringSubstitution(args);
            return PythonRunnerConfig.parseStringIntoList(expanded);
        }
        return null;
    }

    public String getCommandLineAsString() throws JDTNotAvailableException {
        try {
            String[] args = this.getCommandLine(false);
            return SimpleRunner.getArgumentsAsStr((String[])args, (String[])new String[0]);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

