/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.blocks;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.python.pydev.plugin.PydevPlugin;

public class WorkingDirectoryBlock
extends AbstractLaunchConfigurationTab {
    private static final String DEFAULT_WORKING_DIRECTORY_TEXT = "${project_loc}";
    private Button fWorkspaceButton;
    private Button fFileSystemButton;
    private Button fVariablesButton;
    private Button fUseDefaultDirButton = null;
    private Button fUseOtherDirButton = null;
    private Text fOtherWorkingText = null;
    private Text fWorkingDirText;
    private ILaunchConfiguration fLaunchConfiguration;
    private WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = WorkingDirectoryBlock.createGroup(parent, "Working directory:", 2, 1, 768);
        this.setControl((Control)group);
        Composite comp = WorkingDirectoryBlock.createComposite((Composite)group, font, 2, 2, 1808, 0, 0);
        this.fUseDefaultDirButton = this.createRadioButton(comp, "Default:");
        this.fUseDefaultDirButton.addSelectionListener((SelectionListener)this.fListener);
        this.fWorkingDirText = WorkingDirectoryBlock.createSingleText(comp, 1);
        this.fWorkingDirText.addModifyListener((ModifyListener)this.fListener);
        this.fWorkingDirText.setEnabled(false);
        this.fUseOtherDirButton = this.createRadioButton(comp, "Other:");
        this.fUseOtherDirButton.addSelectionListener((SelectionListener)this.fListener);
        this.fOtherWorkingText = WorkingDirectoryBlock.createSingleText(comp, 1);
        this.fOtherWorkingText.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComp = WorkingDirectoryBlock.createComposite(comp, font, 3, 2, 128);
        GridLayout ld = (GridLayout)buttonComp.getLayout();
        ld.marginHeight = 1;
        ld.marginWidth = 0;
        this.fWorkspaceButton = this.createPushButton(buttonComp, "Workspace...", null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, "File System...", null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.fListener);
        this.fVariablesButton = this.createPushButton(buttonComp, "Variables...", null);
        this.fVariablesButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private void handleWorkingDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select a working directory for the launch configuration:");
        String currentWorkingDir = this.getWorkingDirectoryText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fOtherWorkingText.setText(selectedDirectory);
        }
    }

    private void handleWorkspaceDirBrowseButtonSelected() {
        IContainer currentContainer = this.getContainer();
        if (currentContainer == null) {
            currentContainer = ResourcesPlugin.getWorkspace().getRoot();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), currentContainer, false, "Select a workspace relative working directory");
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.setOtherWorkingDirectoryText("${workspace_loc:" + containerName + "}");
        }
    }

    protected IContainer getContainer() {
        String path = this.getWorkingDirectoryText();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IContainer[] containers = root.findContainersForLocation((IPath)new Path(path));
                    if (containers.length > 0) {
                        res = containers[0];
                    }
                }
                catch (CoreException coreException) {}
            } else {
                res = root.findMember(path);
            }
            if (res instanceof IContainer) {
                return (IContainer)res;
            }
        }
        return null;
    }

    private void handleUseDefaultWorkingDirButtonSelected() {
        this.fWorkspaceButton.setEnabled(false);
        this.fOtherWorkingText.setEnabled(false);
        this.fVariablesButton.setEnabled(false);
        this.fFileSystemButton.setEnabled(false);
        this.fUseOtherDirButton.setSelection(false);
    }

    private void handleUseOtherWorkingDirButtonSelected() {
        this.fOtherWorkingText.setEnabled(true);
        this.fWorkspaceButton.setEnabled(true);
        this.fVariablesButton.setEnabled(true);
        this.fFileSystemButton.setEnabled(true);
        this.updateLaunchConfigurationDialog();
    }

    private void handleWorkingDirVariablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variableText = dialog.getVariableExpression();
        if (variableText != null) {
            this.fOtherWorkingText.insert(variableText);
        }
    }

    protected void setDefaultWorkingDir() {
        ILaunchConfiguration config = this.getLaunchConfiguration();
        if (config != null) {
            this.setDefaultWorkingDirectoryText(DEFAULT_WORKING_DIRECTORY_TEXT);
            return;
        }
        this.setDefaultWorkingDirectoryText(System.getProperty("user.dir"));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String workingDirPath = this.getWorkingDirectoryText();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else if (workingDirPath.length() > 0) {
            IContainer container = this.getContainer();
            if (container == null) {
                File dir = new File(workingDirPath);
                if (dir.isDirectory()) {
                    return true;
                }
                this.setErrorMessage("Only directories can be selected");
                return false;
            }
        } else if (workingDirPath.length() == 0) {
            this.setErrorMessage("A non-empty directory must be selected");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
            String owd = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_OTHER_WORKING_DIRECTORY", null);
            this.setDefaultWorkingDir();
            if (wd != null && wd.equals(owd) || owd == null) {
                this.setOtherWorkingDirectoryText(wd);
            } else {
                this.fOtherWorkingText.setText(owd);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage("Exception occurred reading configuration" + e.getStatus().getMessage());
            PydevPlugin.log((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_OTHER_WORKING_DIRECTORY", this.fOtherWorkingText.getText().trim());
        if (this.fUseDefaultDirButton.getSelection()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", this.getWorkingDirectoryText());
        }
    }

    public String getName() {
        return "Working Directory";
    }

    protected String getWorkingDirectoryText() {
        if (this.fUseDefaultDirButton.getSelection()) {
            return this.fWorkingDirText.getText().trim();
        }
        return this.fOtherWorkingText.getText().trim();
    }

    protected void setDefaultWorkingDirectoryText(String dir) {
        if (dir != null) {
            this.fWorkingDirText.setText(dir);
            this.fUseDefaultDirButton.setSelection(true);
            this.handleUseDefaultWorkingDirButtonSelected();
        }
    }

    protected void setOtherWorkingDirectoryText(String dir) {
        if (dir != null) {
            this.fOtherWorkingText.setText(dir);
            this.fUseDefaultDirButton.setSelection(false);
            this.fUseOtherDirButton.setSelection(true);
            this.handleUseOtherWorkingDirButtonSelected();
        }
    }

    private void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    private ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    private static Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    private static Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    protected void setEnabled(boolean enabled) {
        this.fUseDefaultDirButton.setEnabled(enabled);
        this.fUseOtherDirButton.setEnabled(enabled);
        if (this.fOtherWorkingText.isEnabled()) {
            this.fOtherWorkingText.setEnabled(enabled);
            this.fWorkspaceButton.setEnabled(enabled);
            this.fVariablesButton.setEnabled(enabled);
            this.fFileSystemButton.setEnabled(enabled);
        }
        if (this.fUseOtherDirButton.getSelection() && enabled) {
            this.fOtherWorkingText.setEnabled(enabled);
        }
    }

    private class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.getSource() == WorkingDirectoryBlock.this.fOtherWorkingText) {
                File file = new File(WorkingDirectoryBlock.this.fOtherWorkingText.getText());
                if (!file.exists()) {
                    WorkingDirectoryBlock.this.setErrorMessage("The directory in the Base Directory does not exist.");
                }
                if (!file.isDirectory()) {
                    WorkingDirectoryBlock.this.setErrorMessage("The directory in the location is not actually a directory.");
                }
            }
            WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.fWorkspaceButton) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fFileSystemButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fVariablesButton) {
                WorkingDirectoryBlock.this.handleWorkingDirVariablesButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fUseDefaultDirButton) {
                if (WorkingDirectoryBlock.this.fUseDefaultDirButton.getSelection()) {
                    WorkingDirectoryBlock.this.setDefaultWorkingDir();
                }
            } else if (source == WorkingDirectoryBlock.this.fUseOtherDirButton && WorkingDirectoryBlock.this.fUseOtherDirButton.getSelection()) {
                WorkingDirectoryBlock.this.handleUseOtherWorkingDirButtonSelected();
            }
        }
    }
}

