/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.docutils.WordUtils;
import org.python.pydev.debug.ui.launching.InvalidRunException;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;

public class InterpreterTab
extends AbstractLaunchConfigurationTab {
    private Combo fInterpreterComboField;
    private Button fButtonSeeResultingCommandLine;
    private Text fCommandLineText;
    public static final String DEFAULT_INTERPRETER_NAME = "Default Interpreter";
    private IInterpreterManager fInterpreterManager;
    private ILaunchConfigurationWorkingCopy fWorkingCopyForCommandLineGeneration;
    private SelectionListener fSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == InterpreterTab.this.fButtonSeeResultingCommandLine) {
                try {
                    ILaunchConfigurationDialog launchConfigurationDialog = InterpreterTab.this.getLaunchConfigurationDialog();
                    ILaunchConfigurationTab[] iLaunchConfigurationTabArray = launchConfigurationDialog.getTabs();
                    int n = iLaunchConfigurationTabArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfigurationTab launchConfigurationTab = iLaunchConfigurationTabArray[n2];
                        launchConfigurationTab.performApply(InterpreterTab.this.fWorkingCopyForCommandLineGeneration);
                        ++n2;
                    }
                    PythonRunnerConfig config = InterpreterTab.this.getConfig((ILaunchConfiguration)InterpreterTab.this.fWorkingCopyForCommandLineGeneration, launchConfigurationDialog);
                    String commandLineAsString = config.getCommandLineAsString();
                    commandLineAsString = WordUtils.wrap((String)commandLineAsString, (int)80);
                    commandLineAsString = String.valueOf(commandLineAsString) + "\n\nThe PYTHONPATH that will be used is:\n\n";
                    commandLineAsString = String.valueOf(commandLineAsString) + config.pythonpathUsed;
                    InterpreterTab.this.fCommandLineText.setText(commandLineAsString);
                }
                catch (Exception e1) {
                    InterpreterTab.this.fCommandLineText.setText("Unable to make the command-line. \n\nReason:\n\n" + e1.getMessage());
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    private PythonRunnerConfig getConfig(ILaunchConfiguration configuration, ILaunchConfigurationDialog launchConfigurationDialog) throws CoreException, InvalidRunException {
        String run;
        if (this.fInterpreterManager.isJython()) {
            run = "jython regular run";
        } else if (this.fInterpreterManager.isPython()) {
            run = "python regular run";
        } else {
            throw new RuntimeException("Should be python or jython interpreter (found unknown).");
        }
        boolean makeArgumentsVariableSubstitution = false;
        PythonRunnerConfig config = new PythonRunnerConfig(configuration, launchConfigurationDialog.getMode(), run, makeArgumentsVariableSubstitution);
        return config;
    }

    public InterpreterTab(IInterpreterManager interpreterManager) {
        this.fInterpreterManager = interpreterManager;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout gridLayout = new GridLayout();
        comp.setLayout((Layout)gridLayout);
        GridData data = new GridData(768);
        Label label6 = new Label(comp, 0);
        label6.setText("Interpreter:");
        data = new GridData(768);
        data.horizontalSpan = 2;
        label6.setLayoutData((Object)data);
        this.fInterpreterComboField = new Combo(comp, 4);
        String[] interpreters = this.fInterpreterManager.getInterpreters();
        if (interpreters.length > 0) {
            String[] interpreterNames = interpreters;
            interpreters = new String[interpreterNames.length + 1];
            interpreters[0] = DEFAULT_INTERPRETER_NAME;
            int i = 0;
            while (i < interpreterNames.length) {
                interpreters[i + 1] = interpreterNames[i];
                ++i;
            }
        }
        this.fInterpreterComboField.setItems(interpreters);
        this.fInterpreterComboField.select(0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.fInterpreterComboField.setLayoutData((Object)data);
        this.fInterpreterComboField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterpreterTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fButtonSeeResultingCommandLine = new Button(comp, 0);
        this.fButtonSeeResultingCommandLine.setText("See resulting command-line for the given parameters");
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this.fButtonSeeResultingCommandLine.setLayoutData((Object)data);
        this.fButtonSeeResultingCommandLine.addSelectionListener(this.fSelectionListener);
        this.fCommandLineText = new Text(comp, 2816);
        this.fCommandLineText.setText("In case you are in doubt how will the run happen, click the button to \nsee the command-line that will be executed with the current parameters\n(and the PYTHONPATH / CLASSPATH used for the run).");
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 1;
        data.verticalSpan = 5;
        this.fCommandLineText.setLayoutData((Object)data);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String interpreter;
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            interpreter = launchConfig.getAttribute("org.python.pydev.debug.ATTR_INTERPRETER", "__default");
        }
        catch (CoreException e) {
            this.setErrorMessage("No interpreter? " + e.getMessage());
            return false;
        }
        if (interpreter == null) {
            return false;
        }
        try {
            return this.checkIfInterpreterExists(interpreter);
        }
        catch (Exception e) {
            this.setMessage(e.getMessage());
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }

    public String getName() {
        return "Interpreter";
    }

    public Image getImage() {
        return PydevPlugin.getImageCache().get("icons/python_16x16.png");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy arg0) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fWorkingCopyForCommandLineGeneration = configuration.getWorkingCopy();
        }
        catch (CoreException e1) {
            throw new RuntimeException(e1);
        }
        String interpreter = "";
        try {
            interpreter = configuration.getAttribute("org.python.pydev.debug.ATTR_INTERPRETER", "__default");
        }
        catch (CoreException coreException) {}
        String[] interpreters = this.fInterpreterComboField.getItems();
        if (interpreters.length == 0) {
            this.setErrorMessage("No interpreter is configured, please, go to window > preferences > interpreters and add the interpreter you want to use.");
        } else {
            int selectThis = -1;
            if (interpreter.equals("__default")) {
                selectThis = 0;
            } else {
                int i = 1;
                while (i < interpreters.length) {
                    if (interpreter.equals(interpreters[i])) {
                        selectThis = i;
                        break;
                    }
                    ++i;
                }
            }
            if (selectThis == -1) {
                if (interpreter.startsWith("${")) {
                    this.fInterpreterComboField.setText(interpreter);
                } else {
                    this.setErrorMessage("Obsolete interpreter is selected. Choose a new one.");
                }
            } else {
                this.fInterpreterComboField.select(selectThis);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String value = this.fInterpreterComboField.getSelectionIndex() == 0 ? "__default" : this.fInterpreterComboField.getText();
        this.setAttribute(configuration, "org.python.pydev.debug.ATTR_INTERPRETER", value);
    }

    protected boolean checkIfInterpreterExists(String interpreter) {
        if (interpreter.equals("__default")) {
            return this.fInterpreterManager.getDefaultInterpreter() != null;
        }
        String[] interpreters = this.fInterpreterManager.getInterpreters();
        int i = 0;
        while (i < interpreters.length) {
            if (interpreters[i] != null && interpreters[i].equals(interpreter)) {
                return true;
            }
            ++i;
        }
        return interpreter.startsWith("${");
    }

    private void setAttribute(ILaunchConfigurationWorkingCopy conf, String name, String value) {
        if (value == null || value.length() == 0) {
            conf.setAttribute(name, null);
        } else {
            conf.setAttribute(name, value);
        }
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }
}

