/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Hashtable;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.plugin.PydevPlugin;

public class DebuggerReader
implements Runnable {
    private static final boolean DEBUG = false;
    private Socket socket;
    private boolean done = false;
    private Hashtable responseQueue = new Hashtable();
    private BufferedReader in;
    private AbstractRemoteDebugger remote;

    public DebuggerReader(Socket s, AbstractRemoteDebugger r) throws IOException {
        this.remote = r;
        this.socket = s;
        InputStream sin = this.socket.getInputStream();
        this.in = new BufferedReader(new InputStreamReader(sin));
    }

    public void done() {
        this.done = true;
    }

    public void addToResponseQueue(AbstractDebuggerCommand cmd) {
        int sequence = cmd.getSequence();
        this.responseQueue.put(new Integer(sequence), cmd);
    }

    private void processCommand(String cmdLine) {
        try {
            String[] cmdParsed = cmdLine.split("\t", 3);
            int cmdCode = Integer.parseInt(cmdParsed[0]);
            int seqCode = Integer.parseInt(cmdParsed[1]);
            String payload = URLDecoder.decode(cmdParsed[2], "UTF-8");
            AbstractDebuggerCommand cmd = (AbstractDebuggerCommand)this.responseQueue.remove(new Integer(seqCode));
            if (cmd == null) {
                if (this.remote.getTarget() != null) {
                    this.remote.getTarget().processCommand(cmdParsed[0], cmdParsed[1], payload);
                } else {
                    PydevDebugPlugin.log(4, "internal error, command received no target", null);
                }
            } else {
                cmd.processResponse(cmdCode, payload);
            }
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            try {
                String cmdLine = this.in.readLine();
                if (cmdLine != null) {
                    this.processCommand(cmdLine);
                }
                DebuggerReader debuggerReader = this;
                synchronized (debuggerReader) {
                    Thread.sleep(50L);
                }
            }
            catch (Exception exception) {
                this.done = true;
            }
            if (this.socket != null && this.socket.isConnected()) continue;
            AbstractDebugTarget target = this.remote.getTarget();
            if (target != null) {
                target.debuggerDisconnected();
            }
            this.done = true;
        }
        this.remote.dispose();
    }
}

