/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableCollection;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.EvaluateExpressionCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;

public class PyWatchExpressionDelegate
implements IWatchExpressionDelegate,
IWatchExpressionResult,
ICommandResponseListener {
    protected PyVariable[] variables = new PyVariable[0];
    protected IDebugElement context;
    protected String expression;
    protected IWatchExpressionListener listener;
    protected String[] errors = new String[0];

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.expression = expression;
        this.context = context;
        this.listener = listener;
        if (context instanceof PyStackFrame) {
            AbstractRemoteDebugger dbg = ((AbstractDebugTarget)context.getDebugTarget()).getDebugger();
            if (dbg == null) {
                return;
            }
            EvaluateExpressionCommand cmd = new EvaluateExpressionCommand(dbg, expression, ((PyStackFrame)context).getLocalsLocator().getPyDBLocation(), false);
            cmd.setCompletionListener(this);
            dbg.postCommand(cmd);
        } else {
            this.addError("unknown expression context");
            listener.watchEvaluationFinished((IWatchExpressionResult)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getValue() {
        PyVariable[] pyVariableArray = this.variables;
        synchronized (this.variables) {
            if (this.variables.length == 0) {
                this.variables = new PyVariable[1];
                this.variables[0] = new PyVariable((AbstractDebugTarget)this.context.getDebugTarget(), "Error", "pydev ERROR", "Could not resolve variable", null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.variables[0];
        }
    }

    public boolean hasErrors() {
        return this.errors.length > 0;
    }

    public String[] getErrorMessages() {
        return this.errors;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public DebugException getException() {
        return null;
    }

    public void addError(String error_string) {
        String[] resized_errors = new String[this.errors.length + 1];
        int i = 0;
        while (i < this.errors.length) {
            resized_errors[i] = this.errors[i];
            ++i;
        }
        this.errors = resized_errors;
        this.errors[this.errors.length - 1] = error_string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void commandComplete(AbstractDebuggerCommand cmd) {
        try {
            String payload = ((EvaluateExpressionCommand)cmd).getResponse();
            PyVariable[] pyVariableArray = this.variables;
            // MONITORENTER : this.variables
            this.variables = XMLUtils.XMLToVariables((AbstractDebugTarget)this.context.getDebugTarget(), ((PyStackFrame)this.context).getLocalsLocator(), payload);
            // MONITOREXIT : pyVariableArray
        }
        catch (CoreException e) {
            PyVariable[] pyVariableArray = this.variables;
            // MONITORENTER : this.variables
            this.variables = new PyVariable[1];
            this.variables[0] = new PyVariable((PyDebugTarget)this.context.getDebugTarget(), "Error", "pydev ERROR", "Could not resolve variable", null);
            // MONITOREXIT : pyVariableArray
            PydevDebugPlugin.log(4, "Error fetching a variable", e);
        }
        PyVariable[] pyVariableArray = this.variables;
        // MONITORENTER : this.variables
        if (this.variables[0] instanceof PyVariableCollection) {
            ((PyVariableCollection)this.variables[0]).networkState = 2;
        }
        // MONITOREXIT : pyVariableArray
        this.listener.watchEvaluationFinished((IWatchExpressionResult)this);
    }
}

