/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNode {
    public Object node;
    public int stmts;
    public int exec;
    public String notExecuted;

    public boolean equals(Object obj) {
        if (!(obj instanceof FileNode)) {
            return false;
        }
        FileNode f = (FileNode)obj;
        return f.node.equals(this.node) && f.exec == this.exec && f.notExecuted.equals(this.notExecuted) && f.stmts == this.stmts;
    }

    public String toString() {
        return FileNode.toString(this.node.toString(), this.stmts, this.exec, this.notExecuted);
    }

    public static String toString(String str, int stmts, int exec, String notExecuted) {
        return new FastStringBuffer().append(FileNode.getName(str)).append("   ").append(FileNode.getStmts(stmts)).append("     ").append(exec).append("      ").append(FileNode.calcCover(stmts, exec)).append("  ").append(notExecuted).toString();
    }

    public static String getName(String str) {
        if (str.length() > 40) {
            str = str.substring(str.length() - 37, str.length());
            str = new StringBuffer(".. ").append(str).toString();
        }
        while (str.length() < 40) {
            str = new StringBuffer(" ").append(str).toString();
        }
        return str;
    }

    public static String getStmts(int stmts) {
        FastStringBuffer str = new FastStringBuffer();
        str.append(stmts);
        while (str.length() < 4) {
            str.insert(0, " ");
        }
        return str.toString();
    }

    public static String getExec(int exec) {
        return FileNode.getStmts(exec);
    }

    public static String calcCover(int stmts, int exec) {
        double v = 0.0;
        if (stmts != 0) {
            v = (double)exec / (double)stmts * 100.0;
        }
        DecimalFormat format = new DecimalFormat("##.#");
        String str = format.format(v);
        str = new StringBuffer(String.valueOf(str)).append("%").toString();
        while (str.length() < 5) {
            str = new StringBuffer(" ").append(str).toString();
        }
        return str;
    }

    public Iterator<Object> notExecutedIterator() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        String[] toks = this.notExecuted.replaceAll(" ", "").split(",");
        int i = 0;
        while (i < toks.length) {
            if (toks[i].indexOf("-") == -1) {
                l.add(new Integer(toks[i]));
            } else {
                String[] begEnd = toks[i].split("-");
                int j = Integer.parseInt(begEnd[0]);
                while (j <= Integer.parseInt(begEnd[1])) {
                    l.add(new Integer(j));
                    ++j;
                }
            }
            ++i;
        }
        return l.iterator();
    }
}

