/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.PydevPlugin;

public class PyDeletePycAndClassFiles
implements IObjectActionDelegate {
    protected List<IContainer> selectedContainers;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected int deletePycFiles(IContainer container) {
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        int deleted = 0;
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                IResource c = iResourceArray[n2];
                if (c instanceof IContainer) {
                    deleted += this.deletePycFiles((IContainer)c);
                } else if (c instanceof IFile && (name = c.getName()) != null && (name.endsWith(".pyc") || name.endsWith(".pyo") || name.endsWith("$py.class"))) {
                    c.delete(true, (IProgressMonitor)nullProgressMonitor);
                    ++deleted;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
        return deleted;
    }

    public void run(IAction action) {
        if (this.selectedContainers == null) {
            return;
        }
        if (!MessageDialog.openConfirm(null, (String)"Confirm deletion", (String)"Are you sure that you want to delete the *.pyc and *$py.class files from the selected folder(s)?")) {
            return;
        }
        int nDeleted = 0;
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        Iterator<IContainer> iter = this.selectedContainers.iterator();
        while (iter.hasNext()) {
            IContainer next = iter.next();
            try {
                next.refreshLocal(2, (IProgressMonitor)nullProgressMonitor);
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
            nDeleted += this.deletePycFiles(next);
        }
        MessageDialog.openInformation(null, (String)"Files deleted", (String)StringUtils.format((String)"Deleted %s files.", (Object[])new Object[]{Autobox.valueOf((int)nDeleted)}));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.selectedContainers = null;
            return;
        }
        IStructuredSelection selections = (IStructuredSelection)selection;
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        Iterator it = selections.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof IContainer)) continue;
            containers.add((IContainer)o);
        }
        this.selectedContainers = containers;
    }
}

