/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.pyunit;

import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.pyunit.ITestRunListener;
import org.python.pydev.pyunit.TestResult;

public class TestReportContentProvider
implements IStructuredContentProvider,
ITestRunListener {
    private TableViewer viewer;
    private TestResult currentResult;

    public TestReportContentProvider() {
        PydevPlugin.getDefault().addTestListener(this);
    }

    public void dispose() {
        PydevPlugin.getDefault().removeTestListener(this);
    }

    public Object[] getElements(Object inputElement) {
        return ((List)inputElement).toArray();
    }

    private List getTestResults() {
        return (List)this.viewer.getInput();
    }

    public void inputChanged(Viewer tableViewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)tableViewer;
    }

    public void testsStarted(int testCount) {
        ((List)this.viewer.getInput()).clear();
        this.currentResult = null;
        this.viewer.refresh();
    }

    public void testsFinished() {
        this.addLastResult();
    }

    public void testStarted(String klass, String method) {
        this.addLastResult();
        this.currentResult = new TestResult(klass, method, 0, System.currentTimeMillis());
    }

    public void testFailed(String klass, String method, String trace) {
        this.currentResult.testFailed();
    }

    private void addLastResult() {
        if (this.currentResult != null) {
            this.currentResult.testFinished();
            this.getTestResults().add(this.currentResult);
            Control ctrl = this.viewer.getControl();
            if (ctrl == null || ctrl.isDisposed()) {
                return;
            }
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!TestReportContentProvider.this.viewer.getControl().isDisposed()) {
                        TestReportContentProvider.this.viewer.insert((Object)TestReportContentProvider.this.currentResult, -1);
                    }
                }
            });
        }
    }
}

