/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.IPythonNatureStore;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.PythonPathNature;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

class PythonNatureStore
implements IResourceChangeListener,
IPythonNatureStore {
    private static final String STORE_FILE_NAME = ".pydevproject";
    private static final String PYDEV_PROJECT_DESCRIPTION = "pydev_project";
    private static final String PYDEV_NATURE_PROPERTY = "pydev_property";
    private static final String PYDEV_NATURE_PATH_PROPERTY = "pydev_pathproperty";
    private static final String PYDEV_PATH = "path";
    private static final String PYDEV_NATURE_PROPERTY_NAME = "name";
    private volatile IProject project = null;
    private volatile IFile xmlFile = null;
    private volatile long modStamp = -1L;
    private volatile int onIgnoreRefresh = 0;
    private volatile int onStoreJob = 0;
    private volatile boolean loaded = false;
    private volatile Document document = null;
    private static final boolean TRACE_PYTHON_NATURE_STORE = false;
    private StringBuffer indent = new StringBuffer();
    private volatile boolean inInit;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !ClassLiteral.getClass((String)"org/python/pydev/plugin/nature/PythonNatureStore").desiredAssertionStatus();
    }

    PythonNatureStore() {
    }

    private void traceFunc(String func, Object ... args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setProject(IProject project) {
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (project == null) {
                if (this.project == null) {
                    return;
                }
                this.traceFunc("setProject: null", new Object[0]);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                this.project = null;
                this.xmlFile = null;
                this.document = null;
            } else {
                this.traceFunc("setProject - ", project.getName());
                try {
                    this.project = project;
                    this.xmlFile = project.getFile(STORE_FILE_NAME);
                    try {
                        this.loadFromFile();
                    }
                    catch (CoreException e) {
                        throw new RuntimeException("Error loading project: " + project, e);
                    }
                    if (!ProjectModulesManager.IN_TESTS) {
                        project.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
                    }
                }
                finally {
                    this.loaded = true;
                }
                this.traceFunc("END setProject - ", project.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkLoad(String function) {
        this.traceFunc("checkLoad", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (!this.loaded) {
                PydevPlugin.log(new RuntimeException(StringUtils.format((String)"%s still not loaded and '%s' already called.", (Object[])new Object[]{this.xmlFile, function})));
            }
        }
        this.traceFunc("END checkLoad", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getPathProperty(QualifiedName key) throws CoreException {
        if (this.project == null) {
            return "";
        }
        this.traceFunc("getPathProperty - ", key);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            this.checkLoad("getPathProperty");
            String ret = this.getPathStringFromArray(this.getPathPropertyFromXml(key));
            this.traceFunc("END getPathProperty - ", ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPathProperty(QualifiedName key, String value) throws CoreException {
        this.traceFunc("setPathProperty", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            this.checkLoad("setPathProperty");
            this.setPathPropertyToXml(key, this.getArrayFromPathString(value), true);
        }
        this.traceFunc("END setPathProperty", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean loadFromFile() throws CoreException {
        boolean ret;
        if (this.project == null) {
            return false;
        }
        this.traceFunc("loadFromFile", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            block17: {
                try {
                    DocumentBuilder parser;
                    block19: {
                        parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        try {
                            ++this.onIgnoreRefresh;
                            this.xmlFile.refreshLocal(0, null);
                        }
                        finally {
                            --this.onIgnoreRefresh;
                        }
                        if (!this.xmlFile.exists()) {
                            if (this.document != null) {
                                this.doStore();
                                ret = true;
                            } else {
                                this.document = parser.newDocument();
                                ProcessingInstruction version = this.document.createProcessingInstruction("eclipse-pydev", "version=\"1.0\"");
                                this.document.appendChild(version);
                                Element configRootElement = this.document.createElement(PYDEV_PROJECT_DESCRIPTION);
                                this.document.appendChild(configRootElement);
                                this.migrateProperty(PythonNature.getPythonProjectVersionQualifiedName());
                                this.migratePath(PythonPathNature.getProjectSourcePathQualifiedName());
                                this.migratePath(PythonPathNature.getProjectExternalSourcePathQualifiedName());
                                this.doStore();
                                ret = true;
                            }
                            break block17;
                        }
                        try {
                            try {
                                ++this.onIgnoreRefresh;
                                this.xmlFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (Exception e) {
                                PydevPlugin.log(e);
                                --this.onIgnoreRefresh;
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            --this.onIgnoreRefresh;
                            throw throwable;
                        }
                        --this.onIgnoreRefresh;
                    }
                    this.document = parser.parse(this.xmlFile.getContents());
                    this.modStamp = this.xmlFile.getModificationStamp();
                    ret = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        }
        this.traceFunc("END loadFromFile", new Object[0]);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void migrateProperty(QualifiedName key) throws CoreException {
        this.traceFunc("migrateProperty", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            String propertyVal = this.project.getPersistentProperty(key);
            if (propertyVal != null) {
                this.setPropertyToXml(key, propertyVal, false);
                this.project.setPersistentProperty(key, null);
            }
        }
        this.traceFunc("END migrateProperty", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void migratePath(QualifiedName key) throws CoreException {
        this.traceFunc("migratePath", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            String[] propertyVal = this.getArrayFromPathString(this.project.getPersistentProperty(key));
            if (propertyVal != null) {
                this.setPathPropertyToXml(key, propertyVal, false);
                this.project.setPersistentProperty(key, null);
            }
        }
        this.traceFunc("END migratePath", new Object[0]);
    }

    private synchronized Node getRootNodeInXml() {
        this.traceFunc("getRootNodeInXml", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            Assert.isNotNull((Object)this.document);
            NodeList nodeList = this.document.getElementsByTagName(PYDEV_PROJECT_DESCRIPTION);
            Node ret = null;
            if (nodeList != null && nodeList.getLength() > 0) {
                ret = nodeList.item(0);
            }
            this.traceFunc("END getRootNodeInXml -- ", ret);
            if (ret != null) {
                return ret;
            }
            throw new RuntimeException(StringUtils.format((String)"Error. Unable to get the %s tag by its name. Project: %s", (Object[])new Object[]{PYDEV_PROJECT_DESCRIPTION, this.project}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getKeyString(QualifiedName key) {
        this.traceFunc("getKeyString", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            String keyString = key.getQualifier() != null ? key.getQualifier() : "";
            String ret = String.valueOf(keyString) + "." + key.getLocalName();
            this.traceFunc("END getKeyString", new Object[0]);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Node findPropertyNodeInXml(String type, QualifiedName key) {
        this.traceFunc("findPropertyNodeInXml", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            Node root = this.getRootNodeInXml();
            NodeList childNodes = root.getChildNodes();
            if (childNodes != null && childNodes.getLength() > 0) {
                String keyString = this.getKeyString(key);
                int i = 0;
                while (i < childNodes.getLength()) {
                    String name;
                    NamedNodeMap attrs;
                    Node child = childNodes.item(i);
                    if (child.getNodeName().equals(type) && (attrs = child.getAttributes()) != null && attrs.getLength() > 0 && (name = attrs.getNamedItem(PYDEV_NATURE_PROPERTY_NAME).getNodeValue()) != null && name.equals(keyString)) {
                        this.traceFunc("END findPropertyNodeInXml - ", child);
                        return child;
                    }
                    ++i;
                }
            }
            this.traceFunc("END findPropertyNodeInXml (null)", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] getChildValuesWithType(Node node, String type) {
        this.traceFunc("getChildValuesWithType", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            NodeList childNodes = node.getChildNodes();
            if (childNodes != null && childNodes.getLength() > 0) {
                ArrayList<String> result = new ArrayList<String>();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node child = childNodes.item(i);
                    if (child.getNodeName().equals(type)) {
                        result.add(this.getTextContent(child));
                    }
                    ++i;
                }
                String[] retval = new String[result.size()];
                this.traceFunc("END getChildValuesWithType", new Object[0]);
                return result.toArray(retval);
            }
            this.traceFunc("END getChildValuesWithType (null)", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addChildValuesWithType(Node node, String type, String[] values) {
        this.traceFunc("addChildValuesWithType", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && values == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < values.length) {
                Element child = this.document.createElement(type);
                this.setTextContent(values[i], child);
                node.appendChild(child);
                ++i;
            }
        }
        this.traceFunc("END addChildValuesWithType", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getPathStringFromArray(String[] pathArray) {
        this.traceFunc("getPathStringFromArray", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (pathArray != null) {
                FastStringBuffer s = new FastStringBuffer();
                int i = 0;
                while (i < pathArray.length) {
                    if (i > 0) {
                        s.append('|');
                    }
                    s.append(pathArray[i]);
                    ++i;
                }
                this.traceFunc("END getPathStringFromArray", new Object[0]);
                return s.toString();
            }
            this.traceFunc("END getPathStringFromArray (null)", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] getArrayFromPathString(String pathString) {
        this.traceFunc("getArrayFromPathString", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (pathString != null) {
                this.traceFunc("END getArrayFromPathString", new Object[0]);
                return pathString.split("\\|");
            }
            this.traceFunc("END getArrayFromPathString (null)", new Object[0]);
            return null;
        }
    }

    public synchronized String getPropertyFromXml(QualifiedName key) {
        if (this.project == null) {
            return "";
        }
        this.traceFunc("getPropertyFromXml - ", key);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            this.checkLoad("getPropertyFromXml");
            try {
                Node propertyNode = this.findPropertyNodeInXml(PYDEV_NATURE_PROPERTY, key);
                if (propertyNode != null) {
                    String ret = this.getTextContent(propertyNode);
                    this.traceFunc("END getPropertyFromXml -- ", ret);
                    return ret;
                }
                this.traceFunc("END getPropertyFromXml (null)", new Object[0]);
                return null;
            }
            catch (Exception e) {
                this.traceFunc("END getPropertyFromXml (EXCEPTION)", new Object[0]);
                throw new RuntimeException("Error on document:" + this.document + " project:" + this.project, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPropertyToXml(QualifiedName key, String value, boolean store) throws CoreException {
        this.traceFunc(StringUtils.format((String)"setPropertyToXml key:%s value:%s store:%s", (Object[])new Object[]{key, value, Autobox.valueOf((boolean)store)}), new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            if (store) {
                this.checkLoad("setPropertyToXml");
            }
            try {
                Node child = this.findPropertyNodeInXml(PYDEV_NATURE_PROPERTY, key);
                if (child != null) {
                    if (value == null) {
                        this.getRootNodeInXml().removeChild(child);
                    } else {
                        this.setTextContent(value, child);
                    }
                    this.doStore();
                } else if (value != null) {
                    Element property = this.document.createElement(PYDEV_NATURE_PROPERTY);
                    Attr propertyName = this.document.createAttribute(PYDEV_NATURE_PROPERTY_NAME);
                    propertyName.setNodeValue(this.getKeyString(key));
                    property.getAttributes().setNamedItem(propertyName);
                    this.setTextContent(value, property);
                    this.getRootNodeInXml().appendChild(property);
                    if (store) {
                        this.doStore();
                    }
                }
            }
            catch (Exception e) {
                this.traceFunc("END setPropertyToXml (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        this.traceFunc("END setPropertyToXml", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setTextContent(String textContent, Node self) throws DOMException {
        this.traceFunc("setTextContent", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            Node child;
            while ((child = self.getFirstChild()) != null) {
                self.removeChild(child);
            }
            if (textContent != null && textContent.length() != 0) {
                self.appendChild(this.document.createTextNode(textContent));
            }
        }
        this.traceFunc("END setTextContent", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String getTextContent(Node self) throws DOMException {
        this.traceFunc("getTextContent", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            String nodeValue;
            FastStringBuffer fBufferStr = new FastStringBuffer();
            Node child = self.getFirstChild();
            if (child == null) {
                this.traceFunc("END getTextContent - EMPTY", new Object[0]);
                return "";
            }
            Node next = child.getNextSibling();
            if (next != null) {
                fBufferStr.clear();
                this.getTextContent(fBufferStr, self);
                this.traceFunc("END getTextContent - ", fBufferStr);
                return fBufferStr.toString();
            }
            if (this.hasTextContent(child) && (nodeValue = child.getNodeValue()) != null) {
                this.traceFunc("END getTextContent - ", nodeValue);
                return nodeValue;
            }
            this.traceFunc("END getTextContent - EMPTY", new Object[0]);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getTextContent(FastStringBuffer buf, Node self) throws DOMException {
        this.traceFunc("getTextContent", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            Node child = self.getFirstChild();
            while (child != null) {
                if (this.hasTextContent(child)) {
                    this.getTextContent(buf, child);
                }
                child = child.getNextSibling();
            }
        }
        this.traceFunc("END getTextContent", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean hasTextContent(Node child) {
        this.traceFunc("hasTextContent", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            boolean ret = child.getNodeType() != 8 && child.getNodeType() != 7;
            this.traceFunc("END hasTextContent ", Autobox.valueOf((boolean)ret));
            return ret;
        }
    }

    private synchronized String[] getPathPropertyFromXml(QualifiedName key) throws CoreException {
        this.traceFunc("getPathPropertyFromXml", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                Node propertyNode = this.findPropertyNodeInXml(PYDEV_NATURE_PATH_PROPERTY, key);
                if (propertyNode != null) {
                    this.traceFunc("END getPathPropertyFromXml", new Object[0]);
                    return this.getChildValuesWithType(propertyNode, PYDEV_PATH);
                }
                this.traceFunc("END getPathPropertyFromXml (null)", new Object[0]);
                return null;
            }
            catch (Exception e) {
                this.traceFunc("END getPathPropertyFromXml (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setPathPropertyToXml(QualifiedName key, String[] paths, boolean store) throws CoreException {
        this.traceFunc("setPathPropertyToXml", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                Node oldChild = this.findPropertyNodeInXml(PYDEV_NATURE_PATH_PROPERTY, key);
                if (oldChild != null && paths == null) {
                    this.getRootNodeInXml().removeChild(oldChild);
                    this.doStore();
                } else if (paths != null) {
                    Element property = this.document.createElement(PYDEV_NATURE_PATH_PROPERTY);
                    Attr propertyName = this.document.createAttribute(PYDEV_NATURE_PROPERTY_NAME);
                    propertyName.setNodeValue(this.getKeyString(key));
                    property.getAttributes().setNamedItem(propertyName);
                    this.addChildValuesWithType(property, PYDEV_PATH, paths);
                    if (oldChild == null) {
                        this.getRootNodeInXml().appendChild(property);
                    } else {
                        this.getRootNodeInXml().replaceChild(property, oldChild);
                    }
                    if (store) {
                        this.doStore();
                    }
                }
            }
            catch (Exception e) {
                this.traceFunc("END setPathPropertyToXml (EXCEPTION)", new Object[0]);
                Status status = new Status(4, "PythonNatureStore", -1, e.toString(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        this.traceFunc("END setPathPropertyToXml", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[] serializeDocument(Document doc) throws IOException, TransformerException {
        this.traceFunc("serializeDocument", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            this.traceFunc("END serializeDocument", new Object[0]);
            return s.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doStore() {
        this.traceFunc("doStore", new Object[0]);
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                this.doStore((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                throw new RuntimeException("Error storing pydev project descriptor:" + this.project, e);
            }
        }
        this.traceFunc("END doStore", new Object[0]);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        PythonNature nature;
        if (this.project == null) {
            return;
        }
        this.traceFunc("resourceChanged -- ", this.project.getName());
        if (this.inInit) {
            this.traceFunc("END resourceChanged (inInit)", new Object[0]);
            return;
        }
        boolean doRebuild = false;
        if (this.onIgnoreRefresh != 0) {
            this.traceFunc("END resourceChanged (on ignore refresh)", new Object[0]);
            return;
        }
        if (this.onStoreJob != 0) {
            this.traceFunc("END resourceChanged (on store)", new Object[0]);
            return;
        }
        if (!this.project.isOpen()) {
            this.traceFunc("END resourceChanged (!open)", new Object[0]);
            return;
        }
        IResourceDelta eventDelta = event.getDelta();
        if (eventDelta == null) {
            this.traceFunc("END resourceChanged (eventDelta == null)", new Object[0]);
            return;
        }
        IResourceDelta delta = eventDelta.findMember(this.xmlFile.getFullPath());
        if (delta != null && this.xmlFile.getModificationStamp() != this.modStamp) {
            try {
                if (this.loadFromFile()) {
                    doRebuild = true;
                }
            }
            catch (CoreException e) {
                this.traceFunc("END resourceChanged (EXCEPTION)", new Object[0]);
                throw new RuntimeException(e);
            }
        }
        if (doRebuild && (nature = PythonNature.getPythonNature(this.project)) != null) {
            nature.rebuildPath();
        }
        this.traceFunc("END resourceChanged -- rebuilt:", Autobox.valueOf((boolean)doRebuild));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized IStatus doStore(IProgressMonitor monitor) throws IOException, TransformerException, CoreException {
        if (this.project == null) {
            return Status.OK_STATUS;
        }
        this.traceFunc("doStore", new Object[0]);
        if (this.inInit) {
            this.traceFunc("END doStore (inInit)", new Object[0]);
            return Status.OK_STATUS;
        }
        PythonNatureStore pythonNatureStore = this;
        synchronized (pythonNatureStore) {
            try {
                if (this.onStoreJob != 0) {
                    this.traceFunc("END doStore (already in store)", new Object[0]);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                ++this.onStoreJob;
                if (this.document == null) {
                    this.traceFunc("END doStore (document == null)", new Object[0]);
                    Status status = new Status(4, "PythonNatureStore.doStore", -2, "document == null", (Throwable)new RuntimeException("document == null"));
                    return status;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(this.serializeDocument(this.document));
                PythonNatureStoreJob job = new PythonNatureStoreJob("Save .pydevproject", is);
                if (ProjectModulesManager.IN_TESTS) {
                    job.run((IProgressMonitor)new NullProgressMonitor());
                } else {
                    job.schedule();
                }
                this.traceFunc("END doStore", new Object[0]);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                --this.onStoreJob;
            }
        }
    }

    public void startInit() {
        this.inInit = true;
    }

    public void endInit() {
        this.inInit = false;
        this.doStore();
    }

    private final class PythonNatureStoreJob
    extends Job {
        private final ByteArrayInputStream is;

        private PythonNatureStoreJob(String name, ByteArrayInputStream is) {
            super(name);
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IFile iFile = PythonNatureStore.this.xmlFile;
            synchronized (iFile) {
                block10: {
                    try {
                        try {
                            PythonNatureStore pythonNatureStore = PythonNatureStore.this;
                            pythonNatureStore.onIgnoreRefresh = pythonNatureStore.onIgnoreRefresh + 1;
                            if (!PythonNatureStore.this.xmlFile.exists()) {
                                PythonNatureStore.this.xmlFile.create((InputStream)this.is, true, monitor);
                                PythonNatureStore.this.modStamp = PythonNatureStore.this.xmlFile.getModificationStamp();
                            } else {
                                PythonNatureStore.this.xmlFile.setContents((InputStream)this.is, true, false, monitor);
                                PythonNatureStore.this.modStamp = PythonNatureStore.this.xmlFile.getModificationStamp();
                            }
                            PythonNatureStore.this.xmlFile.refreshLocal(0, monitor);
                        }
                        catch (Exception e) {
                            PydevPlugin.log(e);
                            PythonNatureStore pythonNatureStore = PythonNatureStore.this;
                            pythonNatureStore.onIgnoreRefresh = pythonNatureStore.onIgnoreRefresh - 1;
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        PythonNatureStore pythonNatureStore = PythonNatureStore.this;
                        pythonNatureStore.onIgnoreRefresh = pythonNatureStore.onIgnoreRefresh - 1;
                        throw throwable;
                    }
                    PythonNatureStore pythonNatureStore = PythonNatureStore.this;
                    pythonNatureStore.onIgnoreRefresh = pythonNatureStore.onIgnoreRefresh - 1;
                }
            }
            return Status.OK_STATUS;
        }
    }
}

