/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.ui;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.navigator.elements.PythonFile;
import org.python.pydev.plugin.PydevPlugin;

public class PydevPackageExplorer
extends CommonNavigator
implements IShowInTarget {
    private IMemento memento;

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.memento = aMemento;
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        PydevCommonViewer aViewer = new PydevCommonViewer(this.getViewSite().getId(), aParent, 770);
        this.initListeners((TreeViewer)aViewer);
        return aViewer;
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        PydevCommonViewer viewer = (PydevCommonViewer)this.getCommonViewer();
        viewer.availableToRestoreMemento = true;
        int i = 0;
        while (i < 3) {
            block3: {
                try {
                    viewer.getNavigatorContentService().restoreState(this.memento);
                }
                catch (Exception e1) {
                    if (i <= 1) break block3;
                    PydevPlugin.log("Unable to restore the state of the Pydev Package Explorer.", e1);
                }
            }
            ++i;
        }
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public boolean show(ShowInContext context) {
        Object input;
        IStructuredSelection structuredSelection;
        Object elementOfInput = null;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            elementOfInput = structuredSelection.getFirstElement();
        }
        if ((input = context.getInput()) instanceof IEditorInput) {
            elementOfInput = this.getElementOfInput((IEditorInput)context.getInput());
        }
        return elementOfInput != null && this.tryToReveal(elementOfInput);
    }

    public boolean tryToReveal(Object element) {
        IAdaptable adaptable;
        IResource resource;
        if (this.revealAndVerify(element = this.getPythonModelElement(element))) {
            return true;
        }
        return element instanceof IAdaptable && !(element instanceof IResource) && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"))) != null && this.revealAndVerify(resource);
    }

    private Object getPythonModelElement(Object element) {
        IAdaptable adaptable;
        IFile file;
        if (element instanceof IWrappedResource) {
            return element;
        }
        INavigatorPipelineService pipelineService = this.getNavigatorContentService().getPipelineService();
        if (element instanceof IAdaptable && (file = (IFile)(adaptable = (IAdaptable)element).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"))) != null) {
            ContributorTrackingSet files = new ContributorTrackingSet((NavigatorContentService)this.getNavigatorContentService());
            files.add(file);
            pipelineService.interceptAdd(new PipelinedShapeModification((Object)file.getParent(), (Set)files));
            if (files.size() > 0) {
                element = files.iterator().next();
            }
        }
        return element;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(element));
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    public void selectReveal(ISelection selection) {
        CommonViewer commonViewer = this.getCommonViewer();
        if (commonViewer != null) {
            if (selection instanceof IStructuredSelection) {
                Object[] newSelection = ((IStructuredSelection)selection).toArray();
                int i = 0;
                while (i < newSelection.length) {
                    Object object = this.getPythonModelElement(newSelection[i]);
                    if (object instanceof PythonFile) {
                        PythonFile file = (PythonFile)object;
                        newSelection[i] = file.getParentElement();
                    }
                    ++i;
                }
                Object[] expandedElements = commonViewer.getExpandedElements();
                Object[] newExpandedElements = new Object[newSelection.length + expandedElements.length];
                System.arraycopy(expandedElements, 0, newExpandedElements, 0, expandedElements.length);
                System.arraycopy(newSelection, 0, newExpandedElements, expandedElements.length, newSelection.length);
                commonViewer.setExpandedElements(newExpandedElements);
            }
            commonViewer.setSelection(selection, true);
        }
    }

    public static class PydevCommonViewer
    extends CommonViewer {
        public boolean availableToRestoreMemento = false;

        public PydevCommonViewer(String id, Composite parent, int style) {
            super(id, parent, style);
        }

        protected TreePath getTreePathFromItem(Item item) {
            LinkedList<Object> segments = new LinkedList<Object>();
            while (item != null) {
                Object segment = item.getData();
                if (segment == null) {
                    return null;
                }
                segments.addFirst(segment);
                item = this.getParentItem(item);
            }
            return new TreePath(segments.toArray());
        }
    }
}

