/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.refactoring;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyRefactoring
extends AbstractPyRefactoring {
    @Override
    public String getName() {
        return "BRM Refactorer";
    }

    public PyRefactoring() {
        try {
            AbstractShell.getServerShell(0, 2);
        }
        catch (Exception exception) {}
    }

    @Override
    public void restartShell() {
        try {
            AbstractShell.getServerShell(0, 2).restartShell();
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }

    @Override
    public void killShell() {
        try {
            AbstractShell.getServerShell(0, 2).endIt();
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }

    private String makeAction(String str, RefactoringRequest request) {
        PyRefactorAction.checkAvailableForRefactoring(request, this);
        try {
            AbstractShell pytonShell = AbstractShell.getServerShell(request.nature, 2);
            try {
                pytonShell.changePythonPath(request.nature.getPythonPathNature().getCompleteProjectPythonPath(null));
                pytonShell.write(str);
                return URLDecoder.decode(pytonShell.read(request.getMonitor()), "UTF-8");
            }
            catch (Exception e) {
                PydevPlugin.log(new StringBuffer("Error writing: ").append(str).toString(), e);
                pytonShell.restartShell();
            }
        }
        catch (Exception e1) {
            PydevPlugin.log(new StringBuffer("Error writing: ").append(str).toString(), e1);
        }
        return null;
    }

    @Override
    public String extract(RefactoringRequest request) {
        File editorFile = request.file;
        String s = "@@BIKE";
        s = new StringBuffer(String.valueOf(s)).append("extractMethod").toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(REF.getFileAbsolutePath((File)editorFile)).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginLine()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginCol()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getEndLine()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getEndCol()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.inputName).toString();
        s = new StringBuffer(String.valueOf(s)).append("END@@").toString();
        String string = this.makeAction(s, request);
        this.communicateRefactorResult(string);
        return string;
    }

    @Override
    public String rename(RefactoringRequest request) {
        if (request.inputName == null || request.inputName.equals("")) {
            return "";
        }
        File editorFile = request.file;
        String s = "@@BIKE";
        s = new StringBuffer(String.valueOf(s)).append("renameByCoordinates").toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(REF.getFileAbsolutePath((File)editorFile)).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginLine()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginCol()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.inputName).toString();
        s = new StringBuffer(String.valueOf(s)).append("END@@").toString();
        String string = this.makeAction(s, request);
        this.communicateRefactorResult(string);
        return string;
    }

    public String getRenameInputMessage() {
        return "Please inform the new name.";
    }

    @Override
    public ItemPointer[] findDefinition(RefactoringRequest request) {
        File editorFile = request.file;
        String s = "@@BIKE";
        s = new StringBuffer(String.valueOf(s)).append("findDefinition").toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(REF.getFileAbsolutePath((File)editorFile)).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginLine()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginCol()).toString();
        s = new StringBuffer(String.valueOf(s)).append("END@@").toString();
        String string = this.makeAction(s, request);
        ArrayList<ItemPointer> l = new ArrayList<ItemPointer>();
        if (string.startsWith("BIKE_OK:")) {
            string = string.replaceFirst("BIKE_OK:", "").replaceAll("\\[", "").replaceAll("'", "");
            string = string.substring(0, string.lastIndexOf(93));
            string = string.replaceAll("\\(", "");
            StringTokenizer tokenizer = new StringTokenizer(string, ")");
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                String[] toks = tok.split(",");
                if (toks.length != 4) continue;
                Location location = new Location(Integer.parseInt(toks[1]) - 1, Integer.parseInt(toks[2]));
                l.add(new ItemPointer(new File(toks[0]), location, location));
            }
        }
        return l.toArray(new ItemPointer[0]);
    }

    @Override
    public String inlineLocalVariable(RefactoringRequest request) {
        File editorFile = request.file;
        String s = "@@BIKE";
        s = new StringBuffer(String.valueOf(s)).append("inlineLocalVariable").toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(REF.getFileAbsolutePath((File)editorFile)).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginLine()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginCol()).toString();
        s = new StringBuffer(String.valueOf(s)).append("END@@").toString();
        String string = this.makeAction(s, request);
        this.communicateRefactorResult(string);
        return string;
    }

    @Override
    public String extractLocalVariable(RefactoringRequest request) {
        File editorFile = request.file;
        String s = "@@BIKE";
        s = new StringBuffer(String.valueOf(s)).append("extractLocalVariable").toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(REF.getFileAbsolutePath((File)editorFile)).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginLine()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getBeginCol()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getEndLine()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.getEndCol()).toString();
        s = new StringBuffer(String.valueOf(s)).append("|").append(request.inputName).toString();
        s = new StringBuffer(String.valueOf(s)).append("END@@").toString();
        String string = this.makeAction(s, request);
        this.communicateRefactorResult(string);
        return string;
    }

    private List<String> refactorResultAsList(String string) {
        ArrayList<String> l = new ArrayList<String>();
        if (string == null) {
            return l;
        }
        if (string.startsWith("BIKE_OK:")) {
            string = string.replaceFirst("BIKE_OK:", "").replaceAll("\\[", "").replaceAll("'", "");
            string = string.substring(0, string.lastIndexOf(93));
            StringTokenizer tokenizer = new StringTokenizer(string, ", ");
            while (tokenizer.hasMoreTokens()) {
                l.add(tokenizer.nextToken());
            }
        }
        return l;
    }

    private void communicateRefactorResult(String string) {
        List<String> l = this.refactorResultAsList(string);
        this.setLastRefactorResults((Tuple<IPyRefactoring, List<String>>)new Tuple((Object)this, l));
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    public boolean canFindDefinition() {
        return true;
    }

    @Override
    public boolean canInlineLocalVariable() {
        return true;
    }

    @Override
    public boolean canExtractLocalVariable() {
        return true;
    }

    @Override
    public boolean useDefaultRefactoringActionCycle() {
        return true;
    }

    @Override
    public void canRefactorNature(IPythonNature pythonNature) throws RuntimeException {
        try {
            if (!pythonNature.isPython()) {
                throw new RuntimeException("Can only do actions dependent on Bycicle Repair Man in Python projects.");
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

