/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.javaintegration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.AbstractJavaClassModule;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModuleInProject
extends AbstractJavaClassModule {
    private static final boolean DEBUG_CLASS_MODULE_IN_PROJECT = false;
    private static final int UNKNOWN = -1;
    private static final int IS_PACKAGE = 0;
    private static final int IS_CLASS = 1;
    private IJavaProject javaProject;
    private int moduleType = -1;
    private File file;

    protected JavaModuleInProject(String name, IJavaProject javaProject) {
        super(name);
        this.javaProject = javaProject;
        this.tokens = this.createTokens(name);
    }

    @Override
    public boolean isPackage() {
        if (this.moduleType == -1) {
            throw new RuntimeException("Still can't determine whether it's a package or not.");
        }
        return this.moduleType == 0;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    protected List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String completeClassDesc, String filterCompletionName) throws Exception {
        String contents;
        if (filterCompletionName != null) {
            contents = "new %s().%s";
            contents = StringUtils.format((String)contents, (Object[])new Object[]{completeClassDesc, completeClassDesc, filterCompletionName});
        } else {
            contents = "new %s().";
            contents = StringUtils.format((String)contents, (Object[])new Object[]{completeClassDesc, completeClassDesc});
        }
        return this.getJavaCompletionProposals(contents, contents.length(), filterCompletionName);
    }

    @Override
    protected List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String contents, int completionOffset, String filterCompletionName) throws Exception {
        try {
            IType type = this.javaProject.findType(this.name);
            ArrayList<Tuple<IJavaElement, CompletionProposal>> ret = new ArrayList<Tuple<IJavaElement, CompletionProposal>>();
            if (type != null) {
                this.getCompletionsForType(contents, filterCompletionName, type, ret);
            }
            if (this.moduleType == -1) {
                if (type == null) {
                    this.moduleType = 0;
                } else {
                    this.moduleType = 1;
                    this.file = new File(PydevPlugin.getIResourceOSString(type.getResource()));
                }
            }
            return ret;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IJavaElement findJavaElement(String javaClassModuleName) throws Exception {
        return this.javaProject.findType(javaClassModuleName);
    }

    private void getCompletionsForType(String contents, String filterCompletionName, IType type, List<Tuple<IJavaElement, CompletionProposal>> ret) throws JavaModelException {
        ICompilationUnit unit = type.getCompilationUnit();
        CompletionProposalCollector collector = this.createCollector(filterCompletionName, ret, unit);
        type.codeComplete(StringUtils.format((String)contents, (Object[])new Object[]{this.name}).toCharArray(), -1, 0, new char[0][0], new char[0][0], new int[0], false, (CompletionRequestor)collector);
    }
}

