/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.editor.codecompletion.PyCalltipsContextInformation;
import org.python.pydev.plugin.PydevPlugin;

public class PyContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    public PyCalltipsContextInformation fInformation;
    public IDocument doc;
    public int fCurrentParameter;
    public boolean returnedFalseOnce;
    private int fPosition;
    int[] commaPositions;

    public void install(IContextInformation info, IDocument doc, int offset) {
        this.returnedFalseOnce = false;
        this.fInformation = (PyCalltipsContextInformation)info;
        this.doc = doc;
        this.fPosition = this.fInformation.getReplacementOffset();
        this.fCurrentParameter = -1;
        this.commaPositions = null;
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        this.install(info, viewer.getDocument(), offset);
    }

    public boolean isContextInformationValid(int position) {
        IDocument document;
        block8: {
            block7: {
                if (this.doc == null) {
                    this.returnedFalseOnce = true;
                    return false;
                }
                if (position >= this.fPosition) break block7;
                this.returnedFalseOnce = true;
                return false;
            }
            document = this.doc;
            IRegion line = document.getLineInformationOfOffset(this.fPosition);
            if (position >= line.getOffset() && position < document.getLength()) break block8;
            this.returnedFalseOnce = true;
            return false;
        }
        try {
            boolean ret;
            boolean bl = ret = this.getCurrentParameter(document, this.fPosition, position, "(", ")", false) >= 0;
            if (!ret) {
                this.returnedFalseOnce = true;
            }
            return ret;
        }
        catch (BadLocationException badLocationException) {
            this.returnedFalseOnce = true;
            return false;
        }
        catch (Exception x) {
            this.returnedFalseOnce = true;
            PydevPlugin.log(x);
            return false;
        }
    }

    public boolean updatePresentation(int position, TextPresentation presentation) {
        int currentParameter = -1;
        try {
            currentParameter = this.getCurrentParameter(this.doc, this.fPosition, position, ",", "", true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this.fCurrentParameter != -1 && currentParameter == this.fCurrentParameter) {
            return false;
        }
        presentation.clear();
        this.fCurrentParameter = currentParameter;
        String s = this.fInformation.getInformationDisplayString();
        int[] commas = this.computeCommaPositions();
        if (commas.length - 2 < this.fCurrentParameter) {
            presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
            return true;
        }
        int start = commas[this.fCurrentParameter] + 1;
        int end = commas[this.fCurrentParameter + 1];
        if (start > 0) {
            presentation.addStyleRange(new StyleRange(0, start, null, null, 0));
        }
        if (end > start) {
            presentation.addStyleRange(new StyleRange(start, end - start, null, null, 1));
        }
        if (end < s.length()) {
            presentation.addStyleRange(new StyleRange(end, s.length() - end, null, null, 0));
        }
        return true;
    }

    private int[] computeCommaPositions() {
        if (this.commaPositions == null) {
            String code = this.fInformation.getInformationDisplayString();
            int length = code.length();
            int pos = 0;
            ArrayList<Integer> positions = new ArrayList<Integer>();
            positions.add(new Integer(-1));
            while (pos < length && pos != -1) {
                char ch = code.charAt(pos);
                switch (ch) {
                    case ',': {
                        positions.add(new Integer(pos));
                        break;
                    }
                }
                if (pos == -1) continue;
                ++pos;
            }
            positions.add(new Integer(length));
            int[] fields = new int[positions.size()];
            int i = 0;
            while (i < fields.length) {
                fields[i] = (Integer)positions.get(i);
                ++i;
            }
            this.commaPositions = fields;
        }
        return this.commaPositions;
    }

    public int getCurrentParameter(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        int nestingMode = 0;
        int nestingLevel = 0;
        int charCount = 0;
        int offset = start;
        block10: while (offset < end) {
            char curr = document.getChar(offset++);
            switch (curr) {
                case '#': {
                    if (offset >= end) continue block10;
                    offset = end;
                    break;
                }
                case '\"': 
                case '\'': {
                    int eaten = ParsingUtils.eatLiterals((Object)document, null, (int)(offset - 1)) + 1;
                    if (eaten <= offset) continue block10;
                    offset = eaten;
                    break;
                }
                case '[': {
                    if (considerNesting) {
                        if (nestingMode != 1 && nestingMode != 0) continue block10;
                        nestingMode = 1;
                        ++nestingLevel;
                        break;
                    }
                }
                case ']': {
                    if (considerNesting) {
                        if (nestingMode != true || --nestingLevel != 0) continue block10;
                        nestingMode = 0;
                        break;
                    }
                }
                case '(': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 3;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 3 && nestingMode != 0) continue block10;
                        nestingMode = 3;
                        ++nestingLevel;
                        break;
                    }
                }
                case ')': {
                    if (considerNesting) {
                        if (nestingMode != 3 || --nestingLevel != 0) continue block10;
                        nestingMode = 0;
                        break;
                    }
                }
                case '{': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 2;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 2 && nestingMode != 0) continue block10;
                        nestingMode = 2;
                        ++nestingLevel;
                        break;
                    }
                }
                case '}': {
                    if (considerNesting) {
                        if (nestingMode != 2 || --nestingLevel != 0) continue block10;
                        nestingMode = 0;
                        break;
                    }
                }
                default: {
                    if (nestingLevel != 0) continue block10;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                    }
                    if (decrements.indexOf(curr) < 0) continue block10;
                    --charCount;
                }
            }
        }
        return charCount;
    }
}

