/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.docutils.WordUtils;
import org.python.pydev.editor.codecompletion.PyCodeCompletion;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.PydevPrefs;

public class PyCodeCompletionPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_CODECOMPLETION = "USE_CODECOMPLETION";
    public static final boolean DEFAULT_USE_CODECOMPLETION = true;
    public static final String ATTEMPTS_CODECOMPLETION = "ATTEMPTS_CODECOMPLETION";
    public static final int DEFAULT_ATTEMPTS_CODECOMPLETION = 20;
    public static final String AUTOCOMPLETE_ON_DOT = "AUTOCOMPLETE_ON_DOT";
    public static final boolean DEFAULT_AUTOCOMPLETE_ON_DOT = true;
    public static final String AUTOCOMPLETE_ON_ALL_ASCII_CHARS = "AUTOCOMPLETE_ON_ALL_ASCII_CHARS";
    public static final boolean DEFAULT_AUTOCOMPLETE_ON_ALL_ASCII_CHARS = false;
    public static final String USE_AUTOCOMPLETE = "USE_AUTOCOMPLETE";
    public static final boolean DEFAULT_USE_AUTOCOMPLETE = true;
    public static final String AUTOCOMPLETE_DELAY = "AUTOCOMPLETE_DELAY";
    public static final int DEFAULT_AUTOCOMPLETE_DELAY = 0;
    public static final String AUTOCOMPLETE_ON_PAR = "AUTOCOMPLETE_ON_PAR";
    public static final boolean DEFAULT_AUTOCOMPLETE_ON_PAR = false;
    public static final String DEBUG_CODE_COMPLETION = "DEBUG_CODE_COMPLETION";
    public static final boolean DEFAULT_DEBUG_CODE_COMPLETION = false;
    public static final String ARGUMENTS_DEEP_ANALYSIS_N_CHARS = "DEEP_ANALYSIS_N_CHARS";
    public static final int DEFAULT_ARGUMENTS_DEEP_ANALYSIS_N_CHARS = 1;

    public PyCodeCompletionPreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new IntegerFieldEditor(ATTEMPTS_CODECOMPLETION, "Timeout to connect to shell (secs).", p));
        this.addField((FieldEditor)new IntegerFieldEditor(AUTOCOMPLETE_DELAY, "Autocompletion delay: ", p));
        String tooltip = WordUtils.wrap((String)"Determines the number of chars in the qualifier request for which constructs such as 'from xxx import yyy' should be analyzed to get its actual token and if it maps to a method, its paramaters will be added in the completion.", (int)80);
        IntegerFieldEditor deepAnalysisFieldEditor = new IntegerFieldEditor(ARGUMENTS_DEEP_ANALYSIS_N_CHARS, "Minimum number of chars in qualifier for\ndeep analysis for parameters in 'from' imports:", p);
        this.addField((FieldEditor)deepAnalysisFieldEditor);
        deepAnalysisFieldEditor.getLabelControl(p).setToolTipText(tooltip);
        deepAnalysisFieldEditor.getTextControl(p).setToolTipText(tooltip);
        this.addField((FieldEditor)new BooleanFieldEditor(USE_CODECOMPLETION, "Use code completion?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOCOMPLETE_ON_DOT, "Autocomplete on '.'?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOCOMPLETE_ON_PAR, "Autocomplete on '('?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOCOMPLETE_ON_PAR, "Autocomplete on ','?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOCOMPLETE_ON_ALL_ASCII_CHARS, "Autocomplete on all letter chars and '_'?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(DEBUG_CODE_COMPLETION, "Debug code completion?", p));
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        PyCodeCompletion.DEBUG_CODE_COMPLETION = PyCodeCompletionPreferencesPage.isToDebugCodeCompletion();
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean useCodeCompletion() {
        return PydevPrefs.getPreferences().getBoolean(USE_CODECOMPLETION);
    }

    public static int getNumberOfConnectionAttempts() {
        try {
            Preferences preferences = PydevPrefs.getPreferences();
            return preferences.getInt(ATTEMPTS_CODECOMPLETION);
        }
        catch (NullPointerException nullPointerException) {
            return 20;
        }
    }

    public static boolean isToAutocompleteOnDot() {
        return PydevPrefs.getPreferences().getBoolean(AUTOCOMPLETE_ON_DOT);
    }

    public static boolean isToAutocompleteOnPar() {
        return PydevPrefs.getPreferences().getBoolean(AUTOCOMPLETE_ON_PAR);
    }

    public static boolean useAutocomplete() {
        return PydevPrefs.getPreferences().getBoolean(USE_AUTOCOMPLETE);
    }

    public static boolean useAutocompleteOnAllAsciiChars() {
        return PydevPrefs.getPreferences().getBoolean(AUTOCOMPLETE_ON_ALL_ASCII_CHARS);
    }

    public static boolean isToDebugCodeCompletion() {
        if (PydevPlugin.getDefault() == null) {
            return false;
        }
        return PydevPrefs.getPreferences().getBoolean(DEBUG_CODE_COMPLETION);
    }

    public static int getAutocompleteDelay() {
        return PydevPrefs.getPreferences().getInt(AUTOCOMPLETE_DELAY);
    }

    public static int getArgumentsDeepAnalysisNChars() {
        if (PydevPlugin.getDefault() == null) {
            return 0;
        }
        return PydevPrefs.getPreferences().getInt(ARGUMENTS_DEEP_ANALYSIS_N_CHARS);
    }
}

