/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import com.rc.retroweaver.runtime.Autobox;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevMarkerUtils {
    public static void replaceMarkers(List<MarkerInfo> lst, IResource resource, String markerType) {
        IMarker[] existingMarkers;
        try {
            existingMarkers = resource.findMarkers(markerType, false, 0);
        }
        catch (CoreException e1) {
            PydevPlugin.log(e1);
            existingMarkers = new IMarker[]{};
        }
        int lastExistingUsed = 0;
        try {
            for (MarkerInfo markerInfo : lst) {
                if (lastExistingUsed < existingMarkers.length) {
                    IMarker marker = existingMarkers[lastExistingUsed];
                    marker.setAttributes((Map)markerInfo.getAsMap());
                    ++lastExistingUsed;
                    continue;
                }
                MarkerUtilities.createMarker((IResource)resource, (Map)markerInfo.getAsMap(), (String)markerType);
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        try {
            int i = lastExistingUsed;
            while (i < existingMarkers.length) {
                existingMarkers[i].delete();
                ++i;
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarkerInfo {
        public IDocument doc;
        public String message;
        public String markerType;
        public int severity;
        public boolean userEditable;
        public boolean isTransient;
        public int lineStart;
        public int colStart;
        public int lineEnd;
        public int absoluteStart = -1;
        public int absoluteEnd = -1;
        public int colEnd;
        public Map<String, Object> additionalInfo;

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int lineStart, int colStart, int lineEnd, int colEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = lineStart;
            this.colStart = colStart;
            this.lineEnd = lineEnd;
            this.colEnd = colEnd;
            this.additionalInfo = additionalInfo;
        }

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int line, int absoluteStart, int absoluteEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = line;
            this.lineEnd = line;
            this.absoluteStart = absoluteStart;
            this.absoluteEnd = absoluteEnd;
            this.additionalInfo = additionalInfo;
        }

        private HashMap<String, Object> getAsMap() throws BadLocationException {
            if (this.lineStart < 0) {
                this.lineStart = 0;
            }
            if (this.absoluteStart == -1 || this.absoluteEnd == -1) {
                IRegion start = this.doc.getLineInformation(this.lineStart);
                this.absoluteStart = start.getOffset() + this.colStart;
                if (this.lineEnd >= 0 && this.colEnd >= 0) {
                    IRegion end = this.doc.getLineInformation(this.lineEnd);
                    this.absoluteEnd = end.getOffset() + this.colEnd;
                } else {
                    String line = this.doc.get(start.getOffset(), start.getLength());
                    int i = line.indexOf(35);
                    FastStringBuffer buffer = i != -1 ? new FastStringBuffer(line.substring(0, i), 0) : new FastStringBuffer(line, 0);
                    while (buffer.length() > 0 && Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                        buffer.deleteLast();
                    }
                    this.absoluteEnd = start.getOffset() + buffer.length();
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("message", this.message);
            map.put("lineNumber", Autobox.valueOf((int)this.lineStart));
            map.put("charStart", Autobox.valueOf((int)this.absoluteStart));
            map.put("charEnd", Autobox.valueOf((int)this.absoluteEnd));
            map.put("severity", Autobox.valueOf((int)this.severity));
            map.put("userEditable", Autobox.valueOf((boolean)this.userEditable));
            map.put("transient", Autobox.valueOf((boolean)this.isTransient));
            if (this.additionalInfo != null) {
                map.putAll(this.additionalInfo);
            }
            return map;
        }
    }
}

