/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.debug.core.DebugException;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.DebuggerReader;
import org.python.pydev.debug.model.remote.DebuggerWriter;

public abstract class AbstractRemoteDebugger {
    protected Socket socket;
    protected DebuggerReader reader;
    protected DebuggerWriter writer;
    protected int sequence = -1;
    protected AbstractDebugTarget target = null;

    public abstract void dispose();

    public abstract void disconnect() throws DebugException;

    public AbstractDebugTarget getTarget() {
        return this.target;
    }

    public void setTarget(AbstractDebugTarget target) {
        this.target = target;
    }

    public int getNextSequence() {
        this.sequence += 2;
        return this.sequence;
    }

    public void addToResponseQueue(AbstractDebuggerCommand cmd) {
        this.reader.addToResponseQueue(cmd);
    }

    public void postCommand(AbstractDebuggerCommand cmd) {
        if (this.writer != null) {
            this.writer.postCommand(cmd);
        }
    }

    public void startTransmission() throws IOException {
        this.reader = new DebuggerReader(this.socket, this);
        this.writer = new DebuggerWriter(this.socket);
        Thread t = new Thread((Runnable)this.reader, "pydevd.reader");
        t.start();
        t = new Thread((Runnable)this.writer, "pydevd.writer");
        t.start();
    }
}

