/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableCollection;
import org.python.pydev.plugin.PydevPlugin;

public class PyDebugModelPresentation
implements IDebugModelPresentation {
    public static String PY_DEBUG_MODEL_ID = "org.python.pydev.debug";
    protected ListenerList fListeners = new ListenerList(1);
    protected boolean displayVariableTypeNames = false;

    public Image getImage(Object element) {
        ImageCache imageCache = PydevDebugPlugin.getImageCache();
        if (element instanceof PyBreakpoint) {
            try {
                PyBreakpoint pyBreakpoint = (PyBreakpoint)((Object)element);
                if (pyBreakpoint.isEnabled()) {
                    if (pyBreakpoint.isConditionEnabled()) {
                        return imageCache.get("icons/breakmarker_conditional.gif");
                    }
                    return imageCache.get("icons/breakmarker.gif");
                }
                if (pyBreakpoint.isConditionEnabled()) {
                    return imageCache.get("icons/breakmarker_gray_conditional.gif");
                }
                return imageCache.get("icons/breakmarker_gray.gif");
            }
            catch (CoreException e) {
                PydevDebugPlugin.log(4, "getImage error", e);
            }
        } else {
            if (element instanceof PyVariableCollection) {
                return imageCache.get("icons/greendot_big.gif");
            }
            if (element instanceof PyVariable) {
                return imageCache.get("icons/greendot.gif");
            }
            if (element instanceof PyDebugTarget || element instanceof PyThread || element instanceof PyStackFrame) {
                return null;
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PyBreakpoint) {
            PyBreakpoint pyBreakpoint = (PyBreakpoint)((Object)element);
            IMarker marker = ((PyBreakpoint)((Object)element)).getMarker();
            try {
                Map attrs = marker.getAttributes();
                String ioFile = pyBreakpoint.getFile();
                String fileName = "unknown";
                if (ioFile != null) {
                    File file = new File(ioFile);
                    fileName = file.getName();
                }
                Object lineNumber = attrs.get("lineNumber");
                String functionName = pyBreakpoint.getFunctionName();
                if (lineNumber == null) {
                    lineNumber = "unknown";
                }
                String location = String.valueOf(fileName) + ":" + lineNumber.toString();
                if (functionName == null) {
                    return location;
                }
                return String.valueOf(functionName) + " [" + location + "]";
            }
            catch (CoreException e) {
                PydevDebugPlugin.log(4, "error retreiving marker attributes", e);
                return "error";
            }
        }
        if (element instanceof AbstractDebugTarget || element instanceof PyStackFrame || element instanceof PyThread) {
            return null;
        }
        if (element instanceof PyVariableCollection || element instanceof PyVariable) {
            return null;
        }
        if (element instanceof IWatchExpression) {
            try {
                IWatchExpression watch_expression = (IWatchExpression)element;
                IValue value = watch_expression.getValue();
                if (value != null) {
                    return "\"" + watch_expression.getExpressionText() + "\"= " + value.getValueString();
                }
                return null;
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        if (element == null) {
            PydevDebugPlugin.log(4, "PyDebugModelPresentation: element == null", null);
            return null;
        }
        PydevDebugPlugin.log(4, "PyDebugModelPresentation:\nclass not expected for presentation:" + element.getClass() + "\n(returning default presentation).", null);
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof PyVariable) {
            try {
                ((PyVariable)value).getVariables();
                listener.detailComputed(value, ((PyVariable)value).getDetailText());
            }
            catch (DebugException e) {
                PydevDebugPlugin.errorDialog("Unexpected error fetching variable", e);
            }
        }
    }

    public IEditorInput getEditorInput(Object element) {
        String file;
        if (element instanceof PyBreakpoint && (file = ((PyBreakpoint)((Object)element)).getFile()) != null) {
            Path path = new Path(file);
            IEditorPart part = PydevPlugin.doOpenEditor((IPath)path, (boolean)false);
            return part.getEditorInput();
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return null;
    }

    public void setAttribute(String attribute, Object value) {
        if (attribute.equals("org.eclipse.debug.ui.displayVariableTypeNames")) {
            this.displayVariableTypeNames = (Boolean)value;
        } else {
            System.err.println("setattribute");
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }
}

