/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.REF;
import org.python.pydev.debug.codecoverage.CoverageCache;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.utils.PyFileListing;

public class PyCoverage {
    public CoverageCache cache = new CoverageCache();
    private static PyCoverage pyCoverage;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshCoverageInfo(File file, IProgressMonitor monitor) {
        this.cache.clear();
        if (file == null) {
            return;
        }
        try {
            if (!file.isDirectory()) {
                throw new RuntimeException("We can only get information on a dir.");
            }
            PyFileListing.PyFileListingInfo pyFilesBelow = new PyFileListing.PyFileListingInfo();
            if (file.exists()) {
                pyFilesBelow = PyFileListing.getPyFilesBelow((File)file, (IProgressMonitor)monitor, (boolean)true, (boolean)false);
            }
            if (pyFilesBelow.filesFound.size() == 0) {
                return;
            }
            boolean added = false;
            Iterator it = pyFilesBelow.foldersFound.iterator();
            while (true) {
                if (!it.hasNext()) {
                    String profileScript = PythonRunnerConfig.getCoverageScript();
                    String[] cmdLine = new String[]{PydevPlugin.getPythonInterpreterManager().getDefaultInterpreter(), profileScript, PyCoverage.getCoverageFileLocation(), "-waitfor"};
                    monitor.setTaskName("Starting shell to get info...");
                    monitor.worked(1);
                    Process p = null;
                    try {
                        Iterator iter;
                        String files;
                        BufferedReader in;
                        p = this.execute(cmdLine);
                        try {
                            p.exitValue();
                            throw new RuntimeException("Some error happened... the process could not be created.");
                        }
                        catch (Exception exception) {
                            int bufsize = 32;
                            in = new BufferedReader(new InputStreamReader(p.getInputStream()), bufsize);
                            files = "";
                            iter = pyFilesBelow.filesFound.iterator();
                        }
                        while (true) {
                            if (!iter.hasNext()) break;
                            String fStr = ((File)iter.next()).toString();
                            files = String.valueOf(files) + fStr + "|";
                        }
                        files = String.valueOf(files) + "\r";
                        monitor.setTaskName("Writing to shell...");
                        monitor.worked(1);
                        p.getOutputStream().write(files.getBytes());
                        p.getOutputStream().close();
                        String str = "";
                        monitor.setTaskName("Getting coverage info...(please wait, this could take a while)");
                        monitor.worked(1);
                        while (true) {
                            if ((str = in.readLine()) == null) {
                                in.close();
                                monitor.setTaskName("Waiting for process to finish...");
                                monitor.worked(1);
                                p.waitFor();
                                monitor.setTaskName("Finished");
                                return;
                            }
                            this.analyzeReadLine(monitor, str);
                        }
                    }
                    catch (Exception e) {
                        if (p != null) {
                            p.destroy();
                        }
                        e.printStackTrace();
                        return;
                    }
                }
                File f = (File)it.next();
                if (!added) {
                    this.cache.addFolder(f);
                    added = true;
                    continue;
                }
                this.cache.addFolder(f, f.getParentFile());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
    }

    private void analyzeReadLine(IProgressMonitor monitor, String str) {
        File f;
        boolean added = false;
        StringTokenizer tokenizer = new StringTokenizer(str, "@");
        int nTokens = tokenizer.countTokens();
        String[] strings = new String[nTokens];
        int k = 0;
        while (tokenizer.hasMoreElements()) {
            strings[k] = tokenizer.nextToken().trim();
            ++k;
        }
        if (nTokens == 5 || nTokens == 4) {
            try {
                if (!strings[1].equals("Stmts") && !strings[0].equals("TOTAL")) {
                    f = new File(strings[0]);
                    if (nTokens == 4) {
                        this.cache.addFile(f, f.getParentFile(), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]), "");
                        added = true;
                    } else {
                        this.cache.addFile(f, f.getParentFile(), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]), strings[4]);
                        added = true;
                    }
                    String[] strs = f.toString().replaceAll("/", " ").replaceAll("\\\\", " ").split(" ");
                    if (strs.length > 1) {
                        monitor.setTaskName("Getting coverage info..." + strs[strs.length - 1]);
                    } else {
                        monitor.setTaskName("Getting coverage info..." + f.toString());
                    }
                    monitor.worked(1);
                }
            }
            catch (RuntimeException e2) {
                e2.printStackTrace();
            }
        }
        if (!added) {
            try {
                f = new File(strings[0]);
                if (f.exists() && f.isFile() && !f.getName().equals(".coverage")) {
                    this.cache.addFile(f, f.getParentFile(), this.getError(strings));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getError(String[] strings) {
        StringBuffer ret = new StringBuffer();
        int i = 1;
        while (i < strings.length) {
            ret.append(String.valueOf(strings[i]) + " ");
            ++i;
        }
        return ret.toString();
    }

    public void clearInfo() {
        try {
            String profileScript = PythonRunnerConfig.getCoverageScript();
            String[] cmdLine = new String[]{PydevPlugin.getPythonInterpreterManager().getDefaultInterpreter(), profileScript, PyCoverage.getCoverageFileLocation(), "-e"};
            Process p = this.execute(cmdLine);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Process execute(String[] cmdLine) throws IOException {
        Process p = Runtime.getRuntime().exec(cmdLine, null);
        return p;
    }

    public static PyCoverage getPyCoverage() {
        if (pyCoverage == null) {
            pyCoverage = new PyCoverage();
        }
        return pyCoverage;
    }

    public static String getCoverageFileLocation() {
        IPath stateLocation = PydevDebugPlugin.getDefault().getStateLocation();
        stateLocation = stateLocation.append(".coverage");
        return REF.getFileAbsolutePath((File)stateLocation.toFile());
    }
}

