/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;

public class For
extends stmtType {
    public exprType target;
    public exprType iter;
    public stmtType[] body;
    public suiteType orelse;

    public For(exprType target, exprType iter, stmtType[] body, suiteType orelse) {
        this.target = target;
        this.iter = iter;
        this.body = body;
        this.orelse = orelse;
    }

    public For(exprType target, exprType iter, stmtType[] body, suiteType orelse, SimpleNode parent) {
        this(target, iter, body, orelse);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("For[");
        sb.append("target=");
        sb.append(this.dumpThis(this.target));
        sb.append(", ");
        sb.append("iter=");
        sb.append(this.dumpThis(this.iter));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("orelse=");
        sb.append(this.dumpThis(this.orelse));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(14, ostream);
        this.pickleThis(this.target, ostream);
        this.pickleThis(this.iter, ostream);
        this.pickleThis(this.body, ostream);
        this.pickleThis(this.orelse, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitFor(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.target != null) {
            this.target.accept(visitor);
        }
        if (this.iter != null) {
            this.iter.accept(visitor);
        }
        if (this.body != null) {
            int i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.orelse != null) {
            this.orelse.accept(visitor);
        }
    }
}

