/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;

public class Assign
extends stmtType {
    public exprType[] targets;
    public exprType value;

    public Assign(exprType[] targets, exprType value) {
        this.targets = targets;
        this.value = value;
    }

    public Assign(exprType[] targets, exprType value, SimpleNode parent) {
        this(targets, value);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Assign[");
        sb.append("targets=");
        sb.append(this.dumpThis(this.targets));
        sb.append(", ");
        sb.append("value=");
        sb.append(this.dumpThis(this.value));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(11, ostream);
        this.pickleThis(this.targets, ostream);
        this.pickleThis(this.value, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitAssign(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (this.targets != null) {
            int i = 0;
            while (i < this.targets.length) {
                if (this.targets[i] != null) {
                    this.targets[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.value != null) {
            this.value.accept(visitor);
        }
    }
}

