/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNode
implements Node,
ISimpleNode {
    private static final boolean DEBUG = false;
    public int beginLine;
    public int beginColumn;
    public SimpleNode parent;
    public List<Object> specialsBefore;
    public List<Object> specialsAfter;

    public int getId() {
        return -1;
    }

    public Object getImage() {
        return null;
    }

    public void setImage(Object image) {
    }

    public void addSpecial(Object special, boolean after) {
        if (special != null) {
            if (special instanceof Token) {
                Token t = (Token)special;
                commentType comment = new commentType(t.image.trim());
                comment.beginColumn = t.beginColumn;
                comment.beginLine = t.beginLine;
                special = comment;
            }
            if (after) {
                if (special instanceof commentType) {
                    this.getSpecialsAfter().add(special);
                } else {
                    int addAt = this.countAfter(special, false);
                    this.getSpecialsAfter().add(addAt, special);
                }
            } else if (special instanceof commentType) {
                commentType s = (commentType)special;
                if (s.beginLine < this.beginLine) {
                    this.getSpecialsBefore().add(this.countBefore(special, true), special);
                } else {
                    this.getSpecialsBefore().add(special);
                }
            } else {
                int addAt = this.countBefore(special, false);
                this.getSpecialsBefore().add(addAt, special);
            }
        }
    }

    public List<Object> getSpecialsBefore() {
        if (this.specialsBefore == null) {
            this.specialsBefore = new ArrayList<Object>();
        }
        return this.specialsBefore;
    }

    public List<Object> getSpecialsAfter() {
        if (this.specialsAfter == null) {
            this.specialsAfter = new ArrayList<Object>();
        }
        return this.specialsAfter;
    }

    private int countStrings() {
        List<Object> l = this.specialsAfter;
        return this.doCount(l);
    }

    private int countStringsBefore() {
        List<Object> l = this.specialsBefore;
        return this.doCount(l);
    }

    private int countAfter(Object special, boolean beforeRegularStrings) {
        int[] lineCol = this.getLineCol(special);
        if (lineCol == null) {
            return this.countStrings();
        }
        return this.getIndex(lineCol, this.specialsAfter, beforeRegularStrings);
    }

    private int countBefore(Object special, boolean beforeRegularStrings) {
        int[] lineCol = this.getLineCol(special);
        if (lineCol == null) {
            return this.countStringsBefore();
        }
        return this.getIndex(lineCol, this.specialsBefore, beforeRegularStrings);
    }

    private int getIndex(int[] lineCol, List l, boolean beforeRegularStrings) {
        if (l == null) {
            return 0;
        }
        int i = 0;
        for (Object o : l) {
            int[] existing = this.getLineCol(o);
            if (existing == null) {
                if (beforeRegularStrings) {
                    return i;
                }
            } else {
                if (existing[0] > lineCol[0]) {
                    return i;
                }
                if (existing[0] == lineCol[0] && existing[1] > lineCol[1]) {
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    private int[] getLineCol(Object o) {
        if (o instanceof SpecialStr) {
            SpecialStr s = (SpecialStr)o;
            return new int[]{s.beginLine, s.beginCol};
        }
        if (o instanceof commentType) {
            commentType c = (commentType)o;
            return new int[]{c.beginLine, c.beginColumn};
        }
        return null;
    }

    private int doCount(List l) {
        if (l == null) {
            return 0;
        }
        int i = 0;
        for (Object o : l) {
            if (!(o instanceof String) && !(o instanceof SpecialStr)) continue;
            ++i;
        }
        return i;
    }

    public String toString() {
        return new StringBuffer(String.valueOf(super.toString())).append(" at line ").append(this.beginLine).toString();
    }

    public String toString(String prefix) {
        return new StringBuffer(String.valueOf(prefix)).append(this.toString()).toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        throw new ParseException(new StringBuffer("Unexpected node: ").append(this).toString());
    }

    public void traverse(VisitorIF visitor) throws Exception {
        throw new ParseException(new StringBuffer("Unexpected node: ").append(this).toString());
    }

    protected String dumpThis(String s) {
        return s;
    }

    protected String dumpThis(Object o) {
        return String.valueOf(o);
    }

    protected String dumpThis(Object[] s) {
        StringBuffer sb = new StringBuffer();
        if (s == null) {
            sb.append("null");
        } else {
            sb.append("[");
            int i = 0;
            while (i < s.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(s[i]));
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected String dumpThis(int i) {
        return Integer.toString(i);
    }

    protected String dumpThis(int i, String[] names) {
        return names[i];
    }

    protected String dumpThis(int[] arr, String[] names) {
        StringBuffer sb = new StringBuffer();
        if (arr == null) {
            sb.append("null");
        } else {
            sb.append("[");
            int i = 0;
            while (i < arr.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(names[arr[i]]);
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected String dumpThis(boolean b) {
        return String.valueOf(b);
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        throw new IOException("Pickling not implemented");
    }

    protected void pickleThis(String s, DataOutputStream ostream) throws IOException {
        if (s == null) {
            ostream.writeInt(-1);
        } else {
            ostream.writeInt(s.length());
            ostream.writeBytes(s);
        }
    }

    protected void pickleThis(String[] s, DataOutputStream ostream) throws IOException {
        if (s == null) {
            ostream.writeInt(-1);
        } else {
            ostream.writeInt(s.length);
            int i = 0;
            while (i < s.length) {
                this.pickleThis(s[i], ostream);
                ++i;
            }
        }
    }

    protected void pickleThis(SimpleNode o, DataOutputStream ostream) throws IOException {
        if (o == null) {
            ostream.writeInt(-1);
        } else {
            o.pickle(ostream);
        }
    }

    protected void pickleThis(SimpleNode[] s, DataOutputStream ostream) throws IOException {
        if (s == null) {
            ostream.writeInt(-1);
        } else {
            ostream.writeInt(s.length);
            int i = 0;
            while (i < s.length) {
                this.pickleThis(s[i], ostream);
                ++i;
            }
        }
    }

    protected void pickleThis(int i, DataOutputStream ostream) throws IOException {
        ostream.writeInt(i);
    }

    protected void pickleThis(int[] arr, DataOutputStream ostream) throws IOException {
        if (arr == null) {
            ostream.writeInt(-1);
        } else {
            ostream.writeInt(arr.length);
            int i = 0;
            while (i < arr.length) {
                ostream.writeInt(arr[i]);
                ++i;
            }
        }
    }

    protected void pickleThis(boolean b, DataOutputStream ostream) throws IOException {
        ostream.writeBoolean(b);
    }

    protected void pickleThis(Object n, DataOutputStream ostream) throws IOException {
        String s = n.toString();
        ostream.writeInt(s.length());
        ostream.writeBytes(s);
    }
}

