/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.pages.listener;

import java.util.Observable;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.refactoring.ui.model.table.SimpleTableItem;
import org.python.pydev.refactoring.ui.pages.listener.IValidationPage;

public class TableCellEditorListener
extends Observable
implements Listener {
    private final Table table;
    private IValidationPage wizard;

    public TableCellEditorListener(IValidationPage wizard, Table parametersTable) {
        this.wizard = wizard;
        this.table = parametersTable;
    }

    public void handleEvent(Event event) {
        TableEditor editor = new TableEditor(this.table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        Rectangle clientArea = this.table.getClientArea();
        if (this.table.getSelection().length != 1) {
            return;
        }
        Rectangle bounds = this.table.getSelection()[0].getBounds();
        Point pt = new Point(bounds.x, bounds.y);
        int index = this.table.getTopIndex();
        while (index < this.table.getItemCount()) {
            boolean visible = false;
            SimpleTableItem item = (SimpleTableItem)this.table.getItem(index);
            int i = 0;
            while (i < this.table.getColumnCount()) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt)) {
                    Text text = new Text((Composite)this.table, 0);
                    TextListener textListener = new TextListener(item, text);
                    text.addListener(16, (Listener)textListener);
                    text.addListener(31, (Listener)textListener);
                    text.addListener(16, (Listener)this.wizard);
                    editor.setEditor((Control)text, (TableItem)item, i);
                    text.setText(item.getText(i));
                    text.selectAll();
                    text.setFocus();
                    return;
                }
                if (!visible && rect.intersects(clientArea)) {
                    visible = true;
                }
                ++i;
            }
            if (!visible) {
                return;
            }
            ++index;
        }
    }

    private final class TextListener
    implements Listener {
        private SimpleTableItem tableItem;
        private final Text text;

        private TextListener(SimpleTableItem item, Text text) {
            this.tableItem = item;
            this.text = text;
        }

        public void handleEvent(Event e) {
            if (e.type == 16) {
                this.tableItem.setText(this.text.getText());
                this.text.dispose();
                TableCellEditorListener.this.table.setFocus();
            } else if (e.type == 31) {
                if (e.detail == 4) {
                    this.tableItem.setText(this.text.getText());
                    e.doit = true;
                }
                if (e.detail == 4 || e.detail == 2) {
                    this.text.dispose();
                    if (e.detail == 2) {
                        e.doit = false;
                    }
                }
            }
        }
    }
}

